/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.QueryRequestMarshaller;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.xts.ext.XTSExt;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class CognosViewerSessionManager {
    private static final String SESSION_PASSPORT_NAME = "pp";
    private HashMap m_params = new HashMap();
    private CognosViewerServiceFactory m_serviceFactory = null;
    private ICognosViewerState m_state = null;
    private String m_sViewerSession = null;
    private boolean m_bNewlyBuiltSession = false;
    private String m_sNameValueDelimiter = ":";
    private String m_sParameterDelimiter = "|";

    public CognosViewerSessionManager() {
    }

    public CognosViewerSessionManager(CognosViewerServiceFactory serviceFactory, ICognosViewerState state) throws CognosViewerException {
        this.m_serviceFactory = serviceFactory;
        this.m_state = state;
        String sSessionCookie = null;
        if (CognosViewerSystemParams.getSystemParamAttribute("delimiters", "d1").length() != 0) {
            this.m_sParameterDelimiter = CognosViewerSystemParams.getSystemParamAttribute("delimiters", "d1");
        }
        if (CognosViewerSystemParams.getSystemParamAttribute("delimiters", "d2").length() != 0) {
            this.m_sNameValueDelimiter = CognosViewerSystemParams.getSystemParamAttribute("delimiters", "d2");
        }
        if (this.m_state.getBusEnvelope().getCookieValue("cc_session") != null && (sSessionCookie = this.m_state.getBusEnvelope().getCookieValue("cc_session")) != null) {
            try {
                if (!CognosViewerDispatcherHandlerState.isMasters() && !XTSExt.isCCSessionValid((String)sSessionCookie, (String)this.m_state.getBusEnvelope().getPassportID(), (String)this.m_sParameterDelimiter, (String)this.m_sNameValueDelimiter)) {
                    sSessionCookie = null;
                }
            }
            catch (Exception e) {
                sSessionCookie = null;
                IPFLogger.getInstance().info("Exception in validating CC session", this.getClass().getName());
            }
        }
        if (sSessionCookie == null && (sSessionCookie = this.m_state.getBusEnvelope().getCookieValue("viewer_session")) != null) {
            try {
                if (!XTSExt.isCCSessionValid((String)sSessionCookie, (String)this.m_state.getBusEnvelope().getPassportID(), (String)this.m_sParameterDelimiter, (String)this.m_sNameValueDelimiter)) {
                    sSessionCookie = null;
                }
            }
            catch (Exception e) {
                sSessionCookie = null;
                IPFLogger.getInstance().info("Exception in validating CC session", this.getClass().getName());
            }
        }
        if (sSessionCookie == null) {
            CMServerResponse cmResponse = this.getSessionInfoFromCM();
            this.createViewerSession(cmResponse);
            if (this.m_sViewerSession != null) {
                this.setParamsFromSession(this.m_sViewerSession, this.m_sParameterDelimiter, this.m_sNameValueDelimiter);
            }
        } else {
            this.setParamsFromSession(sSessionCookie, this.m_sParameterDelimiter, this.m_sNameValueDelimiter);
        }
    }

    public void createViewerSession(CMServerResponse cmResponse) throws CognosViewerException {
        if (cmResponse != null) {
            String sEncodedUserName = "";
            String sEncodedSearchPath = "";
            try {
                String sSearchPath;
                String sUserName = cmResponse.getProperty("defaultName", 1);
                if (sUserName.length() > 0) {
                    sEncodedUserName = EncodingUtility.encodeCCSessionValue(sUserName);
                }
                if ((sSearchPath = cmResponse.getProperty("searchPath", 1)).length() > 0) {
                    sEncodedSearchPath = EncodingUtility.encodeCCSessionValue(sSearchPath);
                }
            }
            catch (Exception ex) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
            String sUIg = this.buildUIGroupList(cmResponse);
            int iActiveNamespaceCount = cmResponse.getCount("*[local-name()='queryResponse']/returns/item[position() = 2]/queryResult/item/active[value = 'true']");
            int iTraversableNamespaces = cmResponse.getCount("*[local-name()='queryResponse']/returns/item[position() = 2]/queryResult/item/permissions/value[item = 'traverse']");
            boolean bShowLogon = iActiveNamespaceCount > iTraversableNamespaces;
            StringBuffer sbViewerSession = new StringBuffer();
            sbViewerSession.append("uig").append(this.m_sNameValueDelimiter).append(sUIg);
            sbViewerSession.append(this.m_sParameterDelimiter).append("e_hp").append(this.m_sNameValueDelimiter).append(sEncodedSearchPath);
            sbViewerSession.append(this.m_sParameterDelimiter).append("e_user").append(this.m_sNameValueDelimiter).append(sEncodedUserName);
            sbViewerSession.append(this.m_sParameterDelimiter).append("show_logon").append(this.m_sNameValueDelimiter).append(bShowLogon);
            String sCAMPassport = this.m_state.getBusEnvelope().getPassportID();
            if (sCAMPassport != null) {
                sbViewerSession.append(this.m_sParameterDelimiter).append(SESSION_PASSPORT_NAME).append(this.m_sNameValueDelimiter).append(XTSExt.substringAfterLast((String)sCAMPassport, (String)":"));
            }
            this.m_sViewerSession = XTSExt.protectCCSessionCookie((String)sbViewerSession.toString(), (String)this.m_state.getBusEnvelope().getPassportID(), (String)this.m_sParameterDelimiter, (String)this.m_sNameValueDelimiter, null);
            this.setIsNewSession(true);
        }
    }

    public String buildUIGroupList(CMServerResponse cmResponse) throws CognosViewerException {
        StringBuffer sUIGroupList = new StringBuffer("");
        Element systemUIGroups = CognosViewerSystemParams.getSystemParamNode("ui_groups");
        Element identity = cmResponse.getComplexProperty("identity", 3);
        if (systemUIGroups != null && identity != null) {
            List uiGroups = systemUIGroups.selectNodes("group");
            for (Element uiGroup : uiGroups) {
                String sGroupStoreID = uiGroup.getStringValue();
                String sId = uiGroup.attributeValue("id");
                if (sId.length() >= 3 || identity.selectSingleNode("value/item[storeID/value = '" + sGroupStoreID + "']") == null) continue;
                sUIGroupList.append(' ');
                sUIGroupList.append(sId);
                sUIGroupList.append(' ');
            }
        }
        String sEncodedUIGroup = "";
        try {
            if (sUIGroupList.length() > 0) {
                sEncodedUIGroup = EncodingUtility.encodeCCSessionValue(sUIGroupList.toString());
            }
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
        return sEncodedUIGroup;
    }

    private CMServerResponse getSessionInfoFromCM() {
        CMServerResponse cmResponse = null;
        if (this.m_serviceFactory != null) {
            QueryRequest userNameRequest = new QueryRequest();
            userNameRequest.setSearch("~");
            userNameRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath});
            QueryRequest namespaceRequest = new QueryRequest();
            namespaceRequest.setSearch("/directory/*[@objectClass='namespace']");
            namespaceRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.permissions, PropEnum.active});
            QueryRequest userIdentityRequest = new QueryRequest();
            userIdentityRequest.setSearch("~~");
            userIdentityRequest.setProperties(new PropEnum[]{PropEnum.identity});
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new QueryRequestMarshaller(new QueryRequest[]{userNameRequest, namespaceRequest, userIdentityRequest})};
            try {
                ICognosViewerRequest cmRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
                cmResponse = (CMServerResponse)cmRequest.executeRequest("queryMultiple", this.m_state, arguments, "");
            }
            catch (CognosViewerException cognosViewerException) {
                this.m_state.getIPFLogger().error(cognosViewerException.getMessage(), cognosViewerException, this.getClass().getName());
                return null;
            }
        }
        return cmResponse;
    }

    private void setParamsFromSession(String sSession, String sArrayDelimeter, String sNameValuePairDelimeter) throws CognosViewerException {
        int iArrayItemDelimeterIndex = 0;
        String sSessionCookie = sSession;
        while (sSessionCookie.length() > 0) {
            int iNameValuePairDelimeterIndex;
            String sNameValuePairItem;
            iArrayItemDelimeterIndex = sSessionCookie.indexOf(sArrayDelimeter);
            if (iArrayItemDelimeterIndex == 0) {
                sSessionCookie = sSessionCookie.substring(1);
                continue;
            }
            if (iArrayItemDelimeterIndex != -1) {
                sNameValuePairItem = sSessionCookie.substring(0, iArrayItemDelimeterIndex);
                sSessionCookie = sSessionCookie.substring(iArrayItemDelimeterIndex + 1);
            } else {
                sNameValuePairItem = sSessionCookie;
                sSessionCookie = "";
            }
            if ((iNameValuePairDelimeterIndex = sNameValuePairItem.indexOf(sNameValuePairDelimeter)) <= 0) continue;
            String sName = sNameValuePairItem.substring(0, iNameValuePairDelimeterIndex);
            String sValue = sNameValuePairItem.substring(iNameValuePairDelimeterIndex + 1);
            if (sName.startsWith("e_") || sName.equals("uig")) {
                try {
                    String sDecodedValue = EncodingUtility.decodeCCSessionValue(sValue);
                    this.m_params.put(sName, sDecodedValue);
                    continue;
                }
                catch (Exception exception) {
                    CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                    throw cognosViewerException;
                }
            }
            this.m_params.put(sName, sValue);
        }
    }

    public String getSessionParam(String name) {
        if (this.m_params.containsKey(name)) {
            return (String)this.m_params.get(name);
        }
        return "";
    }

    public void setSessionParam(String key, String value) {
        this.m_params.put(key, value);
    }

    public String getViewerSession() {
        return this.m_sViewerSession;
    }

    public void setViewerSession(String session) {
        this.m_sViewerSession = session;
    }

    public boolean isNewSession() {
        return this.m_bNewlyBuiltSession;
    }

    public void setIsNewSession(boolean isNew) {
        this.m_bNewlyBuiltSession = isNew;
    }
}

