/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.ccs.annotations.AAnnotationSession;
import com.cognos.ccs.annotations.AnnotationSession;
import com.cognos.ccs.exceptions.CCSAnnAuthenticationException;
import com.cognos.ccs.exceptions.CCSAnnGeneralException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.DebugLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Element;

public class CommentManager {
    private ICognosViewerState m_state;
    private AAnnotationSession m_session;

    public CommentManager(ICognosViewerState state) {
        this.m_state = state;
        this.m_session = null;
    }

    protected AAnnotationSession getSession() throws CognosViewerException {
        if (this.m_session == null) {
            if (this.m_state.getFormFieldAsString("mock.test.annotation").length() > 0) {
                try {
                    this.createSession(Class.forName(this.m_state.getFormFieldAsString("mock.test.annotation")));
                }
                catch (ClassNotFoundException e) {
                    this.handleException(e);
                }
            } else {
                this.createSession(AnnotationSession.class);
            }
        }
        return this.m_session;
    }

    private void createSession(Class delegateClass) throws CognosViewerException {
        try {
            Constructor con = delegateClass.getConstructor(String.class, String.class, Cookie[].class, BIBusEnvelope.class);
            String widgetStoreID = this.m_state.getFormFieldAsString("widgetStoreID");
            this.m_session = (AAnnotationSession)con.newInstance(widgetStoreID, null, new Cookie[0], this.m_state.getBusEnvelope());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof CCSAnnAuthenticationException) {
                throw new CognosViewerException(this.m_state.getBusEnvelope(), (CCSAnnAuthenticationException)cause);
            }
            if (cause != null && cause instanceof Exception) {
                this.handleException((Exception)cause);
            } else {
                this.handleException(e);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String addComment() throws CognosViewerException {
        String result = "";
        try {
            String commentId = this.m_state.getFormFieldAsString("cv.commentId");
            String commentDesc = this.m_state.getFormFieldAsString("cv.commentDesc");
            String commentLayoutId = this.m_state.getFormFieldAsString("cv.commentLayoutId");
            String contextJSON = this.m_state.getFormFieldAsString("cv.context");
            String metadataJSON = this.m_state.getFormFieldAsString("cv.metatdata");
            String parameterValues = this.m_state.getFormFieldAsString("cv.filterContext_prompts");
            String sliderDetails = this.m_state.getFormFieldAsString("cv.filterContext_sliders");
            String filterDetails = this.m_state.getFormFieldAsString("cv.filterContext_filter");
            result = this.getSession().addAnnotation(contextJSON, metadataJSON, commentId, commentDesc, commentLayoutId, parameterValues, sliderDetails, filterDetails);
        }
        catch (CCSAnnAuthenticationException authenticationException) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), authenticationException);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public String getComments() throws CognosViewerException {
        String jsonObject = "";
        String contextJSON = this.m_state.getFormFieldAsString("cv.context");
        String metadataJSON = this.m_state.getFormFieldAsString("cv.metatdata");
        try {
            this.cleanSOAPHeader();
            if (this.isJSON(contextJSON) && this.isJSON(metadataJSON)) {
                String firstFiveChars;
                DebugLogger logger = this.m_state.getDebugLogger();
                if (logger != null) {
                    logger.startTimedEvent("Other", "Time spent in Annotation Service", "Other");
                }
                jsonObject = this.getSession().getAnnotations(contextJSON, metadataJSON);
                if (logger != null) {
                    logger.endTimedEvent("Other");
                }
                String string = firstFiveChars = jsonObject != null && jsonObject.length() >= 5 ? jsonObject.substring(0, 5) : "";
                if ("empty".equals(firstFiveChars)) {
                    jsonObject = null;
                }
            }
        }
        catch (CCSAnnAuthenticationException authenticationException) {
            throw new CognosViewerException(this.m_state.getBusEnvelope(), authenticationException);
        }
        catch (CCSAnnGeneralException ccsAnnGeneralException) {
            Element fault = ccsAnnGeneralException.getSourceFault();
            this.handleException((Exception)((Object)ccsAnnGeneralException), fault.elementText("faultstring"));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return jsonObject;
    }

    private void cleanSOAPHeader() {
        BIBusEnvelope biBusEnvelope = this.m_state.getBusEnvelope();
        if (biBusEnvelope != null) {
            biBusEnvelope.removeFormValue("cv.context");
            biBusEnvelope.removeFormValue("cv.metatdata");
        }
    }

    private void handleException(Exception e) throws CognosViewerException {
        this.handleException(e, e.getMessage());
    }

    private void handleException(Exception e, String message) throws CognosViewerException {
        throw new CognosViewerException(this.m_state.getBusEnvelope(), message, e);
    }

    private boolean isJSON(String json) {
        return json != null && json.startsWith("{");
    }
}

