/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.ccs.content.RDSSchema;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.XMLUtility;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class GoDashboardPreprocessor {
    private RDSSchema m_Schema = RDSSchema.getInstance();
    private ICognosViewerState m_state = null;

    public GoDashboardPreprocessor(ICognosViewerState state) {
        this.m_state = state;
    }

    public ParameterValue[] parsePromptAnswers(String promptAnswers) {
        try {
            Document doc = XMLUtility.createXMLDocument(promptAnswers);
            Element eRoot = doc.getRootElement();
            List promptValues = eRoot.elements(this.m_Schema.getPValuesQN().getName());
            Vector<ParameterValue> parameterValues = new Vector<ParameterValue>();
            for (Element promptValue : promptValues) {
                parameterValues.add(this.parsePromptValues(promptValue));
            }
            ParameterValue[] parameterValuesArray = new ParameterValue[parameterValues.size()];
            return parameterValues.toArray(parameterValuesArray);
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
            return null;
        }
    }

    private ParameterValue parsePromptValues(Element ePromptValue) {
        ParameterValue parameterValue = new ParameterValue();
        Element eName = ePromptValue.element(this.m_Schema.getPNameQN().getName());
        if (eName != null) {
            parameterValue.setName(eName.getTextTrim());
        }
        Element eValues = ePromptValue.element(this.m_Schema.getPItemValuesQN().getName());
        List items = eValues.elements(this.m_Schema.getPItemQN().getName());
        Iterator it = items.iterator();
        Element eItem = null;
        Element eItemValue = null;
        ParmValueItem[] parmValueItems = new ParmValueItem[items.size()];
        int iCount = 0;
        while (it.hasNext()) {
            eItem = (Element)it.next();
            if (eItem.element(this.m_Schema.getSimplePValueQN().getName()) != null) {
                eItemValue = eItem.element(this.m_Schema.getSimplePValueQN().getName());
                parmValueItems[iCount] = this.parseSimpleValue(eItemValue);
            } else if (eItem.element(this.m_Schema.getRangePValueQN().getName()) != null) {
                BoundRangeParmValueItem item;
                eItemValue = eItem.element(this.m_Schema.getRangePValueQN().getName());
                Element eStart = eItemValue.element(this.m_Schema.getStartQN().getName());
                Element eEnd = eItemValue.element(this.m_Schema.getEndQN().getName());
                String inclusive = eItemValue.element(this.m_Schema.getInclusiveQN().getName()).getTextTrim();
                if (eStart != null && eEnd != null) {
                    item = new BoundRangeParmValueItem();
                    item.setStart(this.parseSimpleValue(eStart));
                    item.setEnd(this.parseSimpleValue(eEnd));
                    item.setInclusive(inclusive.equals("true") || inclusive.equals("1"));
                    parmValueItems[iCount] = item;
                } else if (eStart != null) {
                    item = new UnboundedEndRangeParmValueItem();
                    item.setStart(this.parseSimpleValue(eStart));
                    item.setInclusive(inclusive.equals("true") || inclusive.equals("1"));
                    parmValueItems[iCount] = item;
                } else {
                    item = new UnboundedStartRangeParmValueItem();
                    item.setEnd(this.parseSimpleValue(eEnd));
                    item.setInclusive(inclusive.equals("true") || inclusive.equals("1"));
                    parmValueItems[iCount] = item;
                }
            } else {
                this.m_state.getIPFLogger().error("Unknown prompt type", this.getClass().getName());
            }
            ++iCount;
        }
        parameterValue.setValue(parmValueItems);
        return parameterValue;
    }

    private SimpleParmValueItem parseSimpleValue(Element eItemValue) {
        SimpleParmValueItem parmItem = new SimpleParmValueItem();
        Element eInclusive = eItemValue.element(this.m_Schema.getInclusiveQN().getName());
        String inclusive = eInclusive.getTextTrim();
        if (inclusive.equals("true") || inclusive.equals("1")) {
            parmItem.setInclusive(true);
        } else {
            parmItem.setInclusive(false);
        }
        Element eUseValue = eItemValue.element(this.m_Schema.getUseValueQN().getName());
        Attribute nill = eUseValue.attribute("nill");
        if (nill != null && "TRUE".equals(nill.getValue())) {
            parmItem.setUse(null);
        } else {
            String useValue = eUseValue.getText();
            parmItem.setUse(useValue);
        }
        if (eItemValue.element(this.m_Schema.getDisplayValueQN().getName()) != null) {
            String displayValue = eItemValue.element(this.m_Schema.getDisplayValueQN().getName()).getTextTrim();
            parmItem.setDisplay(displayValue);
        }
        return parmItem;
    }
}

