/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchOptionBoolean;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheOptionEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionBoolean;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionInt;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionPropEnumArray;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionRefPropArray;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionString;
import com.cognos.developer.schemas.bibus._3.ContextFormatEnum;
import com.cognos.developer.schemas.bibus._3.ContextOptionEnum;
import com.cognos.developer.schemas.bibus._3.ContextOptionFormat;
import com.cognos.developer.schemas.bibus._3.ContextOptionStringArray;
import com.cognos.developer.schemas.bibus._3.ContextOptionType;
import com.cognos.developer.schemas.bibus._3.ContextTypeEnum;
import com.cognos.developer.schemas.bibus._3.DataEnum;
import com.cognos.developer.schemas.bibus._3.DrillOptionEnum;
import com.cognos.developer.schemas.bibus._3.DrillOptionParameterValues;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OutputEncapsulationEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionAnyURI;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.ReportSaveAsEnum;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionBoolean;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionEnum;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionSpecificationFormat;
import com.cognos.developer.schemas.bibus._3.RunOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionData;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionNameValueArray;
import com.cognos.developer.schemas.bibus._3.RunOptionOutputEncapsulation;
import com.cognos.developer.schemas.bibus._3.RunOptionSaveAs;
import com.cognos.developer.schemas.bibus._3.RunOptionString;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.SpecificationFormatEnum;
import com.cognos.developer.schemas.bibus._3.SpecificationOptionEnum;
import com.cognos.developer.schemas.bibus._3.SpecificationOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.XMLUtility;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OptionManager {
    private HashMap m_options = new HashMap();
    private static HashMap m_OptionsConstructors = new HashMap();

    private static void initializeGenericOptionConstructor(Class classObject) {
        try {
            m_OptionsConstructors.put("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts", classObject.getMethod("newGenericOptionBoolean", String.class, Object[].class));
            m_OptionsConstructors.put("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures", classObject.getMethod("newGenericOptionBoolean", String.class, Object[].class));
            m_OptionsConstructors.put("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context", classObject.getMethod("newGenericOptionXMLEncodedXML", String.class, Object[].class));
            m_OptionsConstructors.put("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled", classObject.getMethod("newGenericOptionBoolean", String.class, Object[].class));
            m_OptionsConstructors.put("genericAnyURIOption", classObject.getMethod("newGenericOptionAnyURI", String.class, Object[].class));
            m_OptionsConstructors.put("genericBooleanOption", classObject.getMethod("newGenericOptionBoolean", String.class, Object[].class));
            m_OptionsConstructors.put("genericXMLEncodedXMLOption", classObject.getMethod("newGenericOptionXMLEncodedXML", String.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeGenericOptionConstructor: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializeContentManagerQueryOptionConstructor(Class classObject) {
        try {
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.maximumDataBytes.getValue(), classObject.getMethod("newContentManagerQueryOptionInt", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.maximumObjects.getValue(), classObject.getMethod("newContentManagerQueryOptionInt", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.permission.getValue(), classObject.getMethod("newContentManagerQueryOptionString", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.properties.getValue(), classObject.getMethod("newContentManagerQueryOptionProperies", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.referenceProperties.getValue(), classObject.getMethod("newContentManagerQueryOptionReferenceProperties", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.schemaInfo.getValue(), classObject.getMethod("newContentManagerQueryOptionBoolean", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.skipDataBytes.getValue(), classObject.getMethod("newContentManagerQueryOptionInt", ContentManagerQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContentManagerQueryOptionEnum.skipObjects.getValue(), classObject.getMethod("newContentManagerQueryOptionInt", ContentManagerQueryOptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeContentManagerQueryOptionConstructor: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializePowerPlay8OptionConstructor(Class classObject) {
        try {
            m_OptionsConstructors.put(PowerPlay8OptionEnum.outputLocation.getValue() + "_pp", classObject.getMethod("newPowerPlay8OptionAnyURI", PowerPlay8OptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializePowerPlay8OptionConstructor: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializeContextOptionConstructors(Class classObject) {
        try {
            m_OptionsConstructors.put(ContextOptionEnum.format.getValue(), classObject.getMethod("newContextOptionFormat", ContextOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContextOptionEnum.type.getValue(), classObject.getMethod("newContextOptionType", ContextOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ContextOptionEnum.selection.getValue(), classObject.getMethod("newContextOptionSelection", ContextOptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeContextOptionConstructors: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializeAsynchOptionConstructors(Class classObject) {
        try {
            m_OptionsConstructors.put(AsynchOptionEnum.alwaysIncludePrimaryRequest.getValue(), classObject.getMethod("newAsynchOptionBoolean", AsynchOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(AsynchOptionEnum.attachmentEncoding.getValue(), classObject.getMethod("newAsynchOptionEncoding", AsynchOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(AsynchOptionEnum.primaryWaitThreshold.getValue(), classObject.getMethod("newAsynchOptionInt", AsynchOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(AsynchOptionEnum.secondaryWaitThreshold.getValue(), classObject.getMethod("newAsynchOptionInt", AsynchOptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeAsynchOptionConstructors: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializeRunOptionConstructors(Class classObject) {
        try {
            m_OptionsConstructors.put(RunOptionEnum.burst.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.continueConversation.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.credentialParameters.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.cssURL.getValue(), classObject.getMethod("newRunOptionAnyURI", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.data.getValue(), classObject.getMethod("newRunOptionData", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.layoutParameters.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.maximumValueCount.getValue(), classObject.getMethod("newRunOptionInt", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.metadataModel.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputEncapsulation.getValue(), classObject.getMethod("newRunOptionOutputEncapsulation", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputFormat.getValue(), classObject.getMethod("newRunOptionStringArray", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputLocale.getValue(), classObject.getMethod("newRunOptionLanguageArray", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputPageDefinition.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputPageOrientation.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.outputLocation.getValue(), classObject.getMethod("newRunOptionAnyURI", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.print.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.printer.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.printerAddress.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.prompt.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.promptFormat.getValue(), classObject.getMethod("newRunOptionString", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.returnOutputWhenAvailable.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.returnSpecification.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.saveAs.getValue(), classObject.getMethod("newRunOptionSaveAs", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.saveOutput.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.skipValueCount.getValue(), classObject.getMethod("newRunOptionInt", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.selectionBasedFeatures.getValue(), classObject.getMethod("newRunOptionBoolean", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.verticalElements.getValue(), classObject.getMethod("newRunOptionInt", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(RunOptionEnum.xslURL.getValue(), classObject.getMethod("newRunOptionAnyURI", RunOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(DrillOptionEnum.up.getValue(), classObject.getMethod("newDrillOptionParameterValues", DrillOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(SpecificationOptionEnum.editSpecification.getValue(), classObject.getMethod("newSpecificationOptionEditSpecification", SpecificationOptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeRunOptionConstructors: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    private static void initializeReportServiceQueryOptionConstructors(Class classObject) {
        try {
            m_OptionsConstructors.put(ReportServiceQueryOptionEnum.specificationFormat.getValue(), classObject.getMethod("newReportServiceQueryOptionSpecificationFormat", ReportServiceQueryOptionEnum.class, Object[].class));
            m_OptionsConstructors.put(ReportServiceQueryOptionEnum.upgrade.getValue(), classObject.getMethod("newReportServiceQueryOptionBoolean", ReportServiceQueryOptionEnum.class, Object[].class));
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in initializeRunOptionConstructors: " + exception.getMessage(), exception, OptionManager.class.getName());
        }
    }

    public void addOptions(HashMap aOptions) {
        if (aOptions.values() == null || aOptions.values().isEmpty()) {
            return;
        }
        for (String sOption : aOptions.keySet()) {
            if (this.m_options.get(sOption) != null) continue;
            this.m_options.put(sOption, aOptions.get(sOption));
        }
    }

    public void addOptions(Option[] aOptions, boolean bOverwrite) throws CognosViewerException {
        if (aOptions != null && aOptions.length > 0) {
            for (int index = 0; index < aOptions.length; ++index) {
                String sOptionName;
                Option option = aOptions[index];
                Element rootNode = DocumentHelper.createElement((String)"root");
                OptionMarshaller marshaller = new OptionMarshaller(new Option[]{option});
                try {
                    marshaller.marshall(rootNode);
                }
                catch (Exception e) {
                    CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
                    throw cognosViewerException;
                }
                Element optionNameNode = (Element)rootNode.selectSingleNode("./*/*[local-name()='item']/*[local-name()='name']");
                if (optionNameNode == null || this.m_options.containsKey(sOptionName = optionNameNode.getText()) && !bOverwrite) continue;
                this.m_options.put(sOptionName, option);
            }
        }
    }

    public void addOption(String sOption, String sValue) throws CognosViewerException {
        this.addOption(sOption, new Object[]{sValue});
    }

    public void addOption(String sOption, Boolean bValue) throws CognosViewerException {
        this.addOption(sOption, new Object[]{bValue});
    }

    public void addOption(String sOption, Object[] sValue) throws CognosViewerException {
        String[] saOptionSpecification = sOption.split("\\.", 2);
        if (saOptionSpecification.length == 2) {
            String sOptionClass = saOptionSpecification[0];
            String sFirstChar = sOptionClass.substring(0, 1);
            String sUpperCaseChar = sFirstChar.toUpperCase();
            String sMethodName = "load" + sOptionClass.replaceFirst(sFirstChar, sUpperCaseChar) + "Option";
            try {
                Method method = this.getClass().getMethod(sMethodName, String.class, Object[].class);
                method.invoke((Object)this, saOptionSpecification[1], sValue);
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                throw cognosViewerException;
            }
        }
    }

    public void loadAsynchOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        AsynchOptionEnum asynchOptionEnum = AsynchOptionEnum.fromString((String)sOptionEnum);
        if (!this.m_options.containsKey(asynchOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(asynchOptionEnum.getValue()), new Object[]{asynchOptionEnum, sOptionValue});
        }
    }

    public void loadGenericOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if ("http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context".equals(sOptionEnum)) {
            this.loadContentManagerCacheOption(sOptionEnum, sOptionValue);
        } else if ("http://developer.cognos.com/ceba/constants/systemOptionEnum#accessibilityFeatures".equals(sOptionEnum)) {
            this.loadSystemOption(sOptionEnum, sOptionValue);
        } else {
            String[] saOptionSpecification = sOptionEnum.split("\\.", 2);
            if (saOptionSpecification.length == 2) {
                String sOptionClass = saOptionSpecification[0];
                String sFirstChar = sOptionClass.substring(0, 1);
                String sUpperCaseChar = sFirstChar.toUpperCase();
                String sMethodName = "loadGeneric" + sOptionClass.replaceFirst(sFirstChar, sUpperCaseChar) + "Option";
                try {
                    Method method = this.getClass().getMethod(sMethodName, String.class, Object[].class);
                    method.invoke((Object)this, saOptionSpecification[1], sOptionValue);
                }
                catch (Exception exception) {
                    CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                    throw cognosViewerException;
                }
            }
        }
    }

    public void loadContentManagerCacheOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        String sContentManagerCacheOptionEnum = ContentManagerCacheOptionEnum.fromString((String)sOptionEnum).toString();
        if (!this.m_options.containsKey(sContentManagerCacheOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(sContentManagerCacheOptionEnum), new Object[]{sContentManagerCacheOptionEnum, sOptionValue});
        }
    }

    public void loadReportServiceQueryOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        ReportServiceQueryOptionEnum reportServiceQueryOptionEnum = ReportServiceQueryOptionEnum.fromString((String)sOptionEnum);
        if (!this.m_options.containsKey(reportServiceQueryOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(reportServiceQueryOptionEnum.getValue()), new Object[]{reportServiceQueryOptionEnum, sOptionValue});
        }
    }

    public void loadPowerPlay8Option(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        PowerPlay8OptionEnum powerPlay8OptionEnum;
        String[] saOptionSpecification = sOptionEnum.split("\\_");
        String sActualOptionEnum = "";
        if (saOptionSpecification.length == 2) {
            sActualOptionEnum = saOptionSpecification[0];
        }
        if (!this.m_options.containsKey(powerPlay8OptionEnum = PowerPlay8OptionEnum.fromString((String)sActualOptionEnum))) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(sOptionEnum), new Object[]{powerPlay8OptionEnum, sOptionValue});
        }
    }

    public void loadContentManagerQueryOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        ContentManagerQueryOptionEnum contentManagerQueryOptionEnum = ContentManagerQueryOptionEnum.fromString((String)sOptionEnum);
        if (!this.m_options.containsKey(contentManagerQueryOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(contentManagerQueryOptionEnum.getValue()), new Object[]{contentManagerQueryOptionEnum, sOptionValue});
        }
    }

    public void newAsynchOptionBoolean(AsynchOptionEnum asynchOptionEnum, Object[] sOptionValue) {
        AsynchOptionBoolean asynchOptionBoolean = new AsynchOptionBoolean();
        asynchOptionBoolean.setName(asynchOptionEnum);
        asynchOptionBoolean.setValue(Boolean.valueOf((String)sOptionValue[0]).booleanValue());
        this.m_options.put(asynchOptionEnum.toString(), asynchOptionBoolean);
    }

    public void newAsynchOptionInt(AsynchOptionEnum asynchOptionEnum, Object[] sOptionValue) {
        AsynchOptionInt asynchOptionInt = new AsynchOptionInt();
        asynchOptionInt.setName(asynchOptionEnum);
        asynchOptionInt.setValue(Integer.parseInt((String)sOptionValue[0]));
        this.m_options.put(asynchOptionEnum.toString(), asynchOptionInt);
    }

    public void newAsynchOptionEncoding(AsynchOptionEnum asynchOptionEnum, Object[] sOptionValue) {
        String sEncodingEnumValue = (String)sOptionValue[0];
        AsynchOptionEncoding asynchOptionEncodingEnum = new AsynchOptionEncoding();
        asynchOptionEncodingEnum.setName(asynchOptionEnum);
        EncodingEnum encodingEnum = EncodingEnum.fromString((String)sEncodingEnumValue);
        asynchOptionEncodingEnum.setValue(encodingEnum);
        this.m_options.put(asynchOptionEnum.toString(), asynchOptionEncodingEnum);
    }

    public void loadRunOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        String sRunOptionEnumValue = sOptionEnum;
        RunOptionEnum runOptionEnum = RunOptionEnum.fromString((String)sRunOptionEnumValue);
        if (!this.m_options.containsKey(runOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(runOptionEnum.getValue()), new Object[]{runOptionEnum, sOptionValue});
        }
    }

    public void loadSystemOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if ("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts".equals(sOptionEnum) && "false".equals(sOptionValue[0])) {
            return;
        }
        if (!this.m_options.containsKey(sOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(sOptionEnum), new Object[]{sOptionEnum, sOptionValue});
        }
    }

    public void loadGenericAnyURIOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if (!this.m_options.containsKey(sOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get("genericAnyURIOption"), new Object[]{sOptionEnum, sOptionValue});
        }
    }

    public void loadGenericBooleanOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if (!this.m_options.containsKey(sOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get("genericBooleanOption"), new Object[]{sOptionEnum, sOptionValue});
        }
    }

    public void loadGenericXMLEncodedXMLOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if (!this.m_options.containsKey(sOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get("genericXMLEncodedXMLOption"), new Object[]{sOptionEnum, sOptionValue});
        }
    }

    public void loadBiDirectionalOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        if (!this.m_options.containsKey(sOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(sOptionEnum), new Object[]{sOptionEnum, sOptionValue});
        }
    }

    public void newRunOptionBoolean(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        RunOptionBoolean runOptionBoolean = new RunOptionBoolean();
        runOptionBoolean.setName(runOptionEnum);
        runOptionBoolean.setValue(Boolean.valueOf((String)sOptionValue[0]).booleanValue());
        this.m_options.put(runOptionEnum.toString(), runOptionBoolean);
    }

    public void newRunOptionAnyURI(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String sRunOptionAnyURIValue = (String)sOptionValue[0];
        RunOptionAnyURI runOptionAnyURI = new RunOptionAnyURI();
        runOptionAnyURI.setName(runOptionEnum);
        runOptionAnyURI.setValue(sRunOptionAnyURIValue);
        this.m_options.put(runOptionEnum.toString(), runOptionAnyURI);
    }

    public void newRunOptionData(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String sRunOptionDataValue = (String)sOptionValue[0];
        RunOptionData runOptionData = new RunOptionData();
        runOptionData.setName(runOptionEnum);
        runOptionData.setValue(DataEnum.fromString((String)sRunOptionDataValue));
        this.m_options.put(runOptionEnum.toString(), runOptionData);
    }

    public void newRunOptionStringArray(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String[] sRunOptionStringArrayValues = new String[sOptionValue.length];
        System.arraycopy(sOptionValue, 0, sRunOptionStringArrayValues, 0, sOptionValue.length);
        RunOptionStringArray runOptionStringArray = new RunOptionStringArray();
        runOptionStringArray.setName(runOptionEnum);
        runOptionStringArray.setValue(sRunOptionStringArrayValues);
        this.m_options.put(runOptionEnum.toString(), runOptionStringArray);
    }

    public void newRunOptionInt(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        RunOptionInt runOptionInt = new RunOptionInt();
        runOptionInt.setName(runOptionEnum);
        runOptionInt.setValue(Integer.parseInt((String)sOptionValue[0]));
        this.m_options.put(runOptionEnum.toString(), runOptionInt);
    }

    public void newRunOptionString(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String sRunOptionStringValue = (String)sOptionValue[0];
        RunOptionString runOptionString = new RunOptionString();
        runOptionString.setName(runOptionEnum);
        runOptionString.setValue(sRunOptionStringValue);
        this.m_options.put(runOptionEnum.toString(), runOptionString);
    }

    public void newRunOptionOutputEncapsulation(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String sRunOptionStringValue = (String)sOptionValue[0];
        RunOptionOutputEncapsulation runOptionOutputEncapsulation = new RunOptionOutputEncapsulation();
        runOptionOutputEncapsulation.setName(runOptionEnum);
        runOptionOutputEncapsulation.setValue(OutputEncapsulationEnum.fromString((String)sRunOptionStringValue));
        this.m_options.put(runOptionEnum.toString(), runOptionOutputEncapsulation);
    }

    public void newRunOptionLanguageArray(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        String[] sRunOptionLanguageArrayValues = new String[sOptionValue.length];
        System.arraycopy(sOptionValue, 0, sRunOptionLanguageArrayValues, 0, sOptionValue.length);
        RunOptionLanguageArray runOptionLanguageArray = new RunOptionLanguageArray();
        runOptionLanguageArray.setName(runOptionEnum);
        runOptionLanguageArray.setValue(sRunOptionLanguageArrayValues);
        this.m_options.put(runOptionEnum.toString(), runOptionLanguageArray);
    }

    public void loadContextOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        String sContextOptionEnumValue = sOptionEnum;
        ContextOptionEnum contextOptionEnum = ContextOptionEnum.fromString((String)sContextOptionEnumValue);
        if (!this.m_options.containsKey(contextOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(contextOptionEnum.getValue()), new Object[]{contextOptionEnum, sOptionValue});
        }
    }

    public void newRunOptionSaveAs(RunOptionEnum runOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        try {
            RunOptionSaveAs runOptionSaveAs = new RunOptionSaveAs();
            runOptionSaveAs.setName(RunOptionEnum.saveAs);
            String sOptionSpecification = (String)sOptionValue[0];
            Document document = XMLUtility.createXMLDocument(sOptionSpecification);
            Element root = document.getRootElement();
            Element objectClass = root.element("objectClass");
            runOptionSaveAs.setObjectClass(ReportSaveAsEnum.fromString((String)objectClass.getText()));
            Element objectNames = root.element("objectNames");
            List objectNamesList = objectNames.elements("objectName");
            int listSize = objectNamesList.size();
            MultilingualToken[] saveAsNames = new MultilingualToken[listSize];
            for (int index = 0; index < listSize; ++index) {
                Element objectName = (Element)objectNamesList.get(index);
                Element local = objectName.element("locale");
                Element value = objectName.element("value");
                saveAsNames[index] = new MultilingualToken();
                saveAsNames[index].setLocale(local.getText().trim());
                saveAsNames[index].setValue(value.getText());
            }
            runOptionSaveAs.setObjectName(saveAsNames);
            Element parentSearchPath = root.element("parentSearchPath");
            runOptionSaveAs.setParentSearchPath(parentSearchPath.getText());
            this.m_options.put(runOptionEnum.toString(), runOptionSaveAs);
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, "An invalid specification was provided - " + exception.getMessage(), exception);
            throw cognosViewerException;
        }
    }

    public void newRunOptionNameValueArray(RunOptionEnum runOptionEnum, Object[] sOptionValue) {
        NameValue[] nameValueArray = new NameValue[sOptionValue.length];
        System.arraycopy(sOptionValue, 0, nameValueArray, 0, sOptionValue.length);
        RunOptionNameValueArray runOptionNameValueArray = new RunOptionNameValueArray();
        runOptionNameValueArray.setName(runOptionEnum);
        runOptionNameValueArray.setValue(nameValueArray);
        this.m_options.put(runOptionEnum.toString(), runOptionNameValueArray);
    }

    public void newContextOptionFormat(ContextOptionEnum contextOptionEnum, Object[] sOptionValue) {
        String sContextFormatValue = (String)sOptionValue[0];
        ContextOptionFormat contextOptionFormat = new ContextOptionFormat();
        contextOptionFormat.setName(contextOptionEnum);
        contextOptionFormat.setValue(ContextFormatEnum.fromString((String)sContextFormatValue));
        this.m_options.put(contextOptionEnum.toString(), contextOptionFormat);
    }

    public void newContextOptionType(ContextOptionEnum contextOptionEnum, Object[] sOptionValue) {
        String sContextOptionTypeValue = (String)sOptionValue[0];
        ContextOptionType contextOptionType = new ContextOptionType();
        contextOptionType.setName(contextOptionEnum);
        contextOptionType.setValue(ContextTypeEnum.fromString((String)sContextOptionTypeValue));
        this.m_options.put(contextOptionEnum.toString(), contextOptionType);
    }

    public void newContextOptionSelection(ContextOptionEnum contextOptionEnum, Object[] sOptionValue) {
        String[] sContextOptionSelectionValue = ((String)sOptionValue[0]).split(",");
        ContextOptionStringArray contextOptionStringArray = new ContextOptionStringArray();
        contextOptionStringArray.setName(contextOptionEnum);
        contextOptionStringArray.setValue(sContextOptionSelectionValue);
        this.m_options.put(contextOptionEnum.toString(), contextOptionStringArray);
    }

    public void newPowerPlay8OptionAnyURI(PowerPlay8OptionEnum powerPlay8OptionEnum, Object[] sOptionValue) {
        String sPowerPlay8OptionAnyURIValue = (String)sOptionValue[0];
        PowerPlay8OptionAnyURI powerPlay8OptionAnyURI = new PowerPlay8OptionAnyURI();
        powerPlay8OptionAnyURI.setName(powerPlay8OptionEnum);
        powerPlay8OptionAnyURI.setValue(sPowerPlay8OptionAnyURIValue);
        this.m_options.put(powerPlay8OptionEnum.toString(), powerPlay8OptionAnyURI);
    }

    public void newGenericOptionBoolean(String systemOptionName, Object[] sOptionValue) {
        GenericOptionBoolean genericOptionBoolean = new GenericOptionBoolean();
        genericOptionBoolean.setName(systemOptionName);
        genericOptionBoolean.setValue(Boolean.valueOf((String)sOptionValue[0]).booleanValue());
        this.m_options.put(systemOptionName, genericOptionBoolean);
    }

    public void newGenericOptionXMLEncodedXML(String optionName, Object[] sOptionValue) {
        GenericOptionXMLEncodedXML genericOptionXMLEncodedXML = new GenericOptionXMLEncodedXML();
        genericOptionXMLEncodedXML.setName(optionName);
        genericOptionXMLEncodedXML.setValue(new XmlEncodedXML((String)sOptionValue[0]));
        this.m_options.put(optionName, genericOptionXMLEncodedXML);
    }

    public void newGenericOptionAnyURI(String optionName, Object[] sOptionValue) {
        GenericOptionAnyURI genericOptionAnyURI = new GenericOptionAnyURI();
        genericOptionAnyURI.setName(optionName);
        genericOptionAnyURI.setValue((String)sOptionValue[0]);
        this.m_options.put(optionName, genericOptionAnyURI);
    }

    public void invokeConstructorMethod(Method constructorMethod, Object[] arguments) throws CognosViewerException {
        if (constructorMethod != null) {
            try {
                constructorMethod.invoke((Object)this, arguments);
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                throw cognosViewerException;
            }
        }
    }

    public HashMap getOptions() {
        return this.m_options;
    }

    public Option getOption(String sOptionName) {
        return (Option)this.m_options.get(sOptionName);
    }

    public void addOption(String sOptionName, Option option) {
        this.m_options.put(sOptionName, option);
    }

    public void clear() {
        this.m_options.clear();
    }

    public Option[] toArray() {
        HashMap optionsMap = this.getOptions();
        int iLength = optionsMap.size();
        Option[] options = new Option[iLength];
        Iterator optionsIterator = optionsMap.values().iterator();
        for (int iCurrentParameterIndex = 0; iCurrentParameterIndex < iLength; ++iCurrentParameterIndex) {
            Option option;
            options[iCurrentParameterIndex] = option = (Option)optionsIterator.next();
        }
        return options;
    }

    public void loadDrillOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        DrillOptionEnum drillOptionEnum = DrillOptionEnum.fromString((String)sOptionEnum);
        if (!this.m_options.containsKey(drillOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(drillOptionEnum.getValue()), new Object[]{drillOptionEnum, sOptionValue});
        }
    }

    public void addDrillOption(String sDrillOptionName, Element drillParameters, String sDrillRefQuery) {
        DrillOptionParameterValues drillOption = new DrillOptionParameterValues();
        drillOption.setName(DrillOptionEnum.fromString((String)sDrillOptionName));
        List drillOptionParametersList = drillParameters.elements("DrillGroup");
        if (drillOptionParametersList != null) {
            int iListSize = drillOptionParametersList.size();
            ParameterValue[] drillOptionParameterValues = new ParameterValue[iListSize];
            for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                Element drillGroup = (Element)drillOptionParametersList.get(iIndex);
                Element dataItem = drillGroup.element("DataItem");
                Element mun = drillGroup.element("MUN");
                if (dataItem == null || mun == null) continue;
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.setName(dataItem.getText());
                SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
                simpleParmValueItem.setInclusive(true);
                simpleParmValueItem.setUse(mun.getText());
                if (sDrillRefQuery.length() != 0) {
                    simpleParmValueItem.setDisplay(sDrillRefQuery);
                }
                parameterValue.setValue((ParmValueItem[])new SimpleParmValueItem[]{simpleParmValueItem});
                drillOptionParameterValues[iIndex] = parameterValue;
            }
            drillOption.setValue(drillOptionParameterValues);
            this.addOption(drillOption.getName().toString(), (Option)drillOption);
        }
    }

    public void newDrillOptionParameterValues(DrillOptionEnum drillOptionEnum, Object[] sOptionValue) {
        DrillOptionParameterValues drillOptionParameterValue = new DrillOptionParameterValues();
        drillOptionParameterValue.setName(drillOptionEnum);
        ParameterValue parameterValue = new ParameterValue();
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        simpleParmValueItem.setInclusive(false);
        simpleParmValueItem.setUse((String)sOptionValue[0]);
        parameterValue.setValue(new ParmValueItem[]{simpleParmValueItem});
        drillOptionParameterValue.setValue(new ParameterValue[]{parameterValue});
        this.m_options.put(drillOptionEnum.toString(), drillOptionParameterValue);
    }

    public void loadSpecificationOption(String sOptionEnum, Object[] sOptionValue) throws CognosViewerException {
        SpecificationOptionEnum specificationOptionEnum = SpecificationOptionEnum.fromString((String)sOptionEnum);
        if (!this.m_options.containsKey(specificationOptionEnum)) {
            this.invokeConstructorMethod((Method)m_OptionsConstructors.get(specificationOptionEnum.getValue()), new Object[]{specificationOptionEnum, sOptionValue});
        }
    }

    public void newSpecificationOptionEditSpecification(SpecificationOptionEnum specificationOptionEnum, Object[] sOptionValue) {
        SpecificationOptionXMLEncodedXML specificationOptionXMLEncodedXML = new SpecificationOptionXMLEncodedXML();
        specificationOptionXMLEncodedXML.setName(specificationOptionEnum);
        specificationOptionXMLEncodedXML.setValue(new XmlEncodedXML((String)sOptionValue[0]));
        this.m_options.put(specificationOptionEnum.toString(), specificationOptionXMLEncodedXML);
    }

    public void newReportServiceQueryOptionSpecificationFormat(ReportServiceQueryOptionEnum rsqOptionEnum, Object[] sOptionValue) {
        String sSpecificationFormatEnumValue = (String)sOptionValue[0];
        ReportServiceQueryOptionSpecificationFormat reportServiceQueryOptionSpecificationFormat = new ReportServiceQueryOptionSpecificationFormat();
        reportServiceQueryOptionSpecificationFormat.setName(rsqOptionEnum);
        SpecificationFormatEnum specificationFormatEnum = SpecificationFormatEnum.fromString((String)sSpecificationFormatEnumValue);
        reportServiceQueryOptionSpecificationFormat.setValue(specificationFormatEnum);
        this.m_options.put(specificationFormatEnum.toString(), reportServiceQueryOptionSpecificationFormat);
    }

    public void newReportServiceQueryOptionBoolean(ReportServiceQueryOptionEnum rsqOptionEnum, Object[] sOptionValue) {
        ReportServiceQueryOptionBoolean reportServiceQueryOptionBoolean = new ReportServiceQueryOptionBoolean();
        reportServiceQueryOptionBoolean.setName(rsqOptionEnum);
        reportServiceQueryOptionBoolean.setValue(Boolean.valueOf((String)sOptionValue[0]).booleanValue());
        this.m_options.put(rsqOptionEnum.toString(), reportServiceQueryOptionBoolean);
    }

    public void newContentManagerQueryOptionInt(ContentManagerQueryOptionEnum contentManagerQueryOptionEnum, Object[] sOptionValue) {
        ContentManagerQueryOptionInt contentManagerQueryOptionInt = new ContentManagerQueryOptionInt();
        contentManagerQueryOptionInt.setName(contentManagerQueryOptionEnum);
        contentManagerQueryOptionInt.setValue(Integer.parseInt((String)sOptionValue[0]));
        this.m_options.put(contentManagerQueryOptionEnum.toString(), contentManagerQueryOptionInt);
    }

    public void newContentManagerQueryOptionBoolean(ContentManagerQueryOptionEnum contentManagerQueryOptionEnum, Object[] sOptionValue) {
        ContentManagerQueryOptionBoolean contentManagerQueryOptionBoolean = new ContentManagerQueryOptionBoolean();
        contentManagerQueryOptionBoolean.setName(contentManagerQueryOptionEnum);
        contentManagerQueryOptionBoolean.setValue(Boolean.valueOf((String)sOptionValue[0]).booleanValue());
        this.m_options.put(contentManagerQueryOptionEnum.toString(), contentManagerQueryOptionBoolean);
    }

    public void newContentManagerQueryOptionString(ContentManagerQueryOptionEnum contentManagerQueryOptionEnum, Object[] sOptionValue) {
        ContentManagerQueryOptionString contentManagerQueryOptionString = new ContentManagerQueryOptionString();
        contentManagerQueryOptionString.setName(contentManagerQueryOptionEnum);
        contentManagerQueryOptionString.setValue((String)sOptionValue[0]);
        this.m_options.put(contentManagerQueryOptionEnum.toString(), contentManagerQueryOptionString);
    }

    public void newContentManagerQueryOptionProperies(ContentManagerQueryOptionEnum contentManagerQueryOptionEnum, Object[] sOptionValue) {
        ContentManagerQueryOptionPropEnumArray contentManagerQueryOptionPropEnumArray = new ContentManagerQueryOptionPropEnumArray();
        contentManagerQueryOptionPropEnumArray.setName(contentManagerQueryOptionEnum);
        contentManagerQueryOptionPropEnumArray.setValue((PropEnum[])sOptionValue);
        this.m_options.put(contentManagerQueryOptionEnum.toString(), contentManagerQueryOptionPropEnumArray);
    }

    public void newContentManagerQueryOptionReferenceProperties(ContentManagerQueryOptionEnum contentManagerQueryOptionEnum, Object[] sOptionValue) {
        ContentManagerQueryOptionRefPropArray contentManagerQueryOptionRefPropArray = new ContentManagerQueryOptionRefPropArray();
        contentManagerQueryOptionRefPropArray.setName(contentManagerQueryOptionEnum);
        contentManagerQueryOptionRefPropArray.setValue((RefProp[])sOptionValue);
        this.m_options.put(contentManagerQueryOptionRefPropArray.toString(), contentManagerQueryOptionRefPropArray);
    }

    public void setPrimaryWaitThreshold(String primaryWait, boolean onlySetIfMissing) throws CognosViewerException {
        this.addOptionWithConfigValueOverride("ViewerPrimaryWaitThreshold", "asynch.primaryWaitThreshold", primaryWait, onlySetIfMissing);
    }

    public void setPrimaryWaitThreshold(String primaryWait) throws CognosViewerException {
        this.addOptionWithConfigValueOverride("ViewerPrimaryWaitThreshold", "asynch.primaryWaitThreshold", primaryWait, false);
    }

    public void setSecondaryWaitThreshold(String secondaryWait, boolean onlySetIfMissing) throws CognosViewerException {
        this.addOptionWithConfigValueOverride("ViewerSecondaryWaitThreshold", "asynch.secondaryWaitThreshold", secondaryWait, onlySetIfMissing);
    }

    public void setSecondaryWaitThreshold(String secondaryWait) throws CognosViewerException {
        this.addOptionWithConfigValueOverride("ViewerSecondaryWaitThreshold", "asynch.secondaryWaitThreshold", secondaryWait, false);
    }

    private void addOptionWithConfigValueOverride(String propertyName, String optionName, String value, boolean onlySetIfMissing) throws CognosViewerException {
        String override = CognosViewerDispatcherHandler.getConfigValues().getProperty(propertyName);
        if (override != null) {
            this.addOption(optionName, override);
        } else if (value != null) {
            if (onlySetIfMissing) {
                String[] saOptionSpecification = optionName.split("\\.", 2);
                if (saOptionSpecification.length == 2 && this.getOption(saOptionSpecification[1]) == null) {
                    this.addOption(optionName, value);
                }
            } else {
                this.addOption(optionName, value);
            }
        }
    }

    static {
        OptionManager.initializeAsynchOptionConstructors(OptionManager.class);
        OptionManager.initializeRunOptionConstructors(OptionManager.class);
        OptionManager.initializeContextOptionConstructors(OptionManager.class);
        OptionManager.initializeReportServiceQueryOptionConstructors(OptionManager.class);
        OptionManager.initializePowerPlay8OptionConstructor(OptionManager.class);
        OptionManager.initializeGenericOptionConstructor(OptionManager.class);
        OptionManager.initializeContentManagerQueryOptionConstructor(OptionManager.class);
    }
}

