/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.utility.XMLUtility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParameterValueManager {
    private HashMap m_parameterValues = new HashMap();
    private ArrayList<String> m_cascadingPromptParametersToClear = new ArrayList();
    private HashMap<String, String> m_RAPParameterUpdateMap = new HashMap();

    public void addParameterValue(String name, String value) throws CognosViewerException {
        if (name.startsWith("p_")) {
            name = name.substring(2, name.length());
        }
        if (value.startsWith("<selectChoices")) {
            try {
                this.processSelectChoices(name, value);
            }
            catch (Exception ex) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
        } else {
            this.addSimpleParmValueItem(name, value);
        }
    }

    public void addParametersToClear(String name) {
        if (name.startsWith("cp_")) {
            name = name.substring(3, name.length());
        }
        this.m_cascadingPromptParametersToClear.add(name);
    }

    public void addSimpleParmValueItem(String sName, String sValue) {
        this.addSimpleParmValueItem(sName, sValue, sValue);
    }

    public void addSimpleParmValueItem(String sName, String sDisplayValue, String sUseValue) {
        ParameterValue parameterValue = this.makeParameterValue(sName);
        if (sDisplayValue.length() > 0 && sUseValue.length() > 0) {
            SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
            simpleParmValueItem.setInclusive(true);
            simpleParmValueItem.setDisplay(sDisplayValue);
            simpleParmValueItem.setUse(sUseValue);
            this.addParmValueItems(parameterValue, new ParmValueItem[]{simpleParmValueItem});
        }
    }

    public ParameterValue makeParameterValue(String name) {
        ParameterValue parameterValue = this.getParameterValue(name);
        if (parameterValue == null) {
            parameterValue = new ParameterValue();
            parameterValue.setName(name);
            parameterValue.setValue(new ParmValueItem[0]);
            this.m_parameterValues.put(name, parameterValue);
        }
        return parameterValue;
    }

    public void addParmValueItems(ParameterValue parameterValue, ParmValueItem[] appendParmValueItems) {
        ParmValueItem[] parmValueItems = null;
        ParmValueItem[] currentParmValueItems = parameterValue.getValue();
        if (currentParmValueItems != null) {
            parmValueItems = new ParmValueItem[currentParmValueItems.length + appendParmValueItems.length];
            System.arraycopy(currentParmValueItems, 0, parmValueItems, 0, currentParmValueItems.length);
            System.arraycopy(appendParmValueItems, 0, parmValueItems, currentParmValueItems.length, appendParmValueItems.length);
        } else {
            parmValueItems = appendParmValueItems;
        }
        parameterValue.setValue(parmValueItems);
    }

    public ParameterValue getParameterValue(String name) {
        return (ParameterValue)this.m_parameterValues.get(name);
    }

    public HashMap getParameterValues() {
        for (String paramName : this.m_cascadingPromptParametersToClear) {
            if (!this.m_parameterValues.containsKey(paramName)) continue;
            this.m_parameterValues.remove(paramName);
        }
        return this.m_parameterValues;
    }

    public ParameterValue[] toArray() {
        HashMap parameterValuesMap = this.getParameterValues();
        int iLength = parameterValuesMap.size();
        ParameterValue[] parameterValues = new ParameterValue[iLength];
        Iterator parameterValuesIterator = parameterValuesMap.values().iterator();
        for (int iCurrentParameterIndex = 0; iCurrentParameterIndex < iLength; ++iCurrentParameterIndex) {
            ParameterValue parameterValue;
            parameterValues[iCurrentParameterIndex] = parameterValue = (ParameterValue)parameterValuesIterator.next();
        }
        return parameterValues;
    }

    private void processSelectChoices(String sName, String sValue) throws CognosViewerException {
        try {
            Document document = XMLUtility.createXMLDocument(sValue);
            Element selectChoices = document.getRootElement();
            List selectChoicesList = selectChoices.elements();
            int iNumberOfSelectChoicesNodes = selectChoicesList.size();
            ParameterValue parameterValue = this.makeParameterValue(sName);
            ParmValueItem[] parmValueItems = new ParmValueItem[iNumberOfSelectChoicesNodes];
            for (int iIndex = 0; iIndex < iNumberOfSelectChoicesNodes; ++iIndex) {
                Element selectChoice = (Element)selectChoicesList.get(iIndex);
                String sParmValueItemType = selectChoice.getName();
                String sFirstChar = sParmValueItemType.substring(0, 1);
                String sUpperCaseChar = sFirstChar.toUpperCase();
                String sMethodName = "load" + sParmValueItemType.replaceFirst(sFirstChar, sUpperCaseChar);
                try {
                    Method method = this.getClass().getMethod(sMethodName, Element.class);
                    parmValueItems[iIndex] = (ParmValueItem)method.invoke((Object)this, selectChoice);
                    continue;
                }
                catch (Exception exception) {
                    parmValueItems[iIndex] = null;
                    CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                    throw cognosViewerException;
                }
            }
            this.addParmValueItems(parameterValue, parmValueItems);
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public ParmValueItem loadSelectOption(Element selectOption) {
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        if (selectOption.attributeCount() > 0) {
            if (selectOption.attribute("nullUse") != null) {
                simpleParmValueItem.setUse(null);
            } else {
                simpleParmValueItem.setUse(selectOption.attributeValue("useValue"));
            }
            simpleParmValueItem.setDisplay(selectOption.attributeValue("displayValue"));
            simpleParmValueItem.setInclusive(true);
        }
        return simpleParmValueItem;
    }

    public ParmValueItem loadSelectBoundRange(Element selectBoundRange) {
        Element endRange;
        BoundRangeParmValueItem boundRangeParmValueItem = new BoundRangeParmValueItem();
        boundRangeParmValueItem.setInclusive(true);
        Element startRange = selectBoundRange.element("start");
        if (startRange != null) {
            boundRangeParmValueItem.setStart((SimpleParmValueItem)this.loadSelectOption(startRange));
        }
        if ((endRange = selectBoundRange.element("end")) != null) {
            boundRangeParmValueItem.setEnd((SimpleParmValueItem)this.loadSelectOption(endRange));
        }
        return boundRangeParmValueItem;
    }

    public ParmValueItem loadSelectUnboundedEndRange(Element selectUnboundedEndRange) {
        UnboundedEndRangeParmValueItem unboundedEndRangeParmValueItem = new UnboundedEndRangeParmValueItem();
        unboundedEndRangeParmValueItem.setInclusive(true);
        Element startRange = selectUnboundedEndRange.element("start");
        if (startRange != null) {
            unboundedEndRangeParmValueItem.setStart((SimpleParmValueItem)this.loadSelectOption(startRange));
        }
        return unboundedEndRangeParmValueItem;
    }

    public ParmValueItem loadSelectUnboundedStartRange(Element selectUnboundedStartRange) {
        UnboundedStartRangeParmValueItem unboundedStartRangeParmValueItem = new UnboundedStartRangeParmValueItem();
        unboundedStartRangeParmValueItem.setInclusive(true);
        Element endRange = selectUnboundedStartRange.element("end");
        if (endRange != null) {
            unboundedStartRangeParmValueItem.setEnd((SimpleParmValueItem)this.loadSelectOption(endRange));
        }
        return unboundedStartRangeParmValueItem;
    }

    public ParmValueItem loadSelectTreeOption(Element selectTreeOption) {
        HierarchicalParmValueItem hierarchicalParmValueItem = new HierarchicalParmValueItem();
        hierarchicalParmValueItem.setInclusive(true);
        hierarchicalParmValueItem.setValue((SimpleParmValueItem)this.loadSelectOption(selectTreeOption));
        List subNodesList = selectTreeOption.elements("selectTreeOption");
        if (subNodesList != null) {
            int iListSize = subNodesList.size();
            HierarchicalParmValueItem[] subNodes = new HierarchicalParmValueItem[iListSize];
            for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                Element selectTreeOptionSubNode = (Element)subNodesList.get(iIndex);
                subNodes[iIndex] = (HierarchicalParmValueItem)this.loadSelectTreeOption(selectTreeOptionSubNode);
            }
            hierarchicalParmValueItem.setSubNodes(subNodes);
        }
        return hierarchicalParmValueItem;
    }

    public void addParameterValues(String sSoapSpecification) throws CognosViewerException {
        ParameterValue[] parameterValues = this.parseXMLSpecification(sSoapSpecification);
        if (parameterValues != null) {
            this.addParameterValues(parameterValues);
        }
    }

    public void addParametersValues(Element parameters) throws CognosViewerException {
        this.addParametersValues(parameters, true);
    }

    public void addParametersValues(Element parameters, boolean append) throws CognosViewerException {
        List parameterValuesList = parameters.elements();
        int size = parameterValuesList.size();
        for (int index = 0; index < size; ++index) {
            Element parameterValuesNode = (Element)parameterValuesList.get(index);
            ParameterValuesMarshaller parameterValuesMarshaller = new ParameterValuesMarshaller(null);
            ParameterValue[] parameterValues = parameterValuesMarshaller.unmarshall(parameterValuesNode);
            this.addParameterValues(parameterValues, append);
        }
    }

    public void setParameterValues(String sSoapSpecification) throws CognosViewerException {
        ParameterValue[] parameterValues = this.parseXMLSpecification(sSoapSpecification);
        if (parameterValues != null) {
            this.setParameterValues(parameterValues);
        }
    }

    public ParameterValue[] parseXMLSpecification(String sSoapSpecification) throws CognosViewerException {
        try {
            sSoapSpecification = "<root xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + sSoapSpecification + "</root>";
            Document document = XMLUtility.createXMLDocument(sSoapSpecification);
            Element rootNode = document.getRootElement();
            ParameterValueManager localCopy = new ParameterValueManager();
            List parameterValuesList = rootNode.elements();
            int size = parameterValuesList.size();
            for (int index = 0; index < size; ++index) {
                Element parameterValuesNode = (Element)parameterValuesList.get(index);
                ParameterValuesMarshaller parameterValuesMarshaller = new ParameterValuesMarshaller(null);
                ParameterValue[] paramterValues = parameterValuesMarshaller.unmarshall(parameterValuesNode);
                localCopy.addParameterValues(paramterValues);
            }
            return localCopy.toArray();
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public void addParameterValues(ParameterValue[] parameterValues) {
        this.addParameterValues(parameterValues, true);
    }

    public void addParameterValues(ParameterValue[] parameterValues, boolean append) {
        for (int index = 0; index < parameterValues.length; ++index) {
            this.addParameterValue(parameterValues[index], append);
        }
    }

    public void setParameterValues(ParameterValue[] parameterValues) {
        for (int index = 0; index < parameterValues.length; ++index) {
            this.setParameterValue(parameterValues[index]);
        }
    }

    public void addParameterValue(ParameterValue parameterValue) {
        this.addParameterValue(parameterValue, true);
    }

    public void addParameterValue(ParameterValue parameterValue, boolean append) {
        if (this.m_parameterValues.containsKey(parameterValue.getName())) {
            if (append) {
                ParameterValue existingParameterValue = (ParameterValue)this.m_parameterValues.get(parameterValue.getName());
                this.addParmValueItems(existingParameterValue, parameterValue.getValue());
            }
        } else {
            this.setParameterValue(parameterValue);
        }
    }

    public void removeParameterValue(String parameterName) {
        this.m_parameterValues.remove(parameterName);
    }

    public void setParameterValue(ParameterValue parameterValue) {
        if (parameterValue != null) {
            this.m_parameterValues.put(parameterValue.getName(), parameterValue);
        }
    }

    public ParameterValue[] getCredentialParameters() {
        ParameterValueManager credentialPlaceHolder = new ParameterValueManager();
        HashMap parameterValuesMap = this.getParameterValues();
        int length = parameterValuesMap.size();
        Iterator parameterValuesIterator = parameterValuesMap.values().iterator();
        for (int index = 0; index < length; ++index) {
            ParameterValue parameterValue = (ParameterValue)parameterValuesIterator.next();
            String sName = parameterValue.getName();
            if (!sName.startsWith("credential:")) continue;
            credentialPlaceHolder.addParameterValue(parameterValue);
        }
        return credentialPlaceHolder.toArray();
    }

    public boolean hasNonCredentialParameters() {
        HashMap parameterValuesMap = this.getParameterValues();
        for (ParameterValue parameterValue : parameterValuesMap.values()) {
            if (parameterValue.getName().startsWith("credential:")) continue;
            return true;
        }
        return false;
    }

    public HashMap<String, String> getRAPParameterUpdateMap() {
        return this.m_RAPParameterUpdateMap;
    }

    public boolean containsRAPParameterValues() {
        return this.m_RAPParameterUpdateMap.size() > 0;
    }

    public void applyRAPParameterUpdates() throws CognosViewerException {
        try {
            for (Map.Entry<String, String> paramUpdate : this.m_RAPParameterUpdateMap.entrySet()) {
                this.removeParameterValue(paramUpdate.getKey());
                if (paramUpdate.getValue() == null) continue;
                this.processSelectChoices(paramUpdate.getKey(), paramUpdate.getValue());
            }
            this.m_RAPParameterUpdateMap.clear();
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public void addCredentialParametersFromSOAPResponse(SOAPResponse soapResponse) throws CognosViewerException {
        Element parametersNode;
        Element soapBody;
        if (soapResponse != null && (soapBody = soapResponse.getBusEnvelope().getBody()) != null && (parametersNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item' and ./*[local-name()='parameters']]")) != null) {
            ParameterValueManager parameterValueManager = new ParameterValueManager();
            parameterValueManager.addParametersValues(parametersNode);
            this.addParameterValues(parameterValueManager.getCredentialParameters());
        }
    }
}

