/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.IPFLogger;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.mail.internet.InternetHeaders;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class SOAPRequest
extends BIBusCommand {
    public static final String CONTENT_MANAGER_SOAP_ACTION;
    public static final String REPORT_SERVICE_SOAP_ACTION;
    public static final String DELIVERY_SERVICE_SOAP_ACTION;
    public static final String POWERPLAY_SERVICE_SOAP_ACTION;
    public static final String CONTENT_MANAGER_CACHE_SOAP_ACTION;
    public static final String ANNOTATION_SERVICE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/internal/annotationService/1";
    private static final String IPAHeader = "X-CA-IPA";
    private QName m_method = null;
    private String m_sRoutingServerGroup = null;
    private String m_sAffinity = null;
    private String m_sSoapAction = null;
    private IArgumentMarshaller[] m_aArguments = null;
    private BIBusEnvelope m_responseEnvelope = null;
    private Tracking m_tracking = null;
    private URL m_serverURL;
    private IPFLogger m_ipfLogger = null;
    private ServerConnection m_serverConnection = null;
    private DebugLogger m_debugLogger = null;
    private InputStream m_attachmentStream = null;
    private boolean m_bTrustedRequest = false;
    private InternetHeaders m_headers = null;

    public SOAPRequest() {
        this.setAutoRelease(false);
    }

    public BIBusEnvelope executeSOAPRequest(ServerConnection serverConnection, String sSoapAction, QName method, CognosViewerRequest request) throws CognosViewerException {
        this.m_bTrustedRequest = request.getTrustedRequest();
        return this.executeSOAPRequest(serverConnection, sSoapAction, method, request.getState(), request.getArgMarshaller(), request.getAffinity());
    }

    public BIBusEnvelope executeSOAPRequest(ServerConnection serverConnection, String sSoapAction, QName method, ICognosViewerState state, IArgumentMarshaller[] aArguments, String sAffinity) throws CognosViewerException {
        CognosViewerDispatcherHandlerState originalState = null;
        InternetHeaders originalHeaders = null;
        if (state instanceof CognosViewerDispatcherHandlerState) {
            originalState = (CognosViewerDispatcherHandlerState)state;
            originalHeaders = originalState.getHeaders();
            this.m_ipfLogger = originalState.getIPFLogger();
        }
        return this.executeSOAPRequest(serverConnection, sSoapAction, method, state.getBusEnvelope(), state.getFormFieldAsString("ui.routingServerGroup"), state.getTracking(), aArguments, sAffinity, originalHeaders, state.getDebugLogger());
    }

    private BIBusEnvelope executeSOAPRequest(ServerConnection serverConnection, String sSoapAction, QName method, BIBusEnvelope busEnvelope, String sRoutingServerGroup, Tracking tracking, IArgumentMarshaller[] aArguments, String sAffinity, InternetHeaders headers, DebugLogger debugLogger) throws CognosViewerException {
        IPFLogger.PerfData curPerfData = null;
        this.m_sSoapAction = sSoapAction;
        this.m_serverConnection = serverConnection;
        this.m_method = method;
        this.m_sRoutingServerGroup = sRoutingServerGroup;
        this.m_tracking = tracking;
        this.m_aArguments = aArguments;
        this.m_sAffinity = sAffinity;
        this.m_debugLogger = debugLogger;
        this.m_headers = headers;
        if (this.m_bTrustedRequest) {
            this.setDoTrustedRequest(true, "DBV");
            busEnvelope.setDispatcherTransport("html", "false");
        }
        if (this.m_ipfLogger != null) {
            curPerfData = this.m_ipfLogger.startPerf(10000, "Perf.VIEWER", "Entering executeRequest", "ENTER");
        }
        if (busEnvelope != null) {
            this.setRequestEvelope(busEnvelope);
            Element soapBody = busEnvelope.getBody();
            List elements = soapBody.elements();
            int iListSize = elements.size();
            for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                Element element = (Element)elements.get(iIndex);
                element.detach();
            }
        }
        try {
            DebugLogger.logTrace("Executing SOAP request " + this.m_method.getName());
            this.execute();
            DebugLogger.logTrace("SOAP request done " + this.m_method.getName());
            if (this.m_debugLogger != null) {
                this.m_debugLogger.endTimedEvent("SOAP_REQUEST");
            }
        }
        catch (CommandExecutionException commandExecutionException) {
            CognosViewerException cognosViewerException = null;
            cognosViewerException = this.getResponseEnvelope() != null ? new CognosViewerException(this.getResponseEnvelope()) : new CognosViewerException(busEnvelope, commandExecutionException.toString(), (Exception)((Object)commandExecutionException), commandExecutionException.toString());
            throw cognosViewerException;
        }
        if (this.m_ipfLogger != null) {
            this.m_ipfLogger.traceSOAP(10000, "Trace.VIEWER.SOAP", (byte)7, "SoapRequest", busEnvelope);
            this.m_ipfLogger.traceSOAP(10000, "Trace.VIEWER.SOAP", (byte)8, "SoapResponse", this.m_responseEnvelope);
            if (curPerfData != null) {
                this.m_ipfLogger.stopPerf(curPerfData, "Leaving executeRequest", "EXIT");
            }
        }
        return this.m_responseEnvelope;
    }

    public void setServerURL(URL serverURL) {
        this.m_serverURL = serverURL;
    }

    public URL getServerURL() {
        return this.m_serverURL;
    }

    protected void addExtraSOAPHeaders() {
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope();
        this.addBusTracking(requestEnvelope);
        this.addRoutingServerGroup(requestEnvelope);
        if (this.m_debugLogger != null) {
            String folderName = this.m_method.getName();
            if (this.m_bTrustedRequest) {
                folderName = folderName + "_trustedRequest";
            }
            this.m_debugLogger.log(requestEnvelope, "request.xml", true, folderName);
            this.m_debugLogger.startTimedEvent("SOAP_REQUEST", this.m_method.getName(), "SOAP");
        }
    }

    public String getAffinity() {
        if (this.m_sAffinity == null) {
            return "";
        }
        return this.m_sAffinity;
    }

    protected void addExtraHTTPHeaders(ServerConnection connection) {
        String sAffinity = "";
        if (this.getAffinity().length() > 0) {
            sAffinity = sAffinity + "." + this.getAffinity();
        }
        connection.addRequestHeader("SOAPAction", this.m_sSoapAction + sAffinity);
        if (this.m_headers != null && this.m_headers.getHeader(IPAHeader) != null) {
            connection.addRequestHeader(IPAHeader, this.m_headers.getHeader(IPAHeader)[0]);
        }
    }

    private void addRoutingServerGroup(BIBusEnvelope requestEnvelope) {
        if (this.m_sRoutingServerGroup != null && this.m_sRoutingServerGroup.length() > 0) {
            requestEnvelope.setRoutingServerGroup(this.m_sRoutingServerGroup);
        }
    }

    private void addBusTracking(BIBusEnvelope requestEnvelope) {
        if (this.m_tracking != null && this.m_tracking.getConversationContext() != null) {
            ConversationContext conversationContext = this.m_tracking.getConversationContext();
            Element originalTrackingNode = requestEnvelope.getTracking();
            Element trackingNode = originalTrackingNode == null ? DocumentHelper.createElement((QName)BIBusEnvelope.BUS_TRACKING) : (Element)originalTrackingNode.clone();
            Element conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
            if (conversationContextNode != null) {
                conversationContextNode.detach();
            }
            conversationContextNode = trackingNode.addElement(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
            conversationContextNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.BUS_CONVERSATION_CONTEXT.getQualifiedName());
            Element conversationContextId = conversationContextNode.addElement("id");
            conversationContextId.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            conversationContextId.setText(conversationContext.getId());
            if (DebugLogger.isTraceEnabled()) {
                DebugLogger.logTrace("Conversation cotext ID " + conversationContext.getId());
            }
            Element conversationContextNodeId = conversationContextNode.addElement("nodeID");
            conversationContextNodeId.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            conversationContextNodeId.setText(conversationContext.getNodeID());
            Element conversationContextProcessId = conversationContextNode.addElement("processID");
            conversationContextProcessId.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
            conversationContextProcessId.setText(Integer.toString(conversationContext.getProcessID()));
            Element affinityStrength = conversationContextNode.addElement("affinityStrength");
            affinityStrength.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
            affinityStrength.setText(Integer.toString(conversationContext.getAffinityStrength()));
            Element status = conversationContextNode.addElement("status");
            status.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            status.setText(conversationContext.getStatus());
            requestEnvelope.setTracking(trackingNode);
        }
    }

    protected String fetchRequestContext() {
        return this.m_serverURL.getPath();
    }

    protected ServerConnection fetchServerConnection() {
        return this.m_serverConnection;
    }

    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        if (this.m_method != null && this.m_aArguments != null) {
            Element reportServiceMethod = bodyElement.addElement(this.m_method);
            if (CognosViewerDispatcherHandlerState.isMasters()) {
                reportServiceMethod.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
            }
            boolean debugEnabled = false;
            if (this.m_debugLogger != null) {
                debugEnabled = this.m_debugLogger.isDebugEnabled();
            }
            for (int iIndex = 0; iIndex < this.m_aArguments.length; ++iIndex) {
                try {
                    AsynchSpecification spec;
                    List<InputStream> attachments;
                    IArgumentMarshaller marshaller = this.m_aArguments[iIndex];
                    marshaller.marshall(reportServiceMethod);
                    if (marshaller instanceof OptionMarshaller && (attachments = ((OptionMarshaller)marshaller).getAttachments()) != null && attachments.size() > 0) {
                        this.setRequestAttachments(attachments.iterator());
                    }
                    if (!debugEnabled || !(marshaller instanceof AsynchSpecificationMarshaller) || (spec = ((AsynchSpecificationMarshaller)marshaller).getAsynchSpecification()) == null || spec.getValue() == null) continue;
                    this.m_debugLogger.logXML(spec.getValue().get_value(), "reportSpec.xml", true, "reportSpec");
                    continue;
                }
                catch (CognosViewerException exception) {
                    IPFLogger.getInstance().error(exception.getMessage(), exception, ((Object)((Object)this)).getClass().getName());
                    CommandExecutionException commandExecutionException = new CommandExecutionException(exception.getMessage());
                    throw commandExecutionException;
                }
            }
        }
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        this.m_responseEnvelope = this.getResponseEnvelope();
        if (this.m_responseEnvelope != null) {
            Iterator mimeAttachmentIterator = this.getAttachments();
            String attachmentEncoding = "";
            if (CognosViewerDispatcherHandler.getConfigValues() != null && CognosViewerDispatcherHandler.getConfigValues().getProperty("attachmentEncoding") != null) {
                attachmentEncoding = CognosViewerDispatcherHandler.getConfigValues().getProperty("attachmentEncoding");
            }
            try {
                if (mimeAttachmentIterator != null && mimeAttachmentIterator.hasNext()) {
                    InputStream inputStream = this.stripMIMEHeaders((InputStream)mimeAttachmentIterator.next());
                    if (attachmentEncoding.compareTo("MIMECompressed") == 0) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    this.m_attachmentStream = this.m_attachmentStream == null ? inputStream : new SequenceInputStream(this.m_attachmentStream, inputStream);
                }
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error(exception.getMessage(), exception, ((Object)((Object)this)).getClass().getName());
                CommandExecutionException commandExecutionException = new CommandExecutionException(exception.getMessage());
                throw commandExecutionException;
            }
        }
    }

    public BIBusEnvelope buildSoapRequest(ICognosViewerState state, String sSoapAction, QName method, IArgumentMarshaller[] aArguments, String sAffinity) throws CognosViewerException {
        BIBusEnvelope busEnvelope = state.getBusEnvelope();
        if (busEnvelope != null) {
            this.setRequestEvelope(busEnvelope);
        }
        this.m_sSoapAction = sSoapAction;
        this.m_method = method;
        this.m_sRoutingServerGroup = state.getFormFieldAsString("ui.routingServerGroup");
        this.m_tracking = state.getTracking();
        this.m_aArguments = aArguments;
        this.m_sAffinity = sAffinity;
        try {
            this.executeImpl(this.getRequestEnvelope().getBody());
            this.addExtraSOAPHeaders();
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
        return this.getRequestEnvelope();
    }

    public InputStream getMimeAttachmentStream() {
        return this.m_attachmentStream;
    }

    private boolean isEmptyLine(InputStream inStream) throws IOException {
        boolean isEmptyLine = true;
        while (true) {
            int aByte;
            if ((aByte = inStream.read()) == 13) {
                continue;
            }
            if (aByte == 10 || aByte == -1) break;
            isEmptyLine = false;
        }
        return isEmptyLine;
    }

    public InputStream stripMIMEHeaders(InputStream inStream) throws IOException {
        while (!this.isEmptyLine(inStream)) {
        }
        return inStream;
    }

    public ServerConnection getServerConnection(ICognosViewerState state) {
        ServerConnection connection = null;
        if (CognosViewerDispatcherHandlerState.isMasters()) {
            connection = new StandaloneServerConnection("localhost", 9300, false);
        } else {
            connection = DispatcherConnectionManager.getLocalDispatcherConnection();
            state.addToCleanupList(connection);
        }
        return connection;
    }

    public void setMethod(QName method) {
        this.m_method = method;
    }

    public void setArgs(IArgumentMarshaller[] args) {
        this.m_aArguments = args;
    }

    static {
        List versions = BridgeHandler.getSupportedVersions();
        String soapActionVersion = versions.isEmpty() ? "emptyBridgeHandlerVersions" : (String)versions.get(0);
        CONTENT_MANAGER_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/contentManagerService/" + soapActionVersion + "/";
        REPORT_SERVICE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/reportService/" + soapActionVersion + "/";
        DELIVERY_SERVICE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/deliveryService/" + soapActionVersion + "/";
        POWERPLAY_SERVICE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/powerPlayService/" + soapActionVersion + "/";
        CONTENT_MANAGER_CACHE_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/contentManagerCacheService/" + soapActionVersion + "/";
    }
}

