/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.CognosViewerSessionManager;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.fragments.FragmentState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.TransientSpec;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Element;

public class SOAPResponse
implements ICognosViewerActionResponse {
    protected BIBusEnvelope m_responseEnvelope = null;
    protected ICognosViewerState m_state;
    private IPFLogger m_ipfLogger = null;

    public SOAPResponse(ICognosViewerState state, BIBusEnvelope responseEnvelope) {
        this.m_state = state;
        this.m_responseEnvelope = responseEnvelope;
        if (state != null) {
            this.setLogger(state.getIPFLogger());
            state.getDebugLogger().log(this.m_responseEnvelope, "response.xml", false, null);
            if (responseEnvelope != null) {
                this.m_state.setSetCookiesFromSOAPResponse(responseEnvelope);
            }
        }
    }

    @Override
    public CAMPassport getCAMPassport() {
        return this.m_state.getCAMPassport();
    }

    @Override
    public Tracking getTracking() {
        return this.m_state.getTracking();
    }

    @Override
    public void clearConversation() {
        this.m_state.clearConversation();
    }

    @Override
    public AsynchRequest getConversation() {
        return this.m_state.getConversation();
    }

    @Override
    public SearchPathSingleObject getObjectPath() {
        return this.m_state.getObjectPath();
    }

    @Override
    public void updateSpecificationContents(String updatedSpecification) throws CognosViewerException {
        this.m_state.updateSpecificationContents(updatedSpecification);
    }

    @Override
    public AsynchSpecification getSpecification() {
        return this.m_state.getSpecification();
    }

    @Override
    public String getSpecificationType() {
        return this.m_state.getSpecificationType();
    }

    @Override
    public ParameterValueManager getParameterValueManager() {
        return this.m_state.getParameterValueManager();
    }

    @Override
    public void setParmaeterValueManager(ParameterValueManager paramManager) {
        this.m_state.setParmaeterValueManager(paramManager);
    }

    @Override
    public OptionManager getOptionManager() {
        return this.m_state.getOptionManager();
    }

    @Override
    public String getAction() {
        return this.m_state.getAction();
    }

    @Override
    public String getActionSpecification() {
        return this.m_state.getActionSpecification();
    }

    @Override
    public String getResponseFormat() {
        return this.m_state.getResponseFormat();
    }

    @Override
    public String getFormFieldAsString(String sFormFieldName) {
        return this.m_state.getFormFieldAsString(sFormFieldName);
    }

    @Override
    public void removeFormField(String sFormFieldName) {
        this.m_state.removeFormField(sFormFieldName);
    }

    @Override
    public void setFormFieldFromString(String sFormFieldName, String sFormFieldValue) {
        this.m_state.setFormFieldFromString(sFormFieldName, sFormFieldValue);
    }

    @Override
    public void setFormFieldFromString(String sFormFieldName, String sFormFieldValue, boolean bOverrideExisting) {
        this.m_state.setFormFieldFromString(sFormFieldName, sFormFieldValue, bOverrideExisting);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.m_state.getCapabilities();
    }

    @Override
    public CognosViewerBlacklist getUIBlacklist() {
        return this.m_state.getUIBlacklist();
    }

    @Override
    public CognosViewerSystemParams getSystemParams() {
        return this.m_state.getSystemParams();
    }

    @Override
    public String getUserPreference(String sName) {
        return this.m_state.getUserPreference(sName);
    }

    @Override
    public String getEnvironmentVariable(String sName) {
        return this.m_state.getEnvironmentVariable(sName);
    }

    @Override
    public NameValuePair[] getFormFields() {
        return this.m_state.getFormFields();
    }

    @Override
    public StringBuilder getDetailOutput() throws CognosViewerException {
        StringBuilder sbOutput = new StringBuilder();
        this.getDetailOutput(sbOutput);
        return sbOutput;
    }

    @Override
    public void getDetailOutput(StringBuilder sbOutput) throws CognosViewerException {
    }

    @Override
    public boolean hasDetailOutput() throws CognosViewerException {
        return true;
    }

    @Override
    public String getStatus() {
        return "";
    }

    @Override
    public boolean isConversationComplete() {
        return false;
    }

    @Override
    public String[] getAvailableSecondaryRequests() {
        return new String[0];
    }

    @Override
    public String getStateData() {
        return "";
    }

    @Override
    public BIBusEnvelope getBusEnvelope() {
        return this.m_responseEnvelope;
    }

    @Override
    public BIBusEnvelope getInitialBusEnvelope() {
        return this.m_state.getBusEnvelope();
    }

    @Override
    public String getContentFormat() {
        String sFormat = "";
        sFormat = this.m_state.getUserPreference("format");
        if (sFormat == null || sFormat.length() == 0) {
            sFormat = "HTML";
        }
        return sFormat;
    }

    @Override
    public CognosViewerSessionManager getSessionManager() {
        return this.m_state.getSessionManager();
    }

    @Override
    public String getWebContentRoot() {
        if (this.m_state != null) {
            return this.m_state.getWebContentRoot();
        }
        return "..";
    }

    public List getNodes(String sXpath) {
        List elementList = null;
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null) {
            elementList = this.m_responseEnvelope.getBody().selectNodes(sXpath);
        }
        return elementList;
    }

    public String getStringValue(String sXpath) {
        Element element;
        String sValue = "";
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null && (element = (Element)this.m_responseEnvelope.getBody().selectSingleNode(sXpath)) != null) {
            sValue = element.getText();
        }
        return sValue;
    }

    public int getCount(String sXpath) {
        List elementList;
        int iCount = 0;
        if (this.m_responseEnvelope != null && this.m_responseEnvelope.getBody() != null && (elementList = this.m_responseEnvelope.getBody().selectNodes(sXpath)) != null) {
            iCount = elementList.size();
        }
        return iCount;
    }

    @Override
    public DebugLogger getDebugLogger() {
        if (this.m_state != null) {
            return this.m_state.getDebugLogger();
        }
        return null;
    }

    @Override
    public boolean useAjax() {
        return this.m_state.useAjax();
    }

    @Override
    public boolean isBUX() {
        return this.m_state.isBUX();
    }

    @Override
    public TransientSpec getTransientSpec() {
        return this.m_state.getTransientSpec();
    }

    @Override
    public String getReRunObj() {
        return "";
    }

    @Override
    public String getReportVersion() {
        return "";
    }

    @Override
    public List getCleanupList() {
        return this.m_state.getCleanupList();
    }

    @Override
    public void addToCleanupList(ServerConnection connection) {
        this.m_state.addToCleanupList(connection);
    }

    @Override
    public InputStream getAttachmentInputStream() {
        return this.m_state.getAttachmentInputStream();
    }

    @Override
    public void setAttachmentInputStream(InputStream stream) {
        this.m_state.setAttachmentInputStream(stream);
    }

    public void setState(ICognosViewerState originalState) {
        this.m_state = originalState;
    }

    @Override
    public IPFLogger getIPFLogger() {
        if (this.m_ipfLogger == null) {
            this.m_ipfLogger = IPFLogger.getInstance();
        }
        return this.m_ipfLogger;
    }

    private void setLogger(IPFLogger ipfLogger) {
        this.m_ipfLogger = ipfLogger;
    }

    @Override
    public void addObject(String key, Object object) {
        this.m_state.addObject(key, object);
    }

    @Override
    public Object getObject(String key) {
        return this.m_state.getObject(key);
    }

    @Override
    public boolean isAccessibleMode() {
        return this.m_state.isAccessibleMode();
    }

    @Override
    public boolean isFlashChartOptionDisabled() {
        return this.m_state.isFlashChartOptionDisabled();
    }

    @Override
    public boolean getDefaultFlashChartOptionValue() {
        return this.m_state.getDefaultFlashChartOptionValue();
    }

    @Override
    public int getVisCoachMode() {
        return this.m_state.getVisCoachMode();
    }

    @Override
    public boolean doParametersNeedCafProtection() {
        return this.m_state.doParametersNeedCafProtection();
    }

    @Override
    public void setReportSpecification(String spec) throws CognosViewerException {
        this.m_state.setReportSpecification(spec);
    }

    @Override
    public void setSetCookiesFromSOAPResponse(BIBusEnvelope responseEnvelope) {
        this.m_state.setSetCookiesFromSOAPResponse(responseEnvelope);
    }

    @Override
    public boolean isDroppingReportBUXAction() {
        boolean isDrop = false;
        if (null != this.m_state) {
            isDrop = this.m_state.isDroppingReportBUXAction();
        }
        return isDrop;
    }

    @Override
    public FragmentState getFragmentState() {
        return this.m_state.getFragmentState();
    }

    @Override
    public String getCookieValue(String name) {
        return this.m_state.getCookieValue(name);
    }

    @Override
    public void initializeXslRunOptions() {
        this.m_state.initializeXslRunOptions();
    }

    @Override
    public boolean getAllowSpecModification() {
        return this.m_state.getAllowSpecModification();
    }

    @Override
    public void setAllowSpecModification(boolean bAllow) {
        this.m_state.setAllowSpecModification(bAllow);
    }

    @Override
    public void releaseConnections() {
        this.m_state.releaseConnections();
    }
}

