/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.iWidget;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Iterator;

public abstract class IWidgetItemSet {
    private static final String RAP_REPORT_INFO_VERSION = "1.0.0.0";
    private static final String SLIDER_STATE_PREFIX = "sliderState_";
    private static final String LOCALE_MARKER = "_";

    public static void processItemSet(BIBusEnvelope biBusEnvelope) throws IOException {
        if (DebugLogger.isDebugEnabledForAllUsers()) {
            String directory = DebugLogger.getBaseDebugDirectory(biBusEnvelope);
            DebugLogger.logXML(biBusEnvelope.getAsString(), "initialBiBusEnvelope.xml", directory);
        }
        String sOriginalItem = IWidgetItemSet.getFormValue(biBusEnvelope, "originalReport");
        String sOriginalReportPart = IWidgetItemSet.getFormValue(biBusEnvelope, "originalReportPart");
        String sSavedItem = IWidgetItemSet.getSavedItem(biBusEnvelope);
        boolean bIsSavedReport = IWidgetItemSet.isSavedReport(sOriginalItem, sSavedItem);
        String sFlexPromptData = IWidgetItemSet.getFormValue(biBusEnvelope, "flexParam_promptData");
        String sInitialSpec = IWidgetItemSet.getFormValue(biBusEnvelope, "specification");
        JSONObject jsonProperties = JSONObject.parse((String)IWidgetItemSet.getPropertiesJSON(biBusEnvelope));
        IWidgetItemSet.setPromptRunOption(biBusEnvelope, sFlexPromptData, bIsSavedReport, jsonProperties);
        biBusEnvelope.setFormField("run.outputFormat", "HTML");
        biBusEnvelope.setFormField("bux", "true");
        biBusEnvelope.setFormField("cv.responseFormat", "iWidget");
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "gateway").length() > 0) {
            biBusEnvelope.setFormField("cv.gateway", IWidgetItemSet.getFormValue(biBusEnvelope, "gateway"));
        }
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "webcontent").length() > 0) {
            biBusEnvelope.setFormField("cv.webcontent", IWidgetItemSet.getFormValue(biBusEnvelope, "webcontent"));
        }
        if (sInitialSpec.length() == 0) {
            if (bIsSavedReport) {
                String searchPath = IWidgetItemSet.getSavedReportSearchPath(biBusEnvelope, sSavedItem);
                biBusEnvelope.setFormField("ui.object", searchPath);
                biBusEnvelope.setFormField("ui.reRunObj", searchPath);
                biBusEnvelope.setFormField("widget.isSavedReport", "true");
                if (IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportPath").length() == 0 && IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportName").length() > 0) {
                    biBusEnvelope.setFormField("savedReportName", sSavedItem);
                }
            } else {
                biBusEnvelope.setFormField("ui.object", sOriginalItem);
                if (IWidgetItemSet.getFormValue(biBusEnvelope, "flexParam_properties").length() > 0) {
                    biBusEnvelope.setFormField("flexParamProperties", IWidgetItemSet.getFormValue(biBusEnvelope, "flexParam_properties"));
                }
                if (sFlexPromptData.length() > 0) {
                    biBusEnvelope.setFormField("gdPromptAnswers", sFlexPromptData);
                }
            }
            biBusEnvelope.setFormField("originalReport", sOriginalItem);
        }
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "savedOutputSearchPath").length() > 0) {
            biBusEnvelope.setFormField("ui.savedOutputSearchPath", IWidgetItemSet.getFormValue(biBusEnvelope, "savedOutputSearchPath"));
            biBusEnvelope.setFormField("ui.action", "buxView");
        } else if (IWidgetItemSet.getFormValue(biBusEnvelope, "mostRecentSavedOutput").length() > 0) {
            biBusEnvelope.setFormField("ui.action", "buxView");
        } else if (bIsSavedReport) {
            biBusEnvelope.setFormField("widget.userParameters", "true");
            if ("true".equals(IWidgetItemSet.getFormValue(biBusEnvelope, "limitedInteractiveMode"))) {
                biBusEnvelope.setFormField("limitedInteractiveMode", "true");
                biBusEnvelope.setFormField("ui.action", "run");
                biBusEnvelope.setFormField("run.xslURL", "bux.xsl");
            } else {
                biBusEnvelope.setFormField("ui.action", "bux");
            }
        } else if (sOriginalReportPart.length() > 0) {
            biBusEnvelope.setFormField("ui.reportDrop", "true");
            biBusEnvelope.setFormField("ui.action", "bux");
            biBusEnvelope.setFormField("reportpart_id", sOriginalReportPart);
        } else if (sInitialSpec.length() > 0) {
            biBusEnvelope.setFormField("ui.spec", sInitialSpec);
            biBusEnvelope.setFormField("ui.action", "buxRunSpecification");
            biBusEnvelope.setFormField("cv.objectPermissions", "read write execute setPolicy traverse");
        } else {
            biBusEnvelope.setFormField("ui.reportDrop", "true");
            biBusEnvelope.setFormField("ui.action", "buxDropReportOnCanvas");
        }
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "cv.updateDataFilters").length() == 0) {
            IWidgetItemSet.addSliderState(biBusEnvelope);
        }
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "userRole").length() > 0) {
            biBusEnvelope.setFormField("cv.buxCurrentUserRole", IWidgetItemSet.getFormValue(biBusEnvelope, "userRole"));
        }
        IWidgetItemSet.loadWidgetProperties(biBusEnvelope, jsonProperties);
        if (IWidgetItemSet.isOpeningSavedDashboard(biBusEnvelope)) {
            biBusEnvelope.setFormField("ui.preserveRapTags", "true");
        }
        IWidgetItemSet.setGetReportInfo(biBusEnvelope);
        IWidgetItemSet.cleanBiBusHeader(biBusEnvelope);
    }

    private static void cleanBiBusHeader(BIBusEnvelope biBusEnvelope) {
        biBusEnvelope.removeFormValue("originalReportPart");
        biBusEnvelope.removeFormValue("savedReportPath");
        biBusEnvelope.removeFormValue("flexParam_properties");
        biBusEnvelope.removeFormValue("flexParam_promptData");
        biBusEnvelope.removeFormValue("viewerProperties");
        biBusEnvelope.removeFormValue("gateway");
        biBusEnvelope.removeFormValue("webcontent");
        biBusEnvelope.removeFormValue("specification");
        biBusEnvelope.removeFormValue("dashboardID");
        biBusEnvelope.removeFormValue("savedOutputSearchPath");
        biBusEnvelope.removeFormValue("mostRecentSavedOutput");
        biBusEnvelope.removeFormValue("sliderIDs");
        biBusEnvelope.removeFormValue("rapReportInfoVersion");
        biBusEnvelope.removeFormValue("rapReportInfo");
        biBusEnvelope.removeFormValue("userRole");
        biBusEnvelope.removeFormValue("userParams");
    }

    private static boolean isOpeningSavedDashboard(BIBusEnvelope biBusEnvelope) {
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "viewerProperties").length() > 0) {
            return true;
        }
        return RAP_REPORT_INFO_VERSION.equals(IWidgetItemSet.getFormValue(biBusEnvelope, "version"));
    }

    private static String getFormValue(BIBusEnvelope biBusEnvelope, String param) {
        String formValue = biBusEnvelope.getFormValue(param);
        if (formValue == null) {
            return "";
        }
        return formValue;
    }

    private static void setGetReportInfo(BIBusEnvelope biBusEnvelope) {
        if (RAP_REPORT_INFO_VERSION.equals(IWidgetItemSet.getFormValue(biBusEnvelope, "rapReportInfoVersion")) && IWidgetItemSet.getFormValue(biBusEnvelope, "rapReportInfo").length() > 0) {
            biBusEnvelope.setFormField("rap.getReportInfo", "false");
        }
    }

    private static void loadWidgetProperties(BIBusEnvelope biBusEnvelope, JSONObject properties) {
        if (properties != null) {
            if (properties.containsKey((Object)"flashCharts")) {
                biBusEnvelope.setFormField("savedFlashChartOption", properties.get((Object)"flashCharts").toString());
            }
            if (properties.containsKey((Object)"rowsPerPage")) {
                biBusEnvelope.setFormField("run.verticalElements", properties.get((Object)"rowsPerPage").toString());
            }
        }
    }

    private static String getPropertiesJSON(BIBusEnvelope biBusEnvelope) {
        String sProperties = IWidgetItemSet.getFormValue(biBusEnvelope, "viewerProperties");
        if (sProperties.equals("<empty>")) {
            return "{}";
        }
        if (sProperties.length() > 0 && sProperties.indexOf("\"promptUserOnLoad\"") == -1) {
            sProperties = sProperties.replace("promptUserOnLoad", "\"promptUserOnLoad\"");
            sProperties = sProperties.replace("flashCharts", "\"flashCharts\"");
            sProperties = sProperties.replace("rowsPerPage", "\"rowsPerPage\"");
            sProperties = sProperties.replace("retrieveAll", "\"retrieveAll\"");
            sProperties = sProperties.replace("addSummaryMembers", "\"addSummaryMembers\"");
            sProperties = sProperties.replace("backwardsCompatible", "\"backwardsCompatible\"");
        }
        if (sProperties.length() == 0) {
            sProperties = "{}";
        }
        return sProperties;
    }

    private static void addSliderState(BIBusEnvelope biBusEnvelope) throws IOException {
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "sliderIDs").length() > 0) {
            JSONArray sliderIDs = JSONArray.parse((String)IWidgetItemSet.getFormValue(biBusEnvelope, "sliderIDs"));
            StringBuilder updateDataFilters = new StringBuilder();
            Iterator it = sliderIDs.iterator();
            while (it.hasNext()) {
                String sliderID = SLIDER_STATE_PREFIX + (String)it.next();
                String savedState = IWidgetItemSet.getSavedSliderState(biBusEnvelope, sliderID);
                if (savedState.length() > 0) {
                    updateDataFilters.append("<filter>" + EncodingUtility.xmlencode(savedState) + "</filter>");
                }
                biBusEnvelope.removeFormValue(sliderID);
            }
            biBusEnvelope.removeFormValue("sliderIDs");
            if (updateDataFilters.length() > 0) {
                biBusEnvelope.setFormField("cv.updateDataFilters", "<UpdateDataFilters>" + updateDataFilters.toString() + "</UpdateDataFilters>");
            }
        }
    }

    private static String getSavedSliderState(BIBusEnvelope biBusEnvelope, String sliderID) {
        String contentLocale = biBusEnvelope.getUserPreferenceValue("contentLocale");
        if (contentLocale != null && contentLocale.length() > 0) {
            if (biBusEnvelope.getFormValue(sliderID + LOCALE_MARKER + contentLocale) != null) {
                return biBusEnvelope.getFormValue(sliderID + LOCALE_MARKER + contentLocale);
            }
            int indexOfDash = contentLocale.indexOf("-");
            if (indexOfDash != -1) {
                contentLocale = contentLocale.substring(0, indexOfDash);
                if (biBusEnvelope.getFormValue(sliderID + LOCALE_MARKER + contentLocale) != null) {
                    return biBusEnvelope.getFormValue(sliderID + LOCALE_MARKER + contentLocale);
                }
            }
        }
        return IWidgetItemSet.getFormValue(biBusEnvelope, sliderID);
    }

    private static String getSavedReportSearchPath(BIBusEnvelope biBusEnvelope, String sSavedReportName) {
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportPath").length() > 0) {
            return IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportPath");
        }
        String sDashboardId = IWidgetItemSet.getFormValue(biBusEnvelope, "dashboardID");
        sDashboardId = sDashboardId.substring(8);
        String delimiter = sSavedReportName.indexOf("'") == -1 ? "'" : "\"";
        return "storeID(\"" + sDashboardId + "\")/*[@name=" + delimiter + sSavedReportName + delimiter + "]";
    }

    private static boolean isSavedReport(String sOriginalItem, String sSavedItem) {
        return sSavedItem.length() > 0 && !sSavedItem.equals(sOriginalItem);
    }

    private static String getSavedItem(BIBusEnvelope biBusEnvelope) {
        if (IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportPath").length() > 0) {
            return IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportPath");
        }
        return IWidgetItemSet.getFormValue(biBusEnvelope, "savedReportName");
    }

    private static void setPromptRunOption(BIBusEnvelope biBusEnvelope, String sFlexPromptData, boolean bIsSavedReport, JSONObject properties) {
        if (!bIsSavedReport && sFlexPromptData.length() > 0) {
            biBusEnvelope.setFormField("run.prompt", "false");
        } else if (bIsSavedReport && properties.containsKey((Object)"promptUserOnLoad")) {
            biBusEnvelope.setFormField("run.prompt", properties.get((Object)"promptUserOnLoad").toString());
        }
    }
}

