/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import org.dom4j.Element;

public class AddOptionsMarshaller
implements IArgumentMarshaller {
    private AddOptions m_addOptions = null;

    public AddOptionsMarshaller(AddOptions queryOptions) {
        this.m_addOptions = queryOptions;
    }

    private AddOptions getAddOptions() {
        return this.m_addOptions;
    }

    @Override
    public void marshall(Element parentElement) throws CognosViewerException {
        Element addOptionsNode = parentElement.addElement("options");
        addOptionsNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":addOptions");
        try {
            AddOptions addOptions = this.getAddOptions();
            if (addOptions.getDataEncoding() != null) {
                Element dataEncoding = addOptionsNode.addElement("dataEncoding");
                dataEncoding.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":encodingEnum");
                dataEncoding.addText(addOptions.getDataEncoding().getValue());
            }
            if (addOptions.isFaultIfObjectReferenced()) {
                Element faultOfObjectReferenced = addOptionsNode.addElement("faultIfObjectReferenced");
                faultOfObjectReferenced.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
                faultOfObjectReferenced.addText("true");
            }
            if (addOptions.isIgnoreInvalidObjectReference()) {
                Element isIgnoreInvalidObjectReference = addOptionsNode.addElement("ignoreInvalidObjectReference");
                isIgnoreInvalidObjectReference.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
                isIgnoreInvalidObjectReference.addText("true");
            }
            if (addOptions.getReturnProperties() != null) {
                Element returnPropertiesNode = addOptionsNode.addElement("returnProperties");
                returnPropertiesNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
                returnPropertiesNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[]");
                PropEnum[] returnPropEnums = addOptions.getReturnProperties();
                for (int iIndex = 0; iIndex < returnPropEnums.length; ++iIndex) {
                    Element itemArray = returnPropertiesNode.addElement("item");
                    itemArray.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
                    itemArray.addText(returnPropEnums[iIndex].getValue());
                }
            }
            if (addOptions.getUpdateAction() != null) {
                Element updateAction = addOptionsNode.addElement("updateAction");
                updateAction.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":updateActionEnum");
                updateAction.addText(addOptions.getUpdateAction().getValue());
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

