/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.AddOptionsMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ObjectMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import org.dom4j.Element;

public class AddRequestMarshaller
extends ObjectMarshaller
implements IArgumentMarshaller {
    private String m_sParentSearchPath = null;
    private AddOptions m_addOptions = null;

    public AddRequestMarshaller(String sParentSearchPath, IArgumentMarshaller[] objects, AddOptions addOptions) {
        this.m_sParentSearchPath = sParentSearchPath;
        this.m_objects = objects;
        this.m_addOptions = addOptions;
    }

    private String getParentSearchPath() {
        return this.m_sParentSearchPath;
    }

    private AddOptions getAddOptions() {
        return this.m_addOptions;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        try {
            SingleSearchPathMarshaller parentSearchPath = new SingleSearchPathMarshaller(new SearchPathSingleObject(this.getParentSearchPath()), SingleSearchPathMarshaller.BUS_PARENT_PATH);
            parentSearchPath.marshall(parentNode);
            Element objectsNode = parentNode.addElement("objects");
            objectsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            objectsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "cm:baseClass[]");
            objectsNode.addNamespace("cm", "http://developer.cognos.com/schemas/bibus/3/");
            for (int iIndex = 0; iIndex < this.m_objects.length; ++iIndex) {
                IArgumentMarshaller marshaller = this.m_objects[iIndex];
                marshaller.marshall(objectsNode);
            }
            if (this.getAddOptions() != null) {
                AddOptionsMarshaller addOptionsMarshaller = new AddOptionsMarshaller(this.getAddOptions());
                addOptionsMarshaller.marshall(parentNode);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

