/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.Annotation;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import org.dom4j.Element;

public class AnnotationMarshaller
implements IArgumentMarshaller {
    private Annotation mAnnotation = null;

    public AnnotationMarshaller(Annotation annotation) {
        this.mAnnotation = annotation;
    }

    private Annotation getAnnotation() {
        return this.mAnnotation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element annotationNode = parentNode.addElement("annotation");
        annotationNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":annotation");
        try {
            Element defaultNameValue;
            Element defaultName;
            if (this.getAnnotation().getSearchPath() != null) {
                defaultName = annotationNode.addElement("searchPath");
                defaultName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":stringProp");
                defaultNameValue = defaultName.addElement("value");
                defaultNameValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                defaultNameValue.setText(this.getAnnotation().getSearchPath().getValue());
            }
            if (this.getAnnotation().getDefaultName() != null) {
                defaultName = annotationNode.addElement("defaultName");
                defaultName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":tokenProp");
                defaultNameValue = defaultName.addElement("value");
                defaultNameValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                defaultNameValue.setText(this.getAnnotation().getDefaultName().getValue());
            }
            if (this.getAnnotation().getDefaultDescription() != null) {
                defaultName = annotationNode.addElement("defaultDescription");
                defaultName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":stringProp");
                defaultNameValue = defaultName.addElement("value");
                defaultNameValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                defaultNameValue.setText(this.getAnnotation().getDefaultDescription().getValue());
            }
            if (this.getAnnotation().getContact() != null) {
                // empty if block
            }
            if (this.getAnnotation().getContactEMail() != null) {
                // empty if block
            }
            if (this.getAnnotation().getOutputs() != null) {
                Element outputs = annotationNode.addElement("outputs");
                outputs.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClassArrayProp");
                Element value = outputs.addElement("value");
                value.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
                value.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[]");
                BaseClass[] outputBaseClassArr = this.getAnnotation().getOutputs().getValue();
                for (int iIndex = 0; iIndex < outputBaseClassArr.length; ++iIndex) {
                    Element item = value.addElement("item");
                    item.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":output");
                    if (outputBaseClassArr[iIndex].getSearchPath() != null) {
                        Element searchPath = item.addElement("searchPath");
                        searchPath.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":stringProp");
                        Element searchPathValue = searchPath.addElement("value");
                        searchPathValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                        searchPathValue.setText(outputBaseClassArr[iIndex].getSearchPath().getValue());
                    }
                    if (outputBaseClassArr[iIndex].getStoreID() == null) continue;
                    Element storeID = item.addElement("storeID");
                    storeID.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":guidProp");
                    Element storeIDValue = storeID.addElement("value");
                    storeIDValue.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":guid");
                    storeIDValue.setText(outputBaseClassArr[iIndex].getStoreID().getValue().get_value());
                }
            }
            if (this.getAnnotation().getSelectionContext() == null) return;
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

