/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerReportSpecificationFactory;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.utility.CAMFactoryPool;
import org.dom4j.Element;
import org.dom4j.QName;

public class AsynchSpecificationMarshaller
implements IArgumentMarshaller {
    public static final String BUS_SPECIFICATION = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "specification";
    private AsynchSpecification m_asynchSpecification = null;
    private boolean m_bSignSpecification = false;

    public AsynchSpecificationMarshaller(AsynchSpecification asynchSpecification) {
        this.m_asynchSpecification = asynchSpecification;
    }

    public AsynchSpecificationMarshaller(AsynchSpecification asynchSpecification, boolean bSignSpecification) {
        this.m_asynchSpecification = asynchSpecification;
        this.m_bSignSpecification = bSignSpecification;
    }

    public AsynchSpecification getAsynchSpecification() {
        return this.m_asynchSpecification;
    }

    public String getSpecificationType(Class objectClass) {
        String sSpecificationType = objectClass.getName();
        int iStartIndex = sSpecificationType.indexOf("com.cognos.developer.schemas.bibus._3.", 0) + "com.cognos.developer.schemas.bibus._3.".length();
        sSpecificationType = sSpecificationType.substring(iStartIndex, sSpecificationType.length());
        String sFirstChar = sSpecificationType.substring(0, 1);
        String sUpperCaseChar = sFirstChar.toLowerCase();
        sSpecificationType = BIBusEnvelope.NS_BUS.getPrefix() + ":" + sSpecificationType.replaceFirst(sFirstChar, sUpperCaseChar);
        return sSpecificationType;
    }

    @Override
    public void marshall(Element parentNode) throws ClassCastException {
        AsynchSpecification asynchSpecification = this.getAsynchSpecification();
        Element busSpecification = parentNode.addElement(BUS_SPECIFICATION);
        busSpecification.addAttribute(SOAPEnvelope.XSI_TYPE, this.getSpecificationType(asynchSpecification.getClass()));
        this.marshallSpecification(asynchSpecification.getValue(), busSpecification);
    }

    public void marshallSpecification(Specification specification, Element parentNode) {
        Element busValue = parentNode.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SPECIFICATION);
        String sValue = null;
        if (specification != null) {
            sValue = specification.get_value();
        }
        if (sValue != null) {
            if (this.m_bSignSpecification) {
                sValue = this.signSpecification(sValue);
            }
            busValue.setText(sValue);
        } else {
            busValue.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    private String signSpecification(String sSpecification) {
        String sSignedSpecification;
        try {
            ReportSpecProtectionSession reportSpecProtectionSession = CAMFactoryPool.createReportSpecProtectionSession();
            reportSpecProtectionSession.setSpec(sSpecification.getBytes("UTF-8"));
            byte[] protectedSpec = reportSpecProtectionSession.protectData();
            sSignedSpecification = new String(protectedSpec, "UTF-8");
        }
        catch (Throwable exception) {
            sSignedSpecification = sSpecification;
        }
        return sSignedSpecification;
    }

    public AsynchSpecification unmarshall(Element asynchSpecificationNode) throws CognosViewerException {
        QName specificationType;
        String sClassName;
        CognosViewerReportSpecificationFactory specificationFactory;
        AsynchSpecification asynchSpecification = null;
        String xsiType = asynchSpecificationNode.attributeValue(SOAPEnvelope.XSI_TYPE);
        if (xsiType != null && xsiType.length() != 0 && (asynchSpecification = (specificationFactory = new CognosViewerReportSpecificationFactory()).load(sClassName = (specificationType = QName.get((String)xsiType, (String)"http://developer.cognos.com/schemas/bibus/3/")).getName())) != null) {
            asynchSpecification.setValue(this.unmarshallSpecification(asynchSpecificationNode.element("value")));
        }
        return asynchSpecification;
    }

    public Specification unmarshallSpecification(Element specificationNode) {
        Specification specification = null;
        if (specificationNode != null) {
            specification = new Specification();
            specification.set_value(specificationNode.getText());
        }
        return specification;
    }
}

