/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParametersMarshaller;
import com.cognos.viewer.model.marshallers.SingleSearchPathMarshaller;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ConversationMarshaller
implements IArgumentMarshaller {
    public static final QName BUS_CONVERSATION = DocumentHelper.createQName((String)"conversation", (Namespace)BIBusEnvelope.NS_BUS);
    public static final QName BUS_STATEDATA = DocumentHelper.createQName((String)"stateData", (Namespace)BIBusEnvelope.NS_BUS);
    public static final QName BUS_SPECIFICATION = DocumentHelper.createQName((String)"specification", (Namespace)BIBusEnvelope.NS_BUS);
    public static final String BUS_ASYNCH_REQUEST = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchRequest";
    public static final String BUS_ASYNCH_SPECIFICATION_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchSpecification[]";
    public static final String BUS_XMLENCODED_XML = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "xmlEncodedXML";
    private AsynchRequest m_asynchRequest = null;

    public ConversationMarshaller(AsynchRequest asynchRequest) {
        this.m_asynchRequest = asynchRequest;
    }

    private AsynchRequest getAsynchRequest() {
        return this.m_asynchRequest;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        try {
            AsynchRequest asynchRequest = this.getAsynchRequest();
            if (asynchRequest == null) {
                return;
            }
            Element busConversation = parentNode.addElement(BUS_CONVERSATION);
            busConversation.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_ASYNCH_REQUEST);
            if (asynchRequest.getName() == null) {
                busConversation.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            } else {
                Element conversationName = busConversation.addElement(BUS_NAME);
                conversationName.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                conversationName.setText(asynchRequest.getName());
                SingleSearchPathMarshaller singleSearchPathMarshaller = new SingleSearchPathMarshaller(asynchRequest.getObjectPath());
                singleSearchPathMarshaller.marshall(busConversation);
                ParametersMarshaller parametersMarshaller = new ParametersMarshaller(asynchRequest.getParameters());
                parametersMarshaller.marshall(busConversation);
                OptionMarshaller optionMarshaller = new OptionMarshaller(asynchRequest.getOptions());
                optionMarshaller.marshall(busConversation);
                Element busAsynchSpecification = busConversation.addElement(BUS_SPECIFICATION);
                busAsynchSpecification.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
                busAsynchSpecification.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNCH_SPECIFICATION_ARRAY);
                AsynchSpecification[] asynchSpecification = asynchRequest.getSpecification();
                if (asynchSpecification != null) {
                    int iArraySize = asynchSpecification.length;
                    for (int iIndex = 0; iIndex < iArraySize; ++iIndex) {
                        AsynchSpecificationMarshaller asynchSpecificationMarshaller = new AsynchSpecificationMarshaller(null);
                        Element item = busAsynchSpecification.addElement("item");
                        item.addAttribute(SOAPEnvelope.XSI_TYPE, asynchSpecificationMarshaller.getSpecificationType(asynchSpecification[iIndex].getClass()));
                        asynchSpecificationMarshaller.marshallSpecification(asynchSpecification[iIndex].getValue(), item);
                    }
                }
                Element busStateData = busConversation.addElement(BUS_STATEDATA);
                busStateData.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_XMLENCODED_XML);
                if (asynchRequest.getStateData() != null && asynchRequest.getStateData().get_value().length() > 0) {
                    busStateData.setText(asynchRequest.getStateData().get_value());
                } else {
                    busStateData.addAttribute(SOAPEnvelope.XSI_NIL, "true");
                }
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public AsynchRequest unmarshall(Element asynchRequestNode) throws CognosViewerException {
        try {
            Element stateDataNode;
            Element specification;
            Element optionsNode;
            Element parameterValuesNode;
            Element singleSearchPathNode;
            AsynchRequest asynchRequest = new AsynchRequest();
            Element conversationNameNode = asynchRequestNode.element(BUS_NAME);
            if (conversationNameNode != null) {
                asynchRequest.setName(conversationNameNode.getText());
            }
            if ((singleSearchPathNode = asynchRequestNode.element("objectPath")) != null) {
                SingleSearchPathMarshaller singleSearchPathMarshaller = new SingleSearchPathMarshaller(null);
                SearchPathSingleObject objectPath = singleSearchPathMarshaller.unmarshall(singleSearchPathNode);
                asynchRequest.setObjectPath(objectPath);
            }
            if ((parameterValuesNode = asynchRequestNode.element("parameters")) != null) {
                ParametersMarshaller parametersMarshaller = new ParametersMarshaller(null);
                ParameterValue[] parameterValues = parametersMarshaller.unmarshall(parameterValuesNode);
                asynchRequest.setParameters(parameterValues);
            }
            if ((optionsNode = asynchRequestNode.element("options")) != null) {
                OptionMarshaller optionMarshaller = new OptionMarshaller(null);
                Option[] options = optionMarshaller.unmarshall(optionsNode);
                asynchRequest.setOptions(options);
            }
            if ((specification = asynchRequestNode.element("specification")) != null) {
                AsynchSpecificationMarshaller asynchSpecificationMarshaller = new AsynchSpecificationMarshaller(null);
                List asynchSpecificationList = specification.elements();
                int iNumberOfSpecifications = asynchSpecificationList.size();
                AsynchSpecification[] asynchSpecification = new AsynchSpecification[iNumberOfSpecifications];
                for (int iIndex = 0; iIndex < iNumberOfSpecifications; ++iIndex) {
                    asynchSpecification[iIndex] = asynchSpecificationMarshaller.unmarshall((Element)asynchSpecificationList.get(iIndex));
                }
                asynchRequest.setSpecification(asynchSpecification);
            }
            if ((stateDataNode = asynchRequestNode.element("stateData")) != null) {
                XmlEncodedXML xmlEncodedXML = new XmlEncodedXML();
                xmlEncodedXML.set_value(stateDataNode.getText());
                asynchRequest.setStateData(xmlEncodedXML);
            }
            return asynchRequest;
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

