/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.DeleteOptionsMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import org.dom4j.Element;

public class DeleteRequestMarshaller
implements IArgumentMarshaller {
    private String[] m_searchPaths = null;
    private DeleteOptions m_deleteOptions = null;
    private String[] m_objectTypes = null;

    public DeleteRequestMarshaller(String[] searchPaths, String[] objectTypes, DeleteOptions deleteOptions) {
        this.m_searchPaths = searchPaths;
        this.m_objectTypes = objectTypes;
        this.m_deleteOptions = deleteOptions;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        try {
            Element objectsNode = parentNode.addElement("objects");
            objectsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            objectsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[]");
            if (this.m_searchPaths.length == this.m_objectTypes.length) {
                for (int iIndex = 0; iIndex < this.m_searchPaths.length; ++iIndex) {
                    Element item = objectsNode.addElement("item");
                    item.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + this.m_objectTypes[iIndex]);
                    Element searchPath = item.addElement("searchPath");
                    searchPath.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":stringProp");
                    Element value = searchPath.addElement("value");
                    value.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":string");
                    value.setText(this.m_searchPaths[iIndex]);
                }
            }
            if (this.m_deleteOptions != null) {
                DeleteOptionsMarshaller deleteOptionsMarshaller = new DeleteOptionsMarshaller(this.m_deleteOptions);
                deleteOptionsMarshaller.marshall(parentNode);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

