/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import java.util.List;
import org.dom4j.Element;

public class EntriesMarshaller
implements IArgumentMarshaller {
    public static final String BUS_CLASS_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "classEnum";
    private ClassEnum[] m_classEnums = null;

    public EntriesMarshaller(ClassEnum[] classEnum) {
        this.m_classEnums = classEnum;
    }

    private ClassEnum[] getClassEnums() {
        return this.m_classEnums;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element optionsNode = parentNode.addElement("entries");
        optionsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:classEnum[]");
        ClassEnum[] classEnums = this.getClassEnums();
        if (classEnums != null) {
            for (int iIndex = 0; iIndex < classEnums.length; ++iIndex) {
                ClassEnum classEnum = classEnums[iIndex];
                Element item = optionsNode.addElement("item");
                item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CLASS_ENUM);
                item.setText(classEnum.getValue());
            }
        }
    }

    public ClassEnum[] unmarshall(Element optionsNode) throws CognosViewerException {
        ClassEnum[] classEnums = null;
        try {
            List classEnumList = optionsNode.elements();
            int iNumberOfClassEnums = classEnumList.size();
            classEnums = new ClassEnum[iNumberOfClassEnums];
            for (int iIndex = 0; iIndex < iNumberOfClassEnums; ++iIndex) {
                Element currentClassEnum = (Element)classEnumList.get(iIndex);
                classEnums[iIndex] = ClassEnum.fromString((String)currentClassEnum.getText());
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
        return classEnums;
    }
}

