/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.AsynchOptionBoolean;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOption;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionBoolean;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionInt;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionPropEnumArray;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionRefPropArray;
import com.cognos.developer.schemas.bibus._3.ContentManagerQueryOptionString;
import com.cognos.developer.schemas.bibus._3.ContextFormatEnum;
import com.cognos.developer.schemas.bibus._3.ContextOptionEnum;
import com.cognos.developer.schemas.bibus._3.ContextOptionFormat;
import com.cognos.developer.schemas.bibus._3.ContextOptionStringArray;
import com.cognos.developer.schemas.bibus._3.ContextOptionType;
import com.cognos.developer.schemas.bibus._3.ContextTypeEnum;
import com.cognos.developer.schemas.bibus._3.DataEnum;
import com.cognos.developer.schemas.bibus._3.DrillOptionEnum;
import com.cognos.developer.schemas.bibus._3.DrillOptionParameterValues;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionBoolean;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionEnum;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.GenericOption;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OutputEncapsulationEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionAnyURI;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OptionEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.ReportSaveAsEnum;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionBoolean;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionEnum;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionSpecificationFormat;
import com.cognos.developer.schemas.bibus._3.RunOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionData;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionNameValueArray;
import com.cognos.developer.schemas.bibus._3.RunOptionOutputEncapsulation;
import com.cognos.developer.schemas.bibus._3.RunOptionSaveAs;
import com.cognos.developer.schemas.bibus._3.RunOptionString;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SpecificationFormatEnum;
import com.cognos.developer.schemas.bibus._3.SpecificationOptionEnum;
import com.cognos.developer.schemas.bibus._3.SpecificationOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.GenericOptionXMLEncodedXMLAsAttachment;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValueMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.RefPropMarshaller;
import com.cognos.viewer.utility.IPFLogger;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class OptionMarshaller
implements IArgumentMarshaller {
    private static HashMap m_marshallers = new HashMap();
    private static HashMap m_unmarshallers = new HashMap();
    public static final String BUS_OPTIONS;
    public static final String BUS_ASYNCH_OPTION_ENUM;
    public static final String BUS_ASYNCH_OPTION_BOOLEAN;
    public static final String BUS_ASYNCH_OPTION_INT;
    public static final String BUS_ASYNCH_OPTION_ENCODING;
    public static final String BUS_RUN_OPTION_ENUM;
    public static final String BUS_REPORT_SAVE_AS_ENUM;
    public static final String BUS_RUN_OPTION_BOOLEAN;
    public static final String BUS_RUN_OPTION_INT;
    public static final String BUS_RUN_OPTION_STRING;
    public static final String BUS_RUN_OPTION_ANY_URI;
    public static final String BUS_RUN_OPTION_STRING_ARRAY;
    public static final String BUS_RUN_OPTION_LANGUAGE_ARRAY;
    public static final String BUS_RUN_OPTION_DATA;
    public static final String BUS_RUN_OPTION_OUTPUT_ENCAPSULATION;
    public static final String BUS_RUN_OPTION_NAME_VALUE_ARRAY;
    public static final String BUS_RUN_OPTION_SAVE_AS;
    public static final QName BUS_OBJECT_CLASS;
    public static final QName BUS_OBJECT_NAME;
    public static final QName BUS_PARENT_SEARCH_PATH;
    public static final String BUS_MULTILINGUAL_TOKEN;
    public static final QName BUS_LOCALE;
    public static final String BUS_DRILL_OPTION_ENUM;
    public static final String BUS_DRILL_OPTION_PARAMETER_VALUES;
    public static final String BUS_DRILL_THROUGH_OPTION_ENUM;
    public static final String BUS_SPECIFICATION_OPTION_ENUM;
    public static final String BUS_DRILL_THROUGH_OPTION_XML_ENCODED_XML;
    public static final String BUS_SPECIFICATION_OPTION_XML_ENCODED_XML;
    public static final String BUS_DRILL_THROUGH_OPTION_BOOLEAN;
    public static final String BUS_XML_ENCODED_XML;
    public static final String BUS_CONTEXT_OPTION_ENUM;
    public static final String BUS_CONTEXT_OPTION_FORMAT;
    public static final String BUS_CONTEXT_OPTION_TYPE;
    public static final String BUS_CONTEXT_OPTION_SELECTION;
    public static final String BUS_CONTEXT_FORMAT_ENUM;
    public static final String BUS_CONTEXT_TYPE_ENUM;
    public static final String BUS_CONTEXT_OPTION_STRING_ARRAY;
    public static final String BUS_GENERIC_OPTION_BOOLEAN;
    public static final String BUS_GENERIC_OPTION_XML_ENCODED_STRING;
    public static final String BUS_GENERIC_OPTION_ANY_URI;
    public static final String BUS_GENERIC_OPTION_XML_ENCODED_XML;
    public static final String BUS_CONTENT_MANAGER_CACHE_OPTION_ENUM;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_BOOLEAN;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_INT;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_STRING;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_REF_PROP_ARRAY;
    public static final String BUS_CONTENT_MANAGER_QUERY_OPTION_PROP_ENUM_ARRAY;
    public static final String BUS_REPORT_SERVICE_QUERY_OPTION_BOOLEAN;
    public static final String BUS_REPORT_SERVICE_QUERY_OPTION_ENUM;
    public static final String BUS_REPORT_SERVICE_QUERY_OPTION_SPECIFICATION_FORMTAT;
    public static final String BUS_SPECIFICATION_FORMTAT_ENUM;
    private static final String BUS_POWERPLAY8_OPTION_ANY_URI;
    private static final String BUS_POWERPLAY8_OPTION_ENUM;
    private Option[] m_options = null;
    private List<InputStream> m_attachments = new ArrayList<InputStream>();

    public OptionMarshaller(Option[] options) {
        this.m_options = options;
    }

    private Option[] getOptions() {
        return this.m_options;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element optionsNode = parentNode.addElement("options");
        optionsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:option[]");
        try {
            Option[] options = this.getOptions();
            if (options != null) {
                for (int iIndex = 0; iIndex < options.length; ++iIndex) {
                    Option currentOption = options[iIndex];
                    String sClass = currentOption.getClass().getName();
                    if (sClass.indexOf("com.cognos.viewer.model.marshallers.OptionMarshaller$") == 0) {
                        sClass = sClass.substring("com.cognos.viewer.model.marshallers.OptionMarshaller$".length(), sClass.length());
                    } else {
                        int idx = sClass.indexOf("com.cognos.developer.schemas.bibus._3.", 0);
                        if (idx != -1) {
                            int iStartIndex = idx + "com.cognos.developer.schemas.bibus._3.".length();
                            sClass = sClass.substring(iStartIndex, sClass.length());
                        } else {
                            idx = sClass.lastIndexOf(46);
                            if (idx != -1) {
                                sClass = sClass.substring(idx + 1);
                            }
                        }
                    }
                    Method marshallerMethod = (Method)m_marshallers.get(sClass);
                    marshallerMethod.invoke((Object)this, currentOption, optionsNode);
                }
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }

    public Option[] unmarshall(Element optionsNode) throws CognosViewerException {
        Option[] options = null;
        try {
            List optionList = optionsNode.elements();
            int iNumberOfOptions = optionList.size();
            options = new Option[iNumberOfOptions];
            for (int iIndex = 0; iIndex < iNumberOfOptions; ++iIndex) {
                String sUpperCaseChar;
                Element currentOption = (Element)optionList.get(iIndex);
                String xsiType = currentOption.attributeValue(SOAPEnvelope.XSI_TYPE);
                if (xsiType == null || xsiType.length() <= 0) continue;
                QName optionType = QName.get((String)xsiType, (String)"http://developer.cognos.com/schemas/bibus/3/");
                String sClassName = optionType.getName();
                String sFirstChar = sClassName.substring(0, 1);
                Method unmarshallerMethod = (Method)m_unmarshallers.get(sClassName = sClassName.replaceFirst(sFirstChar, sUpperCaseChar = sFirstChar.toUpperCase()));
                if (unmarshallerMethod != null) {
                    options[iIndex] = (Option)unmarshallerMethod.invoke((Object)this, currentOption);
                    continue;
                }
                unmarshallerMethod = (Method)m_unmarshallers.get("ElementOption");
                options[iIndex] = (Option)unmarshallerMethod.invoke((Object)this, currentOption);
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
        return options;
    }

    private void marshallSimpleNameValueArrayOption(Element parentNode, String sOptionType, String sNameType, String sName, String[] saValue) {
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, sOptionType);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, sNameType);
        busName.setText(sName);
        Element busValue = item.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        busValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "xsd:string[]");
        for (int iIndex = 0; iIndex < saValue.length; ++iIndex) {
            Element stringItem = busValue.addElement("item");
            stringItem.setText(saValue[iIndex]);
        }
    }

    private void marshallSimpleNameValueOption(Element parentNode, String sOptionType, String sNameType, String sName, String sValueType, String sValue) {
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, sOptionType);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, sNameType);
        busName.setText(sName);
        Element busValue = item.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, sValueType);
        busValue.setText(sValue);
    }

    public void marshallAsynchOptionBoolean(Option option, Element parentNode) throws ClassCastException {
        AsynchOptionBoolean asynchOptionBoolean = (AsynchOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_ASYNCH_OPTION_BOOLEAN, BUS_ASYNCH_OPTION_ENUM, asynchOptionBoolean.getName().getValue(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(asynchOptionBoolean.isValue()));
    }

    public void marshallAsynchOptionInt(Option option, Element parentNode) throws ClassCastException {
        AsynchOptionInt asynchOptionInt = (AsynchOptionInt)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_ASYNCH_OPTION_INT, BUS_ASYNCH_OPTION_ENUM, asynchOptionInt.getName().getValue(), SOAPEnvelope.XSD_INT, Integer.toString(asynchOptionInt.getValue()));
    }

    public void marshallAsynchOptionEncoding(Option option, Element parentNode) throws ClassCastException {
        AsynchOptionEncoding asynchOptionEncoding = (AsynchOptionEncoding)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_ASYNCH_OPTION_ENCODING, BUS_ASYNCH_OPTION_ENUM, asynchOptionEncoding.getName().getValue(), "bus:encodingEnum", asynchOptionEncoding.getValue().getValue());
    }

    public void marshallRunOptionBoolean(Option option, Element parentNode) throws ClassCastException {
        RunOptionBoolean runOptionBoolean = (RunOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_BOOLEAN, BUS_RUN_OPTION_ENUM, runOptionBoolean.getName().getValue(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(runOptionBoolean.isValue()));
    }

    public void marshallRunOptionAnyURI(Option option, Element parentNode) throws ClassCastException {
        RunOptionAnyURI runOptionAnyURI = (RunOptionAnyURI)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_ANY_URI, BUS_RUN_OPTION_ENUM, runOptionAnyURI.getName().getValue(), SOAPEnvelope.XSD_STRING, runOptionAnyURI.getValue());
    }

    public void marshallRunOptionData(Option option, Element parentNode) throws ClassCastException {
        RunOptionData runOptionData = (RunOptionData)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_DATA, BUS_RUN_OPTION_ENUM, runOptionData.getName().getValue(), "bus:dataEnum", runOptionData.getValue().getValue());
    }

    public void marshallRunOptionInt(Option option, Element parentNode) throws ClassCastException {
        RunOptionInt runOptionInt = (RunOptionInt)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_INT, BUS_RUN_OPTION_ENUM, runOptionInt.getName().getValue(), SOAPEnvelope.XSD_INT, Integer.toString(runOptionInt.getValue()));
    }

    public void marshallRunOptionString(Option option, Element parentNode) throws ClassCastException {
        RunOptionString runOptionString = (RunOptionString)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_STRING, BUS_RUN_OPTION_ENUM, runOptionString.getName().getValue(), SOAPEnvelope.XSD_STRING, runOptionString.getValue());
    }

    public void marshallRunOptionStringArray(Option option, Element parentNode) throws ClassCastException {
        RunOptionStringArray runOptionStringArray = (RunOptionStringArray)option;
        this.marshallSimpleNameValueArrayOption(parentNode, BUS_RUN_OPTION_STRING_ARRAY, BUS_RUN_OPTION_ENUM, runOptionStringArray.getName().getValue(), runOptionStringArray.getValue());
    }

    public void marshallRunOptionSaveAs(Option option, Element parentNode) throws ClassCastException {
        RunOptionSaveAs runOptionSaveAs = (RunOptionSaveAs)option;
        Element busItem = parentNode.addElement("item");
        busItem.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_RUN_OPTION_SAVE_AS);
        Element name = busItem.addElement(BUS_NAME);
        name.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_RUN_OPTION_ENUM);
        name.setText(runOptionSaveAs.getName().getValue());
        Element objectClass = busItem.addElement(BUS_OBJECT_CLASS);
        objectClass.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_REPORT_SAVE_AS_ENUM);
        objectClass.setText(runOptionSaveAs.getObjectClass().getValue());
        MultilingualToken[] objectNameArray = runOptionSaveAs.getObjectName();
        Element objectName = busItem.addElement(BUS_OBJECT_NAME);
        objectName.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        objectName.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_MULTILINGUAL_TOKEN + "[]");
        for (int index = 0; index < objectNameArray.length; ++index) {
            Element multiLingualItem = objectName.addElement("item");
            multiLingualItem.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_MULTILINGUAL_TOKEN);
            Element locale = multiLingualItem.addElement(BUS_LOCALE);
            locale.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            locale.setText(objectNameArray[index].getLocale());
            Element value = multiLingualItem.addElement(BUS_VALUE);
            value.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            value.setText(objectNameArray[index].getValue());
        }
        Element parentSearchPath = busItem.addElement(BUS_PARENT_SEARCH_PATH);
        parentSearchPath.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        parentSearchPath.setText(runOptionSaveAs.getParentSearchPath());
    }

    public void marshallDrillOptionParameterValues(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        DrillOptionParameterValues drillOption = (DrillOptionParameterValues)option;
        Element busItem = parentNode.addElement("item");
        busItem.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_DRILL_OPTION_PARAMETER_VALUES);
        Element busName = busItem.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_DRILL_OPTION_ENUM);
        busName.setText(drillOption.getName().getValue());
        Element busValue = busItem.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        busValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, ParameterValueMarshaller.BUS_PARAMETER_VALUE + "[]");
        ParameterValue[] parameterValues = drillOption.getValue();
        int iArraySize = parameterValues.length;
        for (int iIndex = 0; iIndex < iArraySize; ++iIndex) {
            ParameterValueMarshaller parameterValueMarshaller = new ParameterValueMarshaller(parameterValues[iIndex]);
            parameterValueMarshaller.marshall(busValue);
        }
    }

    public void marshallSpecificationOptionXMLEncodedXML(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        SpecificationOptionXMLEncodedXML specificationOptionXMLEncodedXML = (SpecificationOptionXMLEncodedXML)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_SPECIFICATION_OPTION_XML_ENCODED_XML, BUS_SPECIFICATION_OPTION_ENUM, specificationOptionXMLEncodedXML.getName().getValue(), BUS_XML_ENCODED_XML, specificationOptionXMLEncodedXML.getValue().get_value());
    }

    public void marshallDrillThroughOptionXMLEncodedXML(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        DrillThroughOptionXMLEncodedXML drillThroughSelectionContext = (DrillThroughOptionXMLEncodedXML)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_DRILL_THROUGH_OPTION_XML_ENCODED_XML, BUS_DRILL_THROUGH_OPTION_ENUM, drillThroughSelectionContext.getName().getValue(), BUS_XML_ENCODED_XML, drillThroughSelectionContext.getValue().get_value());
    }

    public void marshallDrillThroughOptionBoolean(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        DrillThroughOptionBoolean drillThroughOptionBoolean = (DrillThroughOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_DRILL_THROUGH_OPTION_BOOLEAN, BUS_DRILL_THROUGH_OPTION_ENUM, drillThroughOptionBoolean.getName().getValue(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(drillThroughOptionBoolean.isValue()));
    }

    public void marshallReportServiceQueryOptionBoolean(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        ReportServiceQueryOptionBoolean reportServiceQueryOptionBoolean = (ReportServiceQueryOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_REPORT_SERVICE_QUERY_OPTION_BOOLEAN, BUS_REPORT_SERVICE_QUERY_OPTION_ENUM, reportServiceQueryOptionBoolean.getName().getValue(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(reportServiceQueryOptionBoolean.isValue()));
    }

    public void marshallReportServiceQueryOptionSpecificationFormat(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        ReportServiceQueryOptionSpecificationFormat reportServiceQueryOptionSpecificationFormat = (ReportServiceQueryOptionSpecificationFormat)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_REPORT_SERVICE_QUERY_OPTION_SPECIFICATION_FORMTAT, BUS_REPORT_SERVICE_QUERY_OPTION_ENUM, reportServiceQueryOptionSpecificationFormat.getName().getValue(), BUS_SPECIFICATION_FORMTAT_ENUM, reportServiceQueryOptionSpecificationFormat.getValue().getValue());
    }

    public void marshallRunOptionNameValueArray(Option option, Element parentNode) throws ClassCastException {
        RunOptionNameValueArray runOptionNameValueArray = (RunOptionNameValueArray)option;
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_RUN_OPTION_NAME_VALUE_ARRAY);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_RUN_OPTION_ENUM);
        busName.setText(runOptionNameValueArray.getName().getValue());
        Element busValue = item.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        busValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:nameValue[]");
        NameValue[] nameValueArray = runOptionNameValueArray.getValue();
        for (int iIndex = 0; iIndex < nameValueArray.length; ++iIndex) {
            Element busItem = busValue.addElement("item");
            Element busItemName = busItem.addElement(BUS_NAME);
            busItemName.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            busItemName.setText(nameValueArray[iIndex].getName());
            Element busItemValue = busItem.addElement(BUS_VALUE);
            busItemValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            busItemValue.setText(nameValueArray[iIndex].getValue());
        }
    }

    public void marshallRunOptionLanguageArray(Option option, Element parentNode) throws ClassCastException {
        RunOptionLanguageArray runOptionLanguageArray = (RunOptionLanguageArray)option;
        this.marshallSimpleNameValueArrayOption(parentNode, BUS_RUN_OPTION_LANGUAGE_ARRAY, BUS_RUN_OPTION_ENUM, runOptionLanguageArray.getName().getValue(), runOptionLanguageArray.getValue());
    }

    public void marshallRunOptionOutputEncapsulation(Option option, Element parentNode) throws ClassCastException {
        RunOptionOutputEncapsulation runOptionOutputEncapsulation = (RunOptionOutputEncapsulation)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_RUN_OPTION_OUTPUT_ENCAPSULATION, BUS_RUN_OPTION_ENUM, runOptionOutputEncapsulation.getName().getValue(), "bus:outputEncapsulationEnum", runOptionOutputEncapsulation.getValue().getValue());
    }

    public void marshallContextOptionType(Option option, Element parentNode) throws ClassCastException {
        ContextOptionType contextOptionType = (ContextOptionType)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_CONTEXT_OPTION_TYPE, BUS_CONTEXT_OPTION_ENUM, contextOptionType.getName().getValue(), BUS_CONTEXT_TYPE_ENUM, contextOptionType.getValue().getValue());
    }

    public void marshallContextOptionFormat(Option option, Element parentNode) throws ClassCastException {
        ContextOptionFormat contextOptionFormat = (ContextOptionFormat)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_CONTEXT_OPTION_FORMAT, BUS_CONTEXT_OPTION_ENUM, contextOptionFormat.getName().getValue(), BUS_CONTEXT_FORMAT_ENUM, contextOptionFormat.getValue().getValue());
    }

    public void marshallContextOptionStringArray(Option option, Element parentNode) throws ClassCastException {
        ContextOptionStringArray contextOptionSelection = (ContextOptionStringArray)option;
        this.marshallSimpleNameValueArrayOption(parentNode, BUS_CONTEXT_OPTION_STRING_ARRAY, BUS_CONTEXT_OPTION_ENUM, contextOptionSelection.getName().getValue(), contextOptionSelection.getValue());
    }

    public void marshallPowerPlay8OptionAnyURI(Option option, Element parentNode) throws ClassCastException {
        PowerPlay8OptionAnyURI powerPlay8OptionAnyURI = (PowerPlay8OptionAnyURI)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_POWERPLAY8_OPTION_ANY_URI, BUS_POWERPLAY8_OPTION_ENUM, powerPlay8OptionAnyURI.getName().getValue(), SOAPEnvelope.XSD_STRING, powerPlay8OptionAnyURI.getValue());
    }

    public void marshallGenericOptionXMLEncodedXML(Option option, Element parentNode) throws ClassCastException {
        GenericOptionXMLEncodedXML genericOptionXML = (GenericOptionXMLEncodedXML)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_GENERIC_OPTION_XML_ENCODED_STRING, SOAPEnvelope.XSD_STRING, genericOptionXML.getName(), BUS_GENERIC_OPTION_XML_ENCODED_XML, genericOptionXML.getValue().get_value());
    }

    public void marshallGenericOptionAnyURI(Option option, Element parentNode) throws ClassCastException {
        GenericOptionAnyURI genericOptionAnyURI = (GenericOptionAnyURI)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_GENERIC_OPTION_ANY_URI, SOAPEnvelope.XSD_STRING, genericOptionAnyURI.getName(), SOAPEnvelope.XSD_STRING, genericOptionAnyURI.getValue());
    }

    public void marshallGenericOptionBoolean(Option option, Element parentNode) throws ClassCastException {
        GenericOptionBoolean genericOptionBoolean = (GenericOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_GENERIC_OPTION_BOOLEAN, SOAPEnvelope.XSD_STRING, genericOptionBoolean.getName(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(genericOptionBoolean.isValue()));
    }

    public void marshallContentManagerQueryOptionBoolean(Option option, Element parentNode) throws ClassCastException {
        ContentManagerQueryOptionBoolean contentManagerQueryOptionBoolean = (ContentManagerQueryOptionBoolean)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_CONTENT_MANAGER_QUERY_OPTION_BOOLEAN, BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM, contentManagerQueryOptionBoolean.getName().getValue(), SOAPEnvelope.XSD_BOOLEAN, Boolean.toString(contentManagerQueryOptionBoolean.isValue()));
    }

    public void marshallContentManagerQueryOptionString(Option option, Element parentNode) throws ClassCastException {
        ContentManagerQueryOptionString contentManagerQueryOptionString = (ContentManagerQueryOptionString)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_CONTENT_MANAGER_QUERY_OPTION_STRING, BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM, contentManagerQueryOptionString.getName().getValue(), SOAPEnvelope.XSD_STRING, contentManagerQueryOptionString.getValue());
    }

    public void marshallContentManagerQueryOptionInt(Option option, Element parentNode) throws ClassCastException {
        ContentManagerQueryOptionInt contentManagerQueryOptionInt = (ContentManagerQueryOptionInt)option;
        this.marshallSimpleNameValueOption(parentNode, BUS_CONTENT_MANAGER_QUERY_OPTION_INT, BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM, contentManagerQueryOptionInt.getName().getValue(), SOAPEnvelope.XSD_INT, Integer.toString(contentManagerQueryOptionInt.getValue()));
    }

    public void marshallContentManagerQueryOptionPropEnumArray(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        ContentManagerQueryOptionPropEnumArray contentManagerQueryOptionPropEnumArray = (ContentManagerQueryOptionPropEnumArray)option;
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CONTENT_MANAGER_QUERY_OPTION_PROP_ENUM_ARRAY);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM);
        busName.setText(contentManagerQueryOptionPropEnumArray.getName().getValue());
        PropEnumMarshaller propEnumMarshaller = new PropEnumMarshaller(contentManagerQueryOptionPropEnumArray.getValue());
        propEnumMarshaller.marshall(item, BUS_VALUE);
    }

    public void marshallContentManagerQueryOptionRefPropArray(Option option, Element parentNode) throws ClassCastException, CognosViewerException {
        ContentManagerQueryOptionRefPropArray contentManagerQueryOptionRefPropArray = (ContentManagerQueryOptionRefPropArray)option;
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CONTENT_MANAGER_QUERY_OPTION_REF_PROP_ARRAY);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM);
        busName.setText(contentManagerQueryOptionRefPropArray.getName().getValue());
        RefPropMarshaller refPropMarshaller = new RefPropMarshaller(contentManagerQueryOptionRefPropArray.getValue());
        refPropMarshaller.marshall(item, BUS_VALUE);
    }

    public void marshallElementOption(Option option, Element parentNode) throws ClassCastException {
        ElementOption elementOption = (ElementOption)option;
        Element value = elementOption.getValue();
        if (value != null) {
            parentNode.add(value.createCopy());
        }
    }

    public Option unmarshallGenericOptionXMLEncodedXML(Element optionNode) {
        Element busValue;
        GenericOptionXMLEncodedXML genericOptionXMLEncodedXML = new GenericOptionXMLEncodedXML();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            genericOptionXMLEncodedXML.setName(busName.getText());
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            genericOptionXMLEncodedXML.setValue(new XmlEncodedXML(busValue.getText()));
        }
        return genericOptionXMLEncodedXML;
    }

    public Option unmarshallGenericOptionBoolean(Element optionNode) {
        Element busValue;
        GenericOptionBoolean genericOptionBoolean = new GenericOptionBoolean();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            genericOptionBoolean.setName(busName.getText());
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            genericOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return genericOptionBoolean;
    }

    public Option unmarshallGenericOptionAnyURI(Element optionNode) {
        Element busValue;
        GenericOptionAnyURI genericOptionAnyURI = new GenericOptionAnyURI();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            genericOptionAnyURI.setName(busName.getText());
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            genericOptionAnyURI.setValue(busValue.getText());
        }
        return genericOptionAnyURI;
    }

    public Option unmarshallAsynchOptionBoolean(Element optionNode) {
        Element busValue;
        AsynchOptionBoolean asynchOptionBoolean = new AsynchOptionBoolean();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            asynchOptionBoolean.setName(AsynchOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            asynchOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return asynchOptionBoolean;
    }

    public Option unmarshallAsynchOptionInt(Element optionNode) {
        Element busValue;
        AsynchOptionInt asynchOptionInt = new AsynchOptionInt();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            asynchOptionInt.setName(AsynchOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            asynchOptionInt.setValue(Integer.parseInt(busValue.getText()));
        }
        return asynchOptionInt;
    }

    public Option unmarshallAsynchOptionEncoding(Element optionNode) {
        Element busValue;
        AsynchOptionEncoding asynchOptionEncoding = new AsynchOptionEncoding();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            asynchOptionEncoding.setName(AsynchOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            asynchOptionEncoding.setValue(EncodingEnum.fromString((String)busValue.getText()));
        }
        return asynchOptionEncoding;
    }

    public Option unmarshallRunOptionBoolean(Element optionNode) {
        Element busValue;
        RunOptionBoolean runOptionBoolean = new RunOptionBoolean();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionBoolean.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return runOptionBoolean;
    }

    public Option unmarshallRunOptionAnyURI(Element optionNode) {
        Element busValue;
        RunOptionAnyURI runOptionAnyURI = new RunOptionAnyURI();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionAnyURI.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionAnyURI.setValue(busValue.getText());
        }
        return runOptionAnyURI;
    }

    public Option unmarshallRunOptionData(Element optionNode) {
        Element busValue;
        RunOptionData runOptionData = new RunOptionData();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionData.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionData.setValue(DataEnum.fromValue((String)busValue.getText()));
        }
        return runOptionData;
    }

    public Option unmarshallRunOptionInt(Element optionNode) {
        Element busValue;
        RunOptionInt runOptionInt = new RunOptionInt();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionInt.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionInt.setValue(Integer.parseInt(busValue.getText()));
        }
        return runOptionInt;
    }

    public Option unmarshallReportServiceQueryOptionBoolean(Element optionNode) {
        Element busValue;
        ReportServiceQueryOptionBoolean reportServiceQueryOptionBoolean = new ReportServiceQueryOptionBoolean();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            reportServiceQueryOptionBoolean.setName(ReportServiceQueryOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            reportServiceQueryOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return reportServiceQueryOptionBoolean;
    }

    public Option unmarshallReportServiceQueryOptionSpecificationFormat(Element optionNode) {
        Element busValue;
        ReportServiceQueryOptionSpecificationFormat reportServiceQueryOptionSpecificationFormat = new ReportServiceQueryOptionSpecificationFormat();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            reportServiceQueryOptionSpecificationFormat.setName(ReportServiceQueryOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            reportServiceQueryOptionSpecificationFormat.setValue(SpecificationFormatEnum.fromString((String)busValue.getText()));
        }
        return reportServiceQueryOptionSpecificationFormat;
    }

    public Option unmarshallDrillThroughOptionBoolean(Element optionNode) {
        Element busValue;
        DrillThroughOptionBoolean drillThroughOptionBoolean = new DrillThroughOptionBoolean();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            drillThroughOptionBoolean.setName(DrillThroughOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            drillThroughOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return drillThroughOptionBoolean;
    }

    public Option unmarshallDrillThroughOptionXMLEncodedXML(Element optionNode) {
        Element busValue;
        DrillThroughOptionXMLEncodedXML drillThroughOptionXmlEncodedXML = new DrillThroughOptionXMLEncodedXML();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            drillThroughOptionXmlEncodedXML.setName(DrillThroughOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            drillThroughOptionXmlEncodedXML.setValue(new XmlEncodedXML(busValue.getText()));
        }
        return drillThroughOptionXmlEncodedXML;
    }

    public Option unmarshallSpecificationOptionXMLEncodedXML(Element optionNode) {
        Element busValue;
        SpecificationOptionXMLEncodedXML specificationOptionXMLEncodedXML = new SpecificationOptionXMLEncodedXML();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            specificationOptionXMLEncodedXML.setName(SpecificationOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            specificationOptionXMLEncodedXML.setValue(new XmlEncodedXML(busValue.getText()));
        }
        return specificationOptionXMLEncodedXML;
    }

    public Option unmarshallRunOptionString(Element optionNode) {
        Element busValue;
        RunOptionString runOptionString = new RunOptionString();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionString.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionString.setValue(busValue.getText());
        }
        return runOptionString;
    }

    public Option unmarshallRunOptionStringArray(Element optionNode) {
        Element busValue;
        RunOptionStringArray runOptionStringArray = new RunOptionStringArray();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionStringArray.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            List stringList = busValue.elements();
            int iNumberOfStrings = stringList.size();
            String[] saStrings = new String[iNumberOfStrings];
            for (int iIndex = 0; iIndex < iNumberOfStrings; ++iIndex) {
                Element item = (Element)stringList.get(iIndex);
                saStrings[iIndex] = item.getText();
            }
            runOptionStringArray.setValue(saStrings);
        }
        return runOptionStringArray;
    }

    public Option unmarshallRunOptionLanguageArray(Element optionNode) {
        Element busValue;
        RunOptionLanguageArray runOptionLanguageArray = new RunOptionLanguageArray();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionLanguageArray.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            List stringList = busValue.elements();
            int iNumberOfStrings = stringList.size();
            String[] saStrings = new String[iNumberOfStrings];
            for (int iIndex = 0; iIndex < iNumberOfStrings; ++iIndex) {
                Element item = (Element)stringList.get(iIndex);
                saStrings[iIndex] = item.getText();
            }
            runOptionLanguageArray.setValue(saStrings);
        }
        return runOptionLanguageArray;
    }

    public Option unmarshallRunOptionNameValueArray(Element optionNode) {
        Element busValue;
        RunOptionNameValueArray runOptionNameValueArray = new RunOptionNameValueArray();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionNameValueArray.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            List nameValueList = busValue.elements();
            int iNumberOfEntries = nameValueList.size();
            NameValue[] aNameValue = new NameValue[iNumberOfEntries];
            for (int iIndex = 0; iIndex < iNumberOfEntries; ++iIndex) {
                Element item = (Element)nameValueList.get(iIndex);
                Element itemName = item.element(BUS_NAME);
                Element itemValue = item.element(BUS_VALUE);
                if (itemName == null || itemValue == null) continue;
                aNameValue[iIndex] = new NameValue();
                aNameValue[iIndex].setName(itemName.getText());
                aNameValue[iIndex].setValue(itemValue.getText());
            }
            runOptionNameValueArray.setValue(aNameValue);
        }
        return runOptionNameValueArray;
    }

    public Option unmarshallRunOptionOutputEncapsulation(Element optionNode) {
        Element busValue;
        RunOptionOutputEncapsulation runOptionOutputEncapsulation = new RunOptionOutputEncapsulation();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionOutputEncapsulation.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            runOptionOutputEncapsulation.setValue(OutputEncapsulationEnum.fromValue((String)busValue.getText()));
        }
        return runOptionOutputEncapsulation;
    }

    public Option unmarshallDrillOptionParameterValues(Element optionNode) throws CognosViewerException {
        Element busValue;
        DrillOptionParameterValues drillOption = new DrillOptionParameterValues();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            drillOption.setName(DrillOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            ParameterValuesMarshaller parameterValuesMarshaller = new ParameterValuesMarshaller(null);
            try {
                drillOption.setValue(parameterValuesMarshaller.unmarshall(busValue));
            }
            catch (CognosViewerException ex) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
                throw cognosViewerException;
            }
        }
        return drillOption;
    }

    public Option unmarshallContextOptionFormat(Element optionNode) {
        Element busValue;
        ContextOptionFormat contextOptionFormat = new ContextOptionFormat();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            contextOptionFormat.setName(ContextOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            contextOptionFormat.setValue(ContextFormatEnum.fromValue((String)busValue.getText()));
        }
        return contextOptionFormat;
    }

    public Option unmarshallContextOptionType(Element optionNode) {
        Element busValue;
        ContextOptionType contextOptionType = new ContextOptionType();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            contextOptionType.setName(ContextOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            contextOptionType.setValue(ContextTypeEnum.fromValue((String)busValue.getText()));
        }
        return contextOptionType;
    }

    public Option unmarshallContextOptionStringArray(Element optionNode) {
        Element busValue;
        ContextOptionStringArray contextOptionStringArray = new ContextOptionStringArray();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            contextOptionStringArray.setName(ContextOptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            List stringList = busValue.elements();
            int iNumberOfStrings = stringList.size();
            String[] saStrings = new String[iNumberOfStrings];
            for (int iIndex = 0; iIndex < iNumberOfStrings; ++iIndex) {
                Element item = (Element)stringList.get(iIndex);
                saStrings[iIndex] = item.getText();
            }
            contextOptionStringArray.setValue(saStrings);
        }
        return contextOptionStringArray;
    }

    public Option unmarshallRunOptionSaveAs(Element optionNode) {
        Element objectClass;
        RunOptionSaveAs runOptionSaveAs = new RunOptionSaveAs();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            runOptionSaveAs.setName(RunOptionEnum.fromString((String)busName.getText()));
        }
        if ((objectClass = optionNode.element(BUS_OBJECT_CLASS)) != null) {
            runOptionSaveAs.setObjectClass(ReportSaveAsEnum.fromString((String)objectClass.getText()));
        }
        Element objectNames = optionNode.element(BUS_OBJECT_NAME);
        List objectNamesList = objectNames.elements("item");
        int listSize = objectNamesList.size();
        MultilingualToken[] saveAsNames = new MultilingualToken[listSize];
        for (int index = 0; index < listSize; ++index) {
            Element objectName = (Element)objectNamesList.get(index);
            Element local = objectName.element(BUS_LOCALE);
            Element value = objectName.element(BUS_VALUE);
            saveAsNames[index] = new MultilingualToken();
            saveAsNames[index].setLocale(local.getText());
            saveAsNames[index].setValue(value.getText());
        }
        runOptionSaveAs.setObjectName(saveAsNames);
        Element parentSearchPath = optionNode.element(BUS_PARENT_SEARCH_PATH);
        runOptionSaveAs.setParentSearchPath(parentSearchPath.getText());
        return runOptionSaveAs;
    }

    public Option unmarshallPowerPlay8OptionAnyURI(Element optionNode) {
        Element busValue;
        PowerPlay8OptionAnyURI powerPlay8OptionAnyURI = new PowerPlay8OptionAnyURI();
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            powerPlay8OptionAnyURI.setName(PowerPlay8OptionEnum.fromString((String)busName.getText()));
        }
        if ((busValue = optionNode.element(BUS_VALUE)) != null) {
            powerPlay8OptionAnyURI.setValue(busValue.getText());
        }
        return powerPlay8OptionAnyURI;
    }

    private void unmarshallContentManagerQueryOption(ContentManagerQueryOption contentManagerQueryOption, Element optionNode) {
        Element busName = optionNode.element(BUS_NAME);
        if (busName != null) {
            contentManagerQueryOption.setName(ContentManagerQueryOptionEnum.fromString((String)busName.getText()));
        }
    }

    public Option unmarshallContentManagerQueryOptionBoolean(Element optionNode) {
        ContentManagerQueryOptionBoolean contentManagerQueryOptionBoolean = new ContentManagerQueryOptionBoolean();
        this.unmarshallContentManagerQueryOption((ContentManagerQueryOption)contentManagerQueryOptionBoolean, optionNode);
        Element busValue = optionNode.element(BUS_VALUE);
        if (busValue != null) {
            contentManagerQueryOptionBoolean.setValue(Boolean.parseBoolean(busValue.getText()));
        }
        return contentManagerQueryOptionBoolean;
    }

    public Option unmarshallContentManagerQueryOptionString(Element optionNode) {
        ContentManagerQueryOptionString contentManagerQueryOptionString = new ContentManagerQueryOptionString();
        this.unmarshallContentManagerQueryOption((ContentManagerQueryOption)contentManagerQueryOptionString, optionNode);
        Element busValue = optionNode.element(BUS_VALUE);
        if (busValue != null) {
            contentManagerQueryOptionString.setValue(busValue.getText());
        }
        return contentManagerQueryOptionString;
    }

    public Option unmarshallContentManagerQueryOptionInt(Element optionNode) {
        ContentManagerQueryOptionInt contentManagerQueryOptionInt = new ContentManagerQueryOptionInt();
        this.unmarshallContentManagerQueryOption((ContentManagerQueryOption)contentManagerQueryOptionInt, optionNode);
        Element busValue = optionNode.element(BUS_VALUE);
        if (busValue != null) {
            contentManagerQueryOptionInt.setValue(Integer.parseInt(busValue.getText()));
        }
        return contentManagerQueryOptionInt;
    }

    public Option unmarshallContentManagerQueryOptionPropEnumArray(Element optionNode) {
        ContentManagerQueryOptionPropEnumArray contentManagerQueryOptionPropEnumArray = new ContentManagerQueryOptionPropEnumArray();
        this.unmarshallContentManagerQueryOption((ContentManagerQueryOption)contentManagerQueryOptionPropEnumArray, optionNode);
        Element busValue = optionNode.element(BUS_VALUE);
        if (busValue != null) {
            PropEnumMarshaller refPropMarshaller = new PropEnumMarshaller();
            PropEnum[] propEnum = refPropMarshaller.unmarshall(busValue);
            contentManagerQueryOptionPropEnumArray.setValue(propEnum);
        }
        return contentManagerQueryOptionPropEnumArray;
    }

    public Option unmarshallContentManagerQueryOptionRefPropArray(Element optionNode) {
        ContentManagerQueryOptionRefPropArray contentManagerQueryOptionRefPropArray = new ContentManagerQueryOptionRefPropArray();
        this.unmarshallContentManagerQueryOption((ContentManagerQueryOption)contentManagerQueryOptionRefPropArray, optionNode);
        Element busValue = optionNode.element(BUS_VALUE);
        if (busValue != null) {
            RefPropMarshaller refPropMarshaller = new RefPropMarshaller();
            RefProp[] refProps = refPropMarshaller.unmarshall(busValue);
            contentManagerQueryOptionRefPropArray.setValue(refProps);
        }
        return contentManagerQueryOptionRefPropArray;
    }

    public Option unmarshallElementOption(Element optionNode) {
        ElementOption elementOption = new ElementOption();
        elementOption.setValue(optionNode);
        return elementOption;
    }

    public List<InputStream> getAttachments() {
        return this.m_attachments;
    }

    public void marshallGenericOptionXMLEncodedXMLAsAttachment(Option option, Element parentNode) throws ClassCastException {
        GenericOptionXMLEncodedXMLAsAttachment optionAttachment = (GenericOptionXMLEncodedXMLAsAttachment)option;
        Element item = parentNode.addElement("item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_GENERIC_OPTION_XML_ENCODED_STRING);
        Element busName = item.addElement(BUS_NAME);
        busName.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        busName.setText(optionAttachment.getName());
        Element busValue = item.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_GENERIC_OPTION_XML_ENCODED_XML);
        busValue.addAttribute("href", "cid:" + optionAttachment.getCid());
        this.m_attachments.add(optionAttachment.getAttachment());
    }

    static {
        try {
            m_marshallers.put("AsynchOptionBoolean", OptionMarshaller.class.getMethod("marshallAsynchOptionBoolean", Option.class, Element.class));
            m_marshallers.put("AsynchOptionInt", OptionMarshaller.class.getMethod("marshallAsynchOptionInt", Option.class, Element.class));
            m_marshallers.put("AsynchOptionEncoding", OptionMarshaller.class.getMethod("marshallAsynchOptionEncoding", Option.class, Element.class));
            m_marshallers.put("RunOptionBoolean", OptionMarshaller.class.getMethod("marshallRunOptionBoolean", Option.class, Element.class));
            m_marshallers.put("RunOptionAnyURI", OptionMarshaller.class.getMethod("marshallRunOptionAnyURI", Option.class, Element.class));
            m_marshallers.put("RunOptionData", OptionMarshaller.class.getMethod("marshallRunOptionData", Option.class, Element.class));
            m_marshallers.put("RunOptionInt", OptionMarshaller.class.getMethod("marshallRunOptionInt", Option.class, Element.class));
            m_marshallers.put("RunOptionString", OptionMarshaller.class.getMethod("marshallRunOptionString", Option.class, Element.class));
            m_marshallers.put("RunOptionStringArray", OptionMarshaller.class.getMethod("marshallRunOptionStringArray", Option.class, Element.class));
            m_marshallers.put("RunOptionSaveAs", OptionMarshaller.class.getMethod("marshallRunOptionSaveAs", Option.class, Element.class));
            m_marshallers.put("DrillOptionParameterValues", OptionMarshaller.class.getMethod("marshallDrillOptionParameterValues", Option.class, Element.class));
            m_marshallers.put("RunOptionNameValueArray", OptionMarshaller.class.getMethod("marshallRunOptionNameValueArray", Option.class, Element.class));
            m_marshallers.put("RunOptionLanguageArray", OptionMarshaller.class.getMethod("marshallRunOptionLanguageArray", Option.class, Element.class));
            m_marshallers.put("RunOptionOutputEncapsulation", OptionMarshaller.class.getMethod("marshallRunOptionOutputEncapsulation", Option.class, Element.class));
            m_marshallers.put("ContextOptionType", OptionMarshaller.class.getMethod("marshallContextOptionType", Option.class, Element.class));
            m_marshallers.put("ContextOptionFormat", OptionMarshaller.class.getMethod("marshallContextOptionFormat", Option.class, Element.class));
            m_marshallers.put("ContextOptionStringArray", OptionMarshaller.class.getMethod("marshallContextOptionStringArray", Option.class, Element.class));
            m_marshallers.put("DrillThroughOptionXMLEncodedXML", OptionMarshaller.class.getMethod("marshallDrillThroughOptionXMLEncodedXML", Option.class, Element.class));
            m_marshallers.put("SpecificationOptionXMLEncodedXML", OptionMarshaller.class.getMethod("marshallSpecificationOptionXMLEncodedXML", Option.class, Element.class));
            m_marshallers.put("DrillThroughOptionBoolean", OptionMarshaller.class.getMethod("marshallDrillThroughOptionBoolean", Option.class, Element.class));
            m_marshallers.put("ReportServiceQueryOptionBoolean", OptionMarshaller.class.getMethod("marshallReportServiceQueryOptionBoolean", Option.class, Element.class));
            m_marshallers.put("ReportServiceQueryOptionSpecificationFormat", OptionMarshaller.class.getMethod("marshallReportServiceQueryOptionSpecificationFormat", Option.class, Element.class));
            m_marshallers.put("PowerPlay8OptionAnyURI", OptionMarshaller.class.getMethod("marshallPowerPlay8OptionAnyURI", Option.class, Element.class));
            m_marshallers.put("GenericOptionBoolean", OptionMarshaller.class.getMethod("marshallGenericOptionBoolean", Option.class, Element.class));
            m_marshallers.put("GenericOptionXMLEncodedXML", OptionMarshaller.class.getMethod("marshallGenericOptionXMLEncodedXML", Option.class, Element.class));
            m_marshallers.put("GenericOptionAnyURI", OptionMarshaller.class.getMethod("marshallGenericOptionAnyURI", Option.class, Element.class));
            m_marshallers.put("GenericOptionAnyURI", OptionMarshaller.class.getMethod("marshallGenericOptionAnyURI", Option.class, Element.class));
            m_marshallers.put("ContentManagerQueryOptionBoolean", OptionMarshaller.class.getMethod("marshallContentManagerQueryOptionBoolean", Option.class, Element.class));
            m_marshallers.put("ContentManagerQueryOptionInt", OptionMarshaller.class.getMethod("marshallContentManagerQueryOptionInt", Option.class, Element.class));
            m_marshallers.put("ContentManagerQueryOptionString", OptionMarshaller.class.getMethod("marshallContentManagerQueryOptionString", Option.class, Element.class));
            m_marshallers.put("ContentManagerQueryOptionPropEnumArray", OptionMarshaller.class.getMethod("marshallContentManagerQueryOptionPropEnumArray", Option.class, Element.class));
            m_marshallers.put("ContentManagerQueryOptionRefPropArray", OptionMarshaller.class.getMethod("marshallContentManagerQueryOptionRefPropArray", Option.class, Element.class));
            m_marshallers.put("ElementOption", OptionMarshaller.class.getMethod("marshallElementOption", Option.class, Element.class));
            m_marshallers.put("GenericOptionXMLEncodedXMLAsAttachment", OptionMarshaller.class.getMethod("marshallGenericOptionXMLEncodedXMLAsAttachment", Option.class, Element.class));
            m_unmarshallers.put("AsynchOptionBoolean", OptionMarshaller.class.getMethod("unmarshallAsynchOptionBoolean", Element.class));
            m_unmarshallers.put("AsynchOptionInt", OptionMarshaller.class.getMethod("unmarshallAsynchOptionInt", Element.class));
            m_unmarshallers.put("AsynchOptionEncoding", OptionMarshaller.class.getMethod("unmarshallAsynchOptionEncoding", Element.class));
            m_unmarshallers.put("RunOptionBoolean", OptionMarshaller.class.getMethod("unmarshallRunOptionBoolean", Element.class));
            m_unmarshallers.put("RunOptionAnyURI", OptionMarshaller.class.getMethod("unmarshallRunOptionAnyURI", Element.class));
            m_unmarshallers.put("RunOptionData", OptionMarshaller.class.getMethod("unmarshallRunOptionData", Element.class));
            m_unmarshallers.put("RunOptionInt", OptionMarshaller.class.getMethod("unmarshallRunOptionInt", Element.class));
            m_unmarshallers.put("RunOptionString", OptionMarshaller.class.getMethod("unmarshallRunOptionString", Element.class));
            m_unmarshallers.put("RunOptionStringArray", OptionMarshaller.class.getMethod("unmarshallRunOptionStringArray", Element.class));
            m_unmarshallers.put("RunOptionSaveAs", OptionMarshaller.class.getMethod("unmarshallRunOptionSaveAs", Element.class));
            m_unmarshallers.put("DrillOptionParameterValues", OptionMarshaller.class.getMethod("unmarshallDrillOptionParameterValues", Element.class));
            m_unmarshallers.put("RunOptionNameValueArray", OptionMarshaller.class.getMethod("unmarshallRunOptionNameValueArray", Element.class));
            m_unmarshallers.put("RunOptionLanguageArray", OptionMarshaller.class.getMethod("unmarshallRunOptionLanguageArray", Element.class));
            m_unmarshallers.put("RunOptionOutputEncapsulation", OptionMarshaller.class.getMethod("unmarshallRunOptionOutputEncapsulation", Element.class));
            m_unmarshallers.put("ContextOptionType", OptionMarshaller.class.getMethod("unmarshallContextOptionType", Element.class));
            m_unmarshallers.put("ContextOptionFormat", OptionMarshaller.class.getMethod("unmarshallContextOptionFormat", Element.class));
            m_unmarshallers.put("ContextOptionStringArray", OptionMarshaller.class.getMethod("unmarshallContextOptionStringArray", Element.class));
            m_unmarshallers.put("DrillThroughOptionXMLEncodedXML", OptionMarshaller.class.getMethod("unmarshallDrillThroughOptionXMLEncodedXML", Element.class));
            m_unmarshallers.put("SpecificationOptionXMLEncodedXML", OptionMarshaller.class.getMethod("unmarshallSpecificationOptionXMLEncodedXML", Element.class));
            m_unmarshallers.put("DrillThroughOptionBoolean", OptionMarshaller.class.getMethod("unmarshallDrillThroughOptionBoolean", Element.class));
            m_unmarshallers.put("ReportServiceQueryOptionBoolean", OptionMarshaller.class.getMethod("unmarshallReportServiceQueryOptionBoolean", Element.class));
            m_unmarshallers.put("ReportServiceQueryOptionSpecificationFormat", OptionMarshaller.class.getMethod("unmarshallReportServiceQueryOptionSpecificationFormat", Element.class));
            m_unmarshallers.put("PowerPlay8OptionAnyURI", OptionMarshaller.class.getMethod("unmarshallPowerPlay8OptionAnyURI", Element.class));
            m_unmarshallers.put("GenericOptionBoolean", OptionMarshaller.class.getMethod("unmarshallGenericOptionBoolean", Element.class));
            m_unmarshallers.put("GenericOptionXMLEncodedXML", OptionMarshaller.class.getMethod("unmarshallGenericOptionXMLEncodedXML", Element.class));
            m_unmarshallers.put("GenericOptionAnyURI", OptionMarshaller.class.getMethod("unmarshallGenericOptionAnyURI", Element.class));
            m_unmarshallers.put("ContentManagerQueryOptionBoolean", OptionMarshaller.class.getMethod("unmarshallContentManagerQueryOptionBoolean", Element.class));
            m_unmarshallers.put("ContentManagerQueryOptionInt", OptionMarshaller.class.getMethod("unmarshallContentManagerQueryOptionInt", Element.class));
            m_unmarshallers.put("ContentManagerQueryOptionString", OptionMarshaller.class.getMethod("unmarshallContentManagerQueryOptionString", Element.class));
            m_unmarshallers.put("ContentManagerQueryOptionPropEnumArray", OptionMarshaller.class.getMethod("unmarshallContentManagerQueryOptionPropEnumArray", Element.class));
            m_unmarshallers.put("ContentManagerQueryOptionRefPropArray", OptionMarshaller.class.getMethod("unmarshallContentManagerQueryOptionRefPropArray", Element.class));
            m_unmarshallers.put("ElementOption", OptionMarshaller.class.getMethod("unmarshallElementOption", Element.class));
        }
        catch (NoSuchMethodException exception) {
            IPFLogger.getInstance().error("Caught NoSuchMethodException in OptionMarshaller initialization: " + exception.getMessage(), exception, OptionMarshaller.class.getName());
        }
        BUS_OPTIONS = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "options";
        BUS_ASYNCH_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchOptionEnum";
        BUS_ASYNCH_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchOptionBoolean";
        BUS_ASYNCH_OPTION_INT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchOptionInt";
        BUS_ASYNCH_OPTION_ENCODING = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "asynchOptionEncoding";
        BUS_RUN_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionEnum";
        BUS_REPORT_SAVE_AS_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "reportSaveAsEnum";
        BUS_RUN_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionBoolean";
        BUS_RUN_OPTION_INT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionInt";
        BUS_RUN_OPTION_STRING = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionString";
        BUS_RUN_OPTION_ANY_URI = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionAnyURI";
        BUS_RUN_OPTION_STRING_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionStringArray";
        BUS_RUN_OPTION_LANGUAGE_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionLanguageArray";
        BUS_RUN_OPTION_DATA = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionData";
        BUS_RUN_OPTION_OUTPUT_ENCAPSULATION = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionOutputEncapsulation";
        BUS_RUN_OPTION_NAME_VALUE_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionNameValueArray";
        BUS_RUN_OPTION_SAVE_AS = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "runOptionSaveAs";
        BUS_OBJECT_CLASS = DocumentHelper.createQName((String)"objectClass", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_OBJECT_NAME = DocumentHelper.createQName((String)"objectName", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_PARENT_SEARCH_PATH = DocumentHelper.createQName((String)"parentSearchPath", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_MULTILINGUAL_TOKEN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "multilingualToken";
        BUS_LOCALE = DocumentHelper.createQName((String)"locale", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_DRILL_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "drillOptionEnum";
        BUS_DRILL_OPTION_PARAMETER_VALUES = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "drillOptionParameterValues";
        BUS_DRILL_THROUGH_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "drillThroughOptionEnum";
        BUS_SPECIFICATION_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "specificationOptionEnum";
        BUS_DRILL_THROUGH_OPTION_XML_ENCODED_XML = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "drillThroughOptionXMLEncodedXML";
        BUS_SPECIFICATION_OPTION_XML_ENCODED_XML = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "specificationOptionXMLEncodedXML";
        BUS_DRILL_THROUGH_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "drillThroughOptionBoolean";
        BUS_XML_ENCODED_XML = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "xmlEncodedXML";
        BUS_CONTEXT_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextOptionEnum";
        BUS_CONTEXT_OPTION_FORMAT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextOptionFormat";
        BUS_CONTEXT_OPTION_TYPE = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextOptionType";
        BUS_CONTEXT_OPTION_SELECTION = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextOptionSelection";
        BUS_CONTEXT_FORMAT_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextFormatEnum";
        BUS_CONTEXT_TYPE_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextTypeEnum";
        BUS_CONTEXT_OPTION_STRING_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contextOptionStringArray";
        BUS_GENERIC_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "genericOptionBoolean";
        BUS_GENERIC_OPTION_XML_ENCODED_STRING = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "genericOptionXMLEncodedXML";
        BUS_GENERIC_OPTION_ANY_URI = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "genericOptionAnyURI";
        BUS_GENERIC_OPTION_XML_ENCODED_XML = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "xmlEncodedXML";
        BUS_CONTENT_MANAGER_CACHE_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerCacheOptionEnum";
        BUS_CONTENT_MANAGER_QUERY_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionEnum";
        BUS_CONTENT_MANAGER_QUERY_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionBoolean";
        BUS_CONTENT_MANAGER_QUERY_OPTION_INT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionInt";
        BUS_CONTENT_MANAGER_QUERY_OPTION_STRING = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionString";
        BUS_CONTENT_MANAGER_QUERY_OPTION_REF_PROP_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionRefPropArray";
        BUS_CONTENT_MANAGER_QUERY_OPTION_PROP_ENUM_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "contentManagerQueryOptionPropEnumArray";
        BUS_REPORT_SERVICE_QUERY_OPTION_BOOLEAN = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "reportServiceQueryOptionBoolean";
        BUS_REPORT_SERVICE_QUERY_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "reportServiceQueryOptionEnum";
        BUS_REPORT_SERVICE_QUERY_OPTION_SPECIFICATION_FORMTAT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "reportServiceQueryOptionSpecificationFormat";
        BUS_SPECIFICATION_FORMTAT_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "specificationFormatEnum";
        BUS_POWERPLAY8_OPTION_ANY_URI = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "powerPlay8OptionAnyURI";
        BUS_POWERPLAY8_OPTION_ENUM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "powerPlay8OptionEnum";
    }

    public class ElementOption
    extends GenericOption {
        public static final long serialVersionUID = 1538200607134L;
        private Element _node = null;

        public void setValue(Element node) {
            this._node = node.createCopy();
            this._node.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        }

        public Element getValue() {
            return this._node;
        }
    }
}

