/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ParameterValueMarshaller
implements IArgumentMarshaller {
    private static HashMap m_marshallers = new HashMap();
    public static final String BUS_PARAMETER_VALUE;
    public static final QName BUS_PARAMETER_VALUES;
    public static final QName BUS_PARAMETER_VALUES_ARRAY;
    public static final String BUS_PARM_VALUE_ITEM_ARRAY;
    public static final String BUS_SIMPLE_PARM_VALUE_ITEM;
    public static final String BUS_BOUND_RANGE_PARM_VALUE_ITEM;
    public static final String BUS_UNBOUNDED_END_RANGE_PARM_VALUE_ITEM;
    public static final String BUS_UNBOUNDED_START_RANGE_PARM_VALUE_ITEM;
    public static final String BUS_HIERARCHIAL_PARM_VALUE_ITEM;
    public static final String BUS_START;
    public static final String BUS_END;
    public static final String BUS_SUB_NODES;
    private ParameterValue m_parameterValue = null;

    public ParameterValueMarshaller(ParameterValue parameterValue) {
        this.m_parameterValue = parameterValue;
    }

    private ParameterValue getParameterValue() {
        return this.m_parameterValue;
    }

    public ParameterValue unmarshall(Element parameterValueNode) throws CognosViewerException {
        try {
            Element value;
            ParameterValue parameterValue = new ParameterValue();
            Element name = parameterValueNode.element("name");
            if (name != null) {
                parameterValue.setName(name.getText());
            }
            if ((value = parameterValueNode.element("value")) != null) {
                parameterValue.setValue(this.unmarshallParmValueItems(value));
            }
            return parameterValue;
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
    }

    @Override
    public void marshall(Element parameterValuesNode) throws CognosViewerException {
        try {
            ParameterValue parameterValue = this.getParameterValue();
            Element parameterValueNode = parameterValuesNode.addElement("item");
            parameterValueNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PARAMETER_VALUE);
            if (parameterValue.getName() != null) {
                Element busName = parameterValueNode.addElement(BUS_NAME);
                busName.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                busName.setText(parameterValue.getName());
            }
            Element busValue = parameterValueNode.addElement(BUS_VALUE);
            busValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            busValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_PARM_VALUE_ITEM_ARRAY);
            ParmValueItem[] parmValueItems = parameterValue.getValue();
            for (int iParmValueItemIdx = 0; iParmValueItemIdx < parmValueItems.length; ++iParmValueItemIdx) {
                ParmValueItem parmValueItem = parmValueItems[iParmValueItemIdx];
                String sParmValueItemType = parmValueItem.getClass().getName();
                int iStartIndex = sParmValueItemType.indexOf("com.cognos.developer.schemas.bibus._3.", 0) + "com.cognos.developer.schemas.bibus._3.".length();
                sParmValueItemType = sParmValueItemType.substring(iStartIndex, sParmValueItemType.length());
                Method marshallerMethod = (Method)m_marshallers.get(sParmValueItemType);
                marshallerMethod.invoke((Object)this, parmValueItem, busValue);
            }
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
    }

    public void marshallSimpleParmValueItem(ParmValueItem parmValueItem, Element parentNode) throws ClassCastException {
        SimpleParmValueItem simpleParmValueItem = (SimpleParmValueItem)parmValueItem;
        Element simpleParmValueItemNode = parentNode.addElement("item");
        simpleParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(simpleParmValueItem, simpleParmValueItemNode);
    }

    public void marshallPromptItemValue(SimpleParmValueItem simpleParmValueItem, Element simpleParmValueItemNode) {
        if (simpleParmValueItem != null) {
            Element busInclusive = simpleParmValueItemNode.addElement(BUS_INCLUSIVE);
            busInclusive.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
            busInclusive.setText(this.getInclusiveString(simpleParmValueItem.isInclusive()));
            Element busDisplay = simpleParmValueItemNode.addElement(BUS_DISPLAY);
            if (simpleParmValueItem.getDisplay() != null) {
                busDisplay.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                busDisplay.setText(simpleParmValueItem.getDisplay());
            } else {
                busDisplay.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            }
            Element busUse = simpleParmValueItemNode.addElement(BUS_USE);
            if (simpleParmValueItem.getUse() != null) {
                busUse.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                busUse.setText(simpleParmValueItem.getUse());
            } else {
                busUse.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            }
        } else {
            simpleParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, "");
            simpleParmValueItemNode.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    private ParmValueItem[] unmarshallParmValueItems(Element value) throws Exception {
        List parmValueItemsList = value.elements();
        int iNumberOfParmValueItems = parmValueItemsList.size();
        ParmValueItem[] parmValueItems = new ParmValueItem[iNumberOfParmValueItems];
        for (int iParmValueIndex = 0; iParmValueIndex < iNumberOfParmValueItems; ++iParmValueIndex) {
            Element parmValueItemNode = (Element)parmValueItemsList.get(iParmValueIndex);
            String xsiType = parmValueItemNode.attributeValue(SOAPEnvelope.XSI_TYPE);
            if (xsiType == null || xsiType.length() <= 0) continue;
            QName parmValueType = QName.get((String)xsiType, (String)"http://developer.cognos.com/schemas/bibus/3/");
            String sClassName = parmValueType.getName();
            String sFirstChar = sClassName.substring(0, 1);
            String sUpperCaseChar = sFirstChar.toUpperCase();
            sClassName = sClassName.replaceFirst(sFirstChar, sUpperCaseChar);
            String sMethodName = "unmarshall" + sClassName;
            Method unmarshallerMethod = this.getClass().getMethod(sMethodName, Element.class);
            parmValueItems[iParmValueIndex] = (ParmValueItem)unmarshallerMethod.invoke((Object)this, parmValueItemNode);
        }
        return parmValueItems;
    }

    private void unmarshallInclusiveValue(ParmValueItem paramValueItem, Element parmValueItemNode) {
        String sXsiNilPropertyValue;
        boolean isNil;
        boolean bInclusiveValue = true;
        Element busInclusive = parmValueItemNode.element("inclusive");
        if (busInclusive != null && !(isNil = "true".equals(sXsiNilPropertyValue = busInclusive.attributeValue("xsi:nil"))) && busInclusive.getText().length() > 0) {
            bInclusiveValue = Boolean.valueOf(busInclusive.getText());
        }
        paramValueItem.setInclusive(bInclusiveValue);
    }

    public ParmValueItem unmarshallSimpleParmValueItem(Element parmValueItemNode) {
        Element busUse;
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        this.unmarshallInclusiveValue((ParmValueItem)simpleParmValueItem, parmValueItemNode);
        Element busDisplay = parmValueItemNode.element("display");
        if (busDisplay != null) {
            simpleParmValueItem.setDisplay(busDisplay.getText());
        }
        if ((busUse = parmValueItemNode.element("use")) != null) {
            simpleParmValueItem.setUse(busUse.getText());
        }
        return simpleParmValueItem;
    }

    public void marshallBoundRangeParmValueItem(ParmValueItem parmValueItem, Element parentNode) throws ClassCastException {
        BoundRangeParmValueItem boundRangeParmValueItem = (BoundRangeParmValueItem)parmValueItem;
        Element boundRangeParmValueItemNode = parentNode.addElement("item");
        boundRangeParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_BOUND_RANGE_PARM_VALUE_ITEM);
        Element busInclusive = boundRangeParmValueItemNode.addElement(BUS_INCLUSIVE);
        busInclusive.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
        busInclusive.setText(this.getInclusiveString(boundRangeParmValueItem.isInclusive()));
        Element busStartNode = boundRangeParmValueItemNode.addElement(BUS_START);
        busStartNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(boundRangeParmValueItem.getStart(), busStartNode);
        Element busEndNode = boundRangeParmValueItemNode.addElement(BUS_END);
        busEndNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(boundRangeParmValueItem.getEnd(), busEndNode);
    }

    public void marshallUnboundedEndRangeParmValueItem(ParmValueItem parmValueItem, Element parentNode) throws ClassCastException {
        UnboundedEndRangeParmValueItem unboundedEndRangeParmValueItem = (UnboundedEndRangeParmValueItem)parmValueItem;
        Element unboundedEndRangeParmValueItemNode = parentNode.addElement("item");
        unboundedEndRangeParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_UNBOUNDED_END_RANGE_PARM_VALUE_ITEM);
        Element busInclusive = unboundedEndRangeParmValueItemNode.addElement(BUS_INCLUSIVE);
        busInclusive.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
        busInclusive.setText(this.getInclusiveString(unboundedEndRangeParmValueItem.isInclusive()));
        Element busStartNode = unboundedEndRangeParmValueItemNode.addElement(BUS_START);
        busStartNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(unboundedEndRangeParmValueItem.getStart(), busStartNode);
    }

    public void marshallUnboundedStartRangeParmValueItem(ParmValueItem parmValueItem, Element parentNode) throws ClassCastException {
        UnboundedStartRangeParmValueItem unboundedStartRangeParmValueItem = (UnboundedStartRangeParmValueItem)parmValueItem;
        Element unboundedStartRangeParmValueItemNode = parentNode.addElement("item");
        unboundedStartRangeParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_UNBOUNDED_START_RANGE_PARM_VALUE_ITEM);
        Element busInclusive = unboundedStartRangeParmValueItemNode.addElement(BUS_INCLUSIVE);
        busInclusive.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
        busInclusive.setText(this.getInclusiveString(unboundedStartRangeParmValueItem.isInclusive()));
        Element busEndNode = unboundedStartRangeParmValueItemNode.addElement(BUS_END);
        busEndNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(unboundedStartRangeParmValueItem.getEnd(), busEndNode);
    }

    public void marshallHierarchicalParmValueItem(ParmValueItem parmValueItem, Element parentNode) throws ClassCastException {
        HierarchicalParmValueItem hierarchialParmValueItem = (HierarchicalParmValueItem)parmValueItem;
        Element hierarchialParmValueItemNode = parentNode.addElement("item");
        hierarchialParmValueItemNode.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_HIERARCHIAL_PARM_VALUE_ITEM);
        Element busInclusive = hierarchialParmValueItemNode.addElement(BUS_INCLUSIVE);
        busInclusive.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
        busInclusive.setText(this.getInclusiveString(hierarchialParmValueItem.isInclusive()));
        Element busValue = hierarchialParmValueItemNode.addElement(BUS_VALUE);
        busValue.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SIMPLE_PARM_VALUE_ITEM);
        this.marshallPromptItemValue(hierarchialParmValueItem.getValue(), busValue);
        HierarchicalParmValueItem[] subNodes = hierarchialParmValueItem.getSubNodes();
        Element busSubNodes = hierarchialParmValueItemNode.addElement(BUS_SUB_NODES);
        if (subNodes != null && subNodes.length > 0) {
            busSubNodes.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            busSubNodes.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_HIERARCHIAL_PARM_VALUE_ITEM + "[]");
            for (int iIndex = 0; iIndex < subNodes.length; ++iIndex) {
                this.marshallHierarchicalParmValueItem((ParmValueItem)subNodes[iIndex], busSubNodes);
            }
        } else {
            busSubNodes.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    public ParmValueItem unmarshallBoundRangeParmValueItem(Element parmValueItemNode) {
        Element busEndRange;
        BoundRangeParmValueItem boundRangeParmValueItem = new BoundRangeParmValueItem();
        this.unmarshallInclusiveValue((ParmValueItem)boundRangeParmValueItem, parmValueItemNode);
        Element busStartRange = parmValueItemNode.element("start");
        if (busStartRange != null) {
            boundRangeParmValueItem.setStart((SimpleParmValueItem)this.unmarshallSimpleParmValueItem(busStartRange));
        }
        if ((busEndRange = parmValueItemNode.element("end")) != null) {
            boundRangeParmValueItem.setEnd((SimpleParmValueItem)this.unmarshallSimpleParmValueItem(busEndRange));
        }
        return boundRangeParmValueItem;
    }

    public ParmValueItem unmarshallUnboundedEndRangeParmValueItem(Element parmValueItemNode) {
        UnboundedEndRangeParmValueItem unboundEndRangeParmValueItem = new UnboundedEndRangeParmValueItem();
        this.unmarshallInclusiveValue((ParmValueItem)unboundEndRangeParmValueItem, parmValueItemNode);
        Element busStartRange = parmValueItemNode.element("start");
        if (busStartRange != null) {
            unboundEndRangeParmValueItem.setStart((SimpleParmValueItem)this.unmarshallSimpleParmValueItem(busStartRange));
        }
        return unboundEndRangeParmValueItem;
    }

    public ParmValueItem unmarshallUnboundedStartRangeParmValueItem(Element parmValueItemNode) {
        UnboundedStartRangeParmValueItem unboundedStartRangeParmValueItem = new UnboundedStartRangeParmValueItem();
        this.unmarshallInclusiveValue((ParmValueItem)unboundedStartRangeParmValueItem, parmValueItemNode);
        Element busEndRange = parmValueItemNode.element("end");
        if (busEndRange != null) {
            unboundedStartRangeParmValueItem.setEnd((SimpleParmValueItem)this.unmarshallSimpleParmValueItem(busEndRange));
        }
        return unboundedStartRangeParmValueItem;
    }

    public ParmValueItem unmarshallHierarchicalParmValueItem(Element parmValueItemNode) {
        Attribute xsiNil;
        Element subNodes;
        HierarchicalParmValueItem hierarchicalParmValueItem = new HierarchicalParmValueItem();
        this.unmarshallInclusiveValue((ParmValueItem)hierarchicalParmValueItem, parmValueItemNode);
        Element busValue = parmValueItemNode.element("value");
        if (busValue != null) {
            hierarchicalParmValueItem.setValue((SimpleParmValueItem)this.unmarshallSimpleParmValueItem(busValue));
        }
        if ((subNodes = parmValueItemNode.element("subNodes")) != null && ((xsiNil = subNodes.attribute(SOAPEnvelope.XSI_TYPE)) == null || xsiNil.getValue().compareTo("true") != 0)) {
            List subNodesList = subNodes.elements();
            int iListSize = subNodesList.size();
            HierarchicalParmValueItem[] hierarchicalParmValueItems = new HierarchicalParmValueItem[iListSize];
            for (int iIndex = 0; iIndex < iListSize; ++iIndex) {
                hierarchicalParmValueItems[iIndex] = (HierarchicalParmValueItem)this.unmarshallHierarchicalParmValueItem((Element)subNodesList.get(iIndex));
            }
            hierarchicalParmValueItem.setSubNodes(hierarchicalParmValueItems);
        }
        return hierarchicalParmValueItem;
    }

    private String getInclusiveString(Boolean bInclusive) {
        if (bInclusive == null) {
            return "false";
        }
        return bInclusive.toString();
    }

    static {
        try {
            m_marshallers.put("BoundRangeParmValueItem", ParameterValueMarshaller.class.getMethod("marshallBoundRangeParmValueItem", ParmValueItem.class, Element.class));
            m_marshallers.put("HierarchicalParmValueItem", ParameterValueMarshaller.class.getMethod("marshallHierarchicalParmValueItem", ParmValueItem.class, Element.class));
            m_marshallers.put("SimpleParmValueItem", ParameterValueMarshaller.class.getMethod("marshallSimpleParmValueItem", ParmValueItem.class, Element.class));
            m_marshallers.put("UnboundedEndRangeParmValueItem", ParameterValueMarshaller.class.getMethod("marshallUnboundedEndRangeParmValueItem", ParmValueItem.class, Element.class));
            m_marshallers.put("UnboundedStartRangeParmValueItem", ParameterValueMarshaller.class.getMethod("marshallUnboundedStartRangeParmValueItem", ParmValueItem.class, Element.class));
        }
        catch (NoSuchMethodException exception) {
            exception.getMessage();
        }
        BUS_PARAMETER_VALUE = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "parameterValue";
        BUS_PARAMETER_VALUES = DocumentHelper.createQName((String)"parameterValue", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_PARAMETER_VALUES_ARRAY = DocumentHelper.createQName((String)"parameterValues", (Namespace)BIBusEnvelope.NS_BUS);
        BUS_PARM_VALUE_ITEM_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "parmValueItem[]";
        BUS_SIMPLE_PARM_VALUE_ITEM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "simpleParmValueItem";
        BUS_BOUND_RANGE_PARM_VALUE_ITEM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "boundRangeParmValueItem";
        BUS_UNBOUNDED_END_RANGE_PARM_VALUE_ITEM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "unboundedEndRangeParmValueItem";
        BUS_UNBOUNDED_START_RANGE_PARM_VALUE_ITEM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "unboundedStartRangeParmValueItem";
        BUS_HIERARCHIAL_PARM_VALUE_ITEM = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "hierarchicalParmValueItem";
        BUS_START = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "start";
        BUS_END = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "end";
        BUS_SUB_NODES = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "subNodes";
    }
}

