/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValueMarshaller;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.QName;

public class ParameterValuesMarshaller
implements IArgumentMarshaller {
    private ParameterValue[] m_parameterValues = null;
    private QName m_qName = null;

    public ParameterValuesMarshaller(ParameterValue[] parameterValues) {
        this.m_parameterValues = parameterValues;
    }

    public ParameterValuesMarshaller(ParameterValue[] parameterValues, QName qName) {
        this.m_parameterValues = parameterValues;
        this.m_qName = qName;
    }

    private ParameterValue[] getParameterValues() {
        return this.m_parameterValues;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element parameterValuesNode = this.m_qName != null ? parentNode.addElement(this.m_qName) : parentNode.addElement("parameterValues");
        parameterValuesNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        parameterValuesNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:parameterValue[]");
        try {
            ParameterValue[] parameterValues = this.getParameterValues();
            for (int iIndex = 0; iIndex < parameterValues.length; ++iIndex) {
                ParameterValue parameterValue = parameterValues[iIndex];
                ParameterValueMarshaller parameterValueMarshaller = new ParameterValueMarshaller(parameterValue);
                parameterValueMarshaller.marshall(parameterValuesNode);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public ParameterValue[] unmarshall(Element parameterValuesNode) throws CognosViewerException {
        try {
            List parameterValuesList = parameterValuesNode.elements();
            int iNumberOfParameterValues = parameterValuesList.size();
            ParameterValue[] parameterValues = new ParameterValue[iNumberOfParameterValues];
            ParameterValueMarshaller parameterValueMarshaller = new ParameterValueMarshaller(null);
            for (int iParameterValueIndex = 0; iParameterValueIndex < iNumberOfParameterValues; ++iParameterValueIndex) {
                Element parameterValueNode = (Element)parameterValuesList.get(iParameterValueIndex);
                parameterValues[iParameterValueIndex] = parameterValueMarshaller.unmarshall(parameterValueNode);
            }
            return parameterValues;
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

