/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValueMarshaller;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ParametersMarshaller
implements IArgumentMarshaller {
    public static final QName BUS_PARAMETER_ARRAY = DocumentHelper.createQName((String)"parameters", (Namespace)BIBusEnvelope.NS_BUS);
    private ParameterValue[] m_parameterValues = null;

    public ParametersMarshaller(ParameterValue[] parameterValues) {
        this.m_parameterValues = parameterValues;
    }

    private ParameterValue[] getParameterValues() {
        return this.m_parameterValues;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element parameterValuesNode = parentNode.addElement(BUS_PARAMETER_ARRAY);
        parameterValuesNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        parameterValuesNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:parameterValue[]");
        try {
            ParameterValue[] parameterValues = this.getParameterValues();
            if (parameterValues != null) {
                for (int iIndex = 0; iIndex < parameterValues.length; ++iIndex) {
                    ParameterValue parameterValue = parameterValues[iIndex];
                    ParameterValueMarshaller parameterValueMarshaller = new ParameterValueMarshaller(parameterValue);
                    parameterValueMarshaller.marshall(parameterValuesNode);
                }
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }

    public ParameterValue[] unmarshall(Element parametersNode) throws CognosViewerException {
        try {
            List parameterValuesList = parametersNode.elements();
            int iNumberOfParameterValues = parameterValuesList.size();
            ParameterValue[] parameterValues = new ParameterValue[iNumberOfParameterValues];
            ParameterValueMarshaller parameterValueMarshaller = new ParameterValueMarshaller(null);
            for (int iParameterValueIndex = 0; iParameterValueIndex < iNumberOfParameterValues; ++iParameterValueIndex) {
                Element parameterValueNode = (Element)parameterValuesList.get(iParameterValueIndex);
                parameterValues[iParameterValueIndex] = parameterValueMarshaller.unmarshall(parameterValueNode);
            }
            return parameterValues;
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }
}

