/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class PropEnumMarshaller
implements IArgumentMarshaller {
    private PropEnum[] m_properties = null;

    public PropEnumMarshaller() {
    }

    public PropEnumMarshaller(PropEnum[] properties) {
        this.m_properties = properties;
    }

    private PropEnum[] getPropEnums() {
        return this.m_properties;
    }

    @Override
    public void marshall(Element parentElement) throws CognosViewerException {
        this.marshall(parentElement, DocumentHelper.createQName((String)"properties", null));
    }

    public void marshall(Element parentElement, QName nodeName) throws CognosViewerException {
        Element propertiesNode = parentElement.addElement(nodeName);
        propertiesNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        propertiesNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[]");
        try {
            PropEnum[] properties = this.getPropEnums();
            for (int iIndex = 0; iIndex < properties.length; ++iIndex) {
                if (properties[iIndex] == null) continue;
                Element propertyItem = propertiesNode.addElement("item");
                propertyItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
                propertyItem.setText(properties[iIndex].getValue());
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }

    public PropEnum[] unmarshall(Element propertiesNode) {
        List propertiesList = propertiesNode.elements();
        int listSize = propertiesList.size();
        PropEnum[] propEnums = new PropEnum[listSize];
        for (int index = 0; index < listSize; ++index) {
            PropEnum propEnum;
            Element item = (Element)propertiesList.get(index);
            propEnums[index] = propEnum = PropEnum.fromString((String)item.getText());
        }
        return propEnums;
    }
}

