/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.RefPropMarshaller;
import org.dom4j.Element;

public class QueryOptionsMarshaller
implements IArgumentMarshaller {
    private QueryOptions m_queryOptions = null;

    public QueryOptionsMarshaller(QueryOptions queryOptions) {
        this.m_queryOptions = queryOptions;
    }

    private QueryOptions getQueryOptions() {
        return this.m_queryOptions;
    }

    @Override
    public void marshall(Element parentElement) throws CognosViewerException {
        Element queryOptionsNode = parentElement.addElement("options");
        queryOptionsNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":queryOptions");
        try {
            QueryOptions queryOptions = this.getQueryOptions();
            if (queryOptions.getDataEncoding() != null) {
                Element dataEncoding = queryOptionsNode.addElement("dataEncoding");
                dataEncoding.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":encodingEnum");
                dataEncoding.addText(queryOptions.getDataEncoding().getValue());
            }
            if (queryOptions.getMaxDataBytes() != null) {
                Element maxDataBytes = queryOptionsNode.addElement("maxDataBytes");
                maxDataBytes.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INTEGER);
                maxDataBytes.addText(queryOptions.getMaxDataBytes().toString());
            }
            if (queryOptions.getMaxObjects() != null) {
                Element maxObjects = queryOptionsNode.addElement("maxObjects");
                maxObjects.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INTEGER);
                maxObjects.addText(queryOptions.getMaxObjects().toString());
            }
            if (queryOptions.getPermission() != null) {
                Element permissionsNode = queryOptionsNode.addElement("permission");
                permissionsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                permissionsNode.addText(queryOptions.getPermission());
            }
            if (queryOptions.getRefProps() != null) {
                RefPropMarshaller refPropMarshaller = new RefPropMarshaller(queryOptions.getRefProps());
                refPropMarshaller.marshall(queryOptionsNode);
            }
            if (queryOptions.isSchemaInfo()) {
                Element schemaInfo = queryOptionsNode.addElement("schemaInfo");
                schemaInfo.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
                schemaInfo.addText("true");
            }
            if (queryOptions.getSkipDataBytes() != null) {
                Element skipDataBytes = queryOptionsNode.addElement("skipDataBytes");
                skipDataBytes.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INTEGER);
                skipDataBytes.addText(queryOptions.getSkipDataBytes().toString());
            }
            if (queryOptions.getSkipObjects() != null) {
                Element skipObjects = queryOptionsNode.addElement("skipObjects");
                skipObjects.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INTEGER);
                skipObjects.addText(queryOptions.getSkipObjects().toString());
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

