/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.QueryOptionsMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.model.marshallers.SortMarshaller;
import org.dom4j.Element;

public class QueryRequestMarshaller
implements IArgumentMarshaller {
    private QueryRequest[] m_queryRequests = null;

    public QueryRequestMarshaller(QueryRequest[] queryRequests) {
        this.m_queryRequests = queryRequests;
    }

    private QueryRequest[] getQueryRequests() {
        return this.m_queryRequests;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element requestsNode = parentNode.addElement("requests");
        requestsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        requestsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:queryRequest[]");
        try {
            QueryRequest[] queryRequests = this.getQueryRequests();
            for (int iIndex = 0; iIndex < queryRequests.length; ++iIndex) {
                Element itemNode = requestsNode.addElement("item");
                itemNode.addAttribute(SOAPEnvelope.XSI_TYPE, "bus:queryRequest");
                QueryRequest currentRequest = queryRequests[iIndex];
                Element searchNode = itemNode.addElement("search");
                searchNode.addAttribute(SOAPEnvelope.XSI_TYPE, SearchPathMultipleObjectMarshaller.BUS_SEARCH_PATH_MULTIPLE_OBJECT_TYPE);
                searchNode.setText(currentRequest.getSearch());
                PropEnumMarshaller propEnumMarshaller = new PropEnumMarshaller(currentRequest.getProperties());
                propEnumMarshaller.marshall(itemNode);
                if (currentRequest.getSortBy() != null) {
                    SortMarshaller sortMarshaller = new SortMarshaller(currentRequest.getSortBy());
                    sortMarshaller.marshall(itemNode);
                }
                if (currentRequest.getOptions() == null) continue;
                QueryOptionsMarshaller queryOptionsMarshaller = new QueryOptionsMarshaller(currentRequest.getOptions());
                queryOptionsMarshaller.marshall(itemNode);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

