/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class RefPropMarshaller
implements IArgumentMarshaller {
    private RefProp[] m_refProps = null;

    public RefPropMarshaller() {
    }

    public RefPropMarshaller(RefProp[] refProps) {
        this.m_refProps = refProps;
    }

    private RefProp[] getRefProps() {
        return this.m_refProps;
    }

    @Override
    public void marshall(Element parentElement) throws CognosViewerException {
        this.marshall(parentElement, DocumentHelper.createQName((String)"refProps", null));
    }

    public void marshall(Element parentElement, QName nodeName) throws CognosViewerException {
        Element refPropsNode = parentElement.addElement(nodeName);
        refPropsNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        refPropsNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":refProp[]");
        try {
            RefProp[] refProps = this.getRefProps();
            for (int iIndex = 0; iIndex < refProps.length; ++iIndex) {
                Element itemArray = refPropsNode.addElement("item");
                itemArray.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":refProp");
                Element refPropName = itemArray.addElement("refPropName");
                refPropName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
                refPropName.addText(refProps[iIndex].getRefPropName().getValue());
                PropEnumMarshaller propertiesMarshaller = new PropEnumMarshaller(refProps[iIndex].getProperties());
                propertiesMarshaller.marshall(itemArray);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    public RefProp[] unmarshall(Element refPropArrayNode) {
        List refPropList = refPropArrayNode.elements();
        int listSize = refPropList.size();
        RefProp[] refProps = new RefProp[listSize];
        for (int index = 0; index < listSize; ++index) {
            RefProp refProp = new RefProp();
            Element refPropItem = (Element)refPropList.get(index);
            Element refPropNameItem = refPropItem.element("refPropName");
            refProp.setRefPropName(PropEnum.fromString((String)refPropNameItem.getText()));
            Element propertiesItem = refPropItem.element("properties");
            PropEnumMarshaller propEnumMarshaller = new PropEnumMarshaller();
            PropEnum[] propEnum = propEnumMarshaller.unmarshall(propertiesItem);
            refProp.setProperties(propEnum);
            refProps[index] = refProp;
        }
        return refProps;
    }
}

