/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValueArrayPropMarshaller;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ReportMarshaller
implements IArgumentMarshaller {
    private Report m_report = null;
    private QName m_rootElement = ROOT_ELEMENT_ITEM;
    public static final QName ROOT_ELEMENT_ITEM = DocumentHelper.createQName((String)"item");
    public static final QName ROOT_ELEMENT_OBJECT = DocumentHelper.createQName((String)"object");

    public ReportMarshaller(Report report) {
        this.m_report = report;
    }

    public ReportMarshaller(Report report, QName rootElement) {
        this.m_report = report;
        this.m_rootElement = rootElement;
    }

    private Report getReport() {
        return this.m_report;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element reportNode = parentNode.addElement(this.m_rootElement);
        reportNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":report");
        try {
            if (this.getReport().getSearchPath() != null) {
                this.marshallReportProperty(reportNode, "searchPath", this.getReport().getSearchPath().getValue(), ":stringProp");
            }
            if (this.getReport().getSpecification() != null) {
                this.marshallReportProperty(reportNode, "specification", this.getReport().getSpecification().getValue(), ":anyTypeProp");
            }
            if (this.getReport().getParameters() != null) {
                ParameterValueArrayPropMarshaller parametersMarshaller = new ParameterValueArrayPropMarshaller(this.getReport().getParameters().getValue());
                parametersMarshaller.marshall(reportNode);
            }
            if (this.getReport().getOptions() != null) {
                this.marshallOptions(reportNode, this.getReport().getOptions());
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    private void marshallReportProperty(Element parentNode, String propertyName, String propertyValue, String propertTypeAtribute) {
        Element propertyElement = parentNode.addElement(propertyName);
        propertyElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + propertTypeAtribute);
        Element propertyValueElement = propertyElement.addElement("value");
        propertyValueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        propertyValueElement.setText(propertyValue);
    }

    public void marshallOptions(Element parentNode, OptionArrayProp optionArrayProp) {
        Element optionsNode = parentNode.addElement("options").addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":optionArrayProp").addAttribute("xmlns:SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/").addAttribute("xmlns:" + BIBusEnvelope.NS_BUS.getPrefix(), BIBusEnvelope.NS_BUS.getURI()).addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element optionsValueNode = optionsNode.addElement("value").addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY).addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":option[]");
        OptionMarshaller optionMarshaller = new OptionMarshaller(null);
        Option[] option = optionArrayProp.getValue();
        optionMarshaller.marshallGenericOptionBoolean(option[0], optionsValueNode);
    }
}

