/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValueArrayPropMarshaller;
import com.cognos.viewer.model.marshallers.ReportMarshaller;
import org.dom4j.Element;

public class ReportViewMarshaller
implements IArgumentMarshaller {
    private ReportView m_reportView = null;

    public ReportViewMarshaller(ReportView reportView) {
        this.m_reportView = reportView;
    }

    private ReportView getReportView() {
        return this.m_reportView;
    }

    @Override
    public void marshall(Element parentNode) throws CognosViewerException {
        Element reportNode = parentNode.addElement("item");
        reportNode.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":reportView");
        try {
            if (this.getReportView().getSearchPath() != null) {
                this.marshallProperty(reportNode, "searchPath", this.getReportView().getSearchPath().getValue(), ":stringProp");
            }
            if (this.getReportView().getDefaultName() != null) {
                this.marshallProperty(reportNode, "defaultName", this.getReportView().getDefaultName().getValue(), ":tokenProp");
            }
            if (this.getReportView().getBase() != null) {
                this.marshallBase(reportNode);
            }
            if (this.getReportView().getParameters() != null) {
                ParameterValueArrayPropMarshaller parametersMarshaller = new ParameterValueArrayPropMarshaller(this.getReportView().getParameters().getValue());
                parametersMarshaller.marshall(reportNode);
            }
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }

    private void marshallBase(Element parentNode) throws CognosViewerException {
        BaseClassArrayProp baseArray = this.getReportView().getBase();
        BaseClass[] values = baseArray.getValue();
        Report report = (Report)values[0];
        Element baseElement = parentNode.addElement("base");
        baseElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClassArrayProp");
        Element baseValueElement = baseElement.addElement("value");
        baseValueElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + SOAPEnvelope.SOAP_ENC_ARRAY);
        baseValueElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[1]");
        ReportMarshaller reportMarshaller = new ReportMarshaller(report);
        reportMarshaller.marshall(baseValueElement);
    }

    private void marshallProperty(Element parentNode, String propertyName, String propertyValue, String propertTypeAtribute) {
        Element propertyElement = parentNode.addElement(propertyName);
        propertyElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + propertTypeAtribute);
        Element propertyValueElement = propertyElement.addElement("value");
        propertyValueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        propertyValueElement.setText(propertyValue);
    }
}

