/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SingleSearchPathMarshaller
implements IArgumentMarshaller {
    public static final String BUS_SEARCH_PATH_SINGLE_OBJECT = BIBusEnvelope.NS_BUS.getPrefix() + ":" + "searchPathSingleObject";
    public static final QName BUS_OBJECT_PATH = DocumentHelper.createQName((String)"objectPath", (Namespace)BIBusEnvelope.NS_BUS);
    public static final QName BUS_PARENT_PATH = DocumentHelper.createQName((String)"parentPath");
    private SearchPathSingleObject m_searchPath = null;
    private QName m_qName = BUS_OBJECT_PATH;

    public SingleSearchPathMarshaller(SearchPathSingleObject searchPath) {
        this.m_searchPath = searchPath;
    }

    public SingleSearchPathMarshaller(SearchPathSingleObject searchPath, QName qName) {
        this.m_searchPath = searchPath;
        this.m_qName = qName;
    }

    private SearchPathSingleObject getSearchPath() {
        return this.m_searchPath;
    }

    @Override
    public void marshall(Element parentNode) {
        SearchPathSingleObject searchPath = this.getSearchPath();
        Element objectPath = parentNode.addElement(this.m_qName);
        objectPath.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_SEARCH_PATH_SINGLE_OBJECT);
        if (searchPath == null || searchPath.get_value() == null || searchPath.get_value().length() == 0) {
            objectPath.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        } else {
            objectPath.setText(searchPath.get_value());
        }
    }

    public SearchPathSingleObject unmarshall(Element searchPathNode) {
        SearchPathSingleObject searchPath = new SearchPathSingleObject();
        searchPath.set_value(searchPathNode.getText());
        return searchPath;
    }
}

