/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.model.marshallers;

import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class SortMarshaller
implements IArgumentMarshaller {
    private Sort[] m_sorts = null;

    public SortMarshaller() {
    }

    public SortMarshaller(Sort[] sorts) {
        this.m_sorts = sorts;
    }

    private Sort[] getSorts() {
        return this.m_sorts;
    }

    @Override
    public void marshall(Element parentElement) throws CognosViewerException {
        this.marshall(parentElement, DocumentHelper.createQName((String)"sortBy", null));
    }

    public void marshall(Element parentElement, QName nodeName) throws CognosViewerException {
        Element propertiesNode = parentElement.addElement(nodeName);
        propertiesNode.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        propertiesNode.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":sort[]");
        try {
            Sort[] sorts = this.getSorts();
            if (sorts != null) {
                for (int iIndex = 0; iIndex < sorts.length; ++iIndex) {
                    if (sorts[iIndex] == null) continue;
                    Element sortItem = propertiesNode.addElement("item");
                    sortItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":sort");
                    Element propName = sortItem.addElement("propName");
                    propName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
                    propName.setText(sorts[iIndex].getPropName().getValue());
                    Element order = sortItem.addElement("order");
                    order.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":orderEnum");
                    order.setText(sorts[iIndex].getOrder().getValue());
                }
            }
        }
        catch (Exception e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }
}

