/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.render;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.render.Renderer;
import com.cognos.viewer.render.RendererHelper;
import com.cognos.viewer.render.ReportBodyFragmentFrameURL;
import com.cognos.viewer.utility.MessageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class CMRestRenderer
implements Renderer {
    @Override
    public String renderReportBodyFragment(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        return ReportBodyFragmentFrameURL.protectIFrameUrl(actionResponse);
    }

    @Override
    public String renderDetailOutput(CMServerResponse response) throws CognosViewerException {
        StringBuilder output = new StringBuilder();
        StringBuilder dataURI = new StringBuilder();
        dataURI.append(response.getProperty(PropEnum.dataPathInfo.getValue()));
        if (dataURI.length() == 0) {
            return "";
        }
        String sContentFormat = response.getContentFormat();
        if (RendererHelper.isXMLOnNonIEBrowser(sContentFormat, response)) {
            InputStream is = this.getHttpDataStream(dataURI.toString(), response);
            response.setAttachmentInputStream(is);
            output.append("####attachmentPlaceHolder####");
        } else {
            String sCVId = response.getFormFieldAsString("cv.id");
            if (!sCVId.isEmpty()) {
                dataURI.append("?cv.id=" + sCVId);
            }
            output.append((CharSequence)dataURI);
            String bookmark = response.getFormFieldAsString("ui.bookmark");
            if (bookmark.length() > 0) {
                output.append("#" + bookmark);
            }
        }
        return output.toString();
    }

    private InputStream getHttpDataStream(String dataURI, CMServerResponse response) throws CognosViewerException {
        String dispatcherURI = CognosViewerDispatcherHandler.getDispatcherURI();
        String restURL = dispatcherURI + dataURI;
        GetMethod restGet = new GetMethod(restURL);
        this.executeHttpRequest((HttpMethod)restGet, response);
        try {
            if (this.isContentGziped((HttpMethod)restGet)) {
                GZIPInputStream gzipedStream = new GZIPInputStream(restGet.getResponseBodyAsStream());
                return gzipedStream;
            }
            return restGet.getResponseBodyAsStream();
        }
        catch (IOException e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
    }

    private void executeHttpRequest(HttpMethod method, CMServerResponse response) throws CognosViewerException {
        int httpResponseCode;
        String cam_passport = response.getCookieValue("cam_passport");
        method.setRequestHeader("Cookie", "cam_passport=" + cam_passport);
        method.setRequestHeader("Accept-Encoding", "gzip, deflate");
        HttpClient httpClient = new HttpClient();
        try {
            httpResponseCode = httpClient.executeMethod(method);
        }
        catch (IOException e) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
            throw cognosViewerException;
        }
        if (httpResponseCode != 200) {
            BIBusEnvelope busEnvelope = response.getBusEnvelope();
            Object[] args = new Object[]{httpResponseCode};
            String locale = CognosViewerDispatcherHandlerState.getFaultLocale(busEnvelope);
            String msg = MessageManager.convert("RV_CM_REST_REQUEST_ERROR", locale, args);
            CognosViewerException cognosViewerException = new CognosViewerException(busEnvelope, msg, null);
            throw cognosViewerException;
        }
    }

    private boolean isContentGziped(HttpMethod method) {
        Header encodingHeader = method.getResponseHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.getValue().equalsIgnoreCase("gzip");
    }
}

