/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.render;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.render.RendererHelper;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.base64;
import com.cognos.xts.ext.XTSExt;
import java.io.UnsupportedEncodingException;

public class CMSoapDetailOutput {
    public static String render(CMServerResponse response) throws CognosViewerException {
        StringBuilder output = new StringBuilder();
        String sContentFormat = response.getContentFormat();
        if (RendererHelper.isXMLOnNonIEBrowser(sContentFormat, response)) {
            try {
                byte[] data = base64.decode(0, response.getProperty("data"));
                output.append(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, e.getMessage(), e);
                throw cognosViewerException;
            }
        } else if (CMSoapDetailOutput.isHTML_XML_CSV_MHT_Format(sContentFormat)) {
            output.append(CMSoapDetailOutput.buildURL(response));
        } else {
            output.append("storeID(\"").append(response.getProperty(PropEnum.storeID.getValue())).append("\")");
        }
        return output.toString();
    }

    private static boolean isHTML_XML_CSV_MHT_Format(String contentFormat) {
        return contentFormat.indexOf("HTML") != -1 || "MHT".equals(contentFormat) || "XML".equals(contentFormat) || "CSV".equals(contentFormat);
    }

    private static String buildURL(CMServerResponse response) {
        String sBookmark;
        String sConfigDataEncoding;
        String sContentFormat = response.getContentFormat();
        String cmSearchPath = response.getProperty("searchPath");
        if (cmSearchPath.length() == 0) {
            cmSearchPath = response.getObjectPath().get_value();
        }
        StringBuilder sIframeURL = new StringBuilder("?SM=query&search=");
        if (CognosViewerDispatcherHandlerState.isIROTReport(response.getState())) {
            sIframeURL.append(Protect.protect(XTSExt.web64encode((String)cmSearchPath, (boolean)true), "url", "searchPath", "getdata"));
            sIframeURL.append("&webcompress=true");
            if (!BrowserUtility.isInternetExplorer(RendererHelper.getBrowserUserAgent(response))) {
                sIframeURL.append("&download=true");
            }
        } else {
            sIframeURL.append(Protect.protect(EncodingUtility.urlencode(cmSearchPath), "url", "searchPath", "getdata"));
        }
        if ((sConfigDataEncoding = CognosViewerDispatcherHandler.getConfigValues().getProperty("htmlOutputDataEncoding")) == null || "".equals(sConfigDataEncoding)) {
            sConfigDataEncoding = "MIMECompressed";
        }
        if ("MIMECompressed".equals(sConfigDataEncoding) && !response.isAppServerMIMECompressedSafe()) {
            sConfigDataEncoding = "MIME";
        }
        String sDataEncoding = "MIMECompressed".equals(sConfigDataEncoding) && ("gzip, deflate".equals(response.getEnvironmentVariable("Accept-Encoding")) || "gzip,deflate".equals(response.getEnvironmentVariable("Accept-Encoding"))) ? "MIMECompressed" : "MIME";
        sIframeURL.append("&SA=propEnum,properties&ITEM=data&EA=&SS=queryOptions,options&dataEncoding=" + sDataEncoding + "&ES=&EM=");
        if (sContentFormat.indexOf("HTML") != -1) {
            sIframeURL.append("&cv.id=" + response.getFormFieldAsString("cv.id"));
        }
        if ((sBookmark = response.getFormFieldAsString("ui.bookmark")).length() != 0) {
            sIframeURL.append("&viewer=true#" + sBookmark);
        }
        return sIframeURL.toString();
    }
}

