/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.render;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.ReportBodyGenerator;

public class ReportBodyFragmentFrameURL {
    public static String buildSoapIFrameURL(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        StringBuilder iFrameURL = new StringBuilder();
        String sURLQueryString = actionResponse.getDetailOutput().toString();
        if (sURLQueryString.length() <= 0) {
            return iFrameURL.toString();
        }
        String sAction = actionResponse.getAction();
        String contentFormat = actionResponse.getContentFormat();
        if (ReportBodyFragmentFrameURL.isPDFOrSpreadsheetFormat(contentFormat)) {
            CAMPassport camPassport = actionResponse.getCAMPassport();
            String sOutputLocation = CognosViewerDispatcherHandler.getOutputLocation(actionResponse);
            if (!"view".equals(sAction)) {
                if ("http://developer.cognos.com/ceba/constants/temporaryObjectLocationEnum#serverFileSystem".equals(sOutputLocation)) {
                    iFrameURL.append(sURLQueryString);
                } else {
                    sURLQueryString = ReportBodyGenerator.extractSearchPathFromURLQueryString(sURLQueryString);
                    ReportBodyGenerator.addURLParamsForSelfContainedSavedReportOutput(contentFormat, iFrameURL, camPassport, sURLQueryString);
                }
            } else if (CognosViewerDispatcherHandler.getUseCachedSavedOutputDisabled() || contentFormat.compareTo("XLS") == 0) {
                ReportBodyGenerator.addURLParamsForSelfContainedSavedReportOutput(contentFormat, iFrameURL, camPassport, sURLQueryString);
            } else {
                ReportBodyGenerator.addURLParamsForCachedSelfContainedSavedReportOutput(actionResponse, iFrameURL);
            }
        } else if ("view".equals(sAction)) {
            iFrameURL.append(sURLQueryString);
        } else {
            String protectedUrl = ReportBodyFragmentFrameURL.protectIFrameUrl(sURLQueryString);
            iFrameURL.append(protectedUrl);
        }
        if (iFrameURL.indexOf("&viewer=true") == -1) {
            if (iFrameURL.indexOf("?") == -1 || iFrameURL.indexOf("_THIS?") == 0 && iFrameURL.indexOf("?", 7) == -1) {
                iFrameURL.append("?viewer=true");
            } else {
                iFrameURL.append("&viewer=true");
            }
        }
        return iFrameURL.toString();
    }

    private static String protectIFrameUrl(String sURLQueryString) {
        String protectedUrl = "";
        protectedUrl = sURLQueryString.startsWith("?") ? "?" + Protect.protect(sURLQueryString.substring(1), "url", "NAMEoutput", "getdata") : Protect.protect(sURLQueryString, "url", "NAMEoutput", "getdata");
        return protectedUrl;
    }

    public static String protectIFrameUrl(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        String sURLQueryString = actionResponse.getDetailOutput().toString();
        return ReportBodyFragmentFrameURL.protectIFrameUrl(sURLQueryString);
    }

    private static boolean isPDFOrSpreadsheetFormat(String contentFormat) {
        return contentFormat.compareTo("XLS") == 0 || contentFormat.compareTo("PDF") == 0 || contentFormat.compareTo("spreadsheetML") == 0 || contentFormat.compareTo("xlsxData") == 0 || contentFormat.compareTo("XLWA") == 0 || contentFormat.compareTo("singleXLS") == 0 || contentFormat.compareTo("CSV") == 0;
    }
}

