/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.toolbar;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.toolbar.ToolbarItemStateEnum;
import com.cognos.viewer.toolbar.ToolbarRule;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import org.dom4j.Document;
import org.dom4j.Element;

public class CognosViewerRules
extends ToolbarRule {
    private boolean hasCapability(ICognosViewerActionResponse actionResponse, String capability) {
        return actionResponse.getCapabilities().hasCapability(capability);
    }

    public boolean isPreviewMode(ICognosViewerState state) {
        return state.getFormFieldAsString("ui.spec").length() != 0 && !"true".equals(state.getFormFieldAsString("uiSpecAddedFromRun"));
    }

    public ToolbarItemStateEnum userNameRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public void userNameDynamic(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        Element textElement = toolbarItem.addElement("text");
        String sIsNamed = "0";
        if (actionResponse.getCAMPassport() != null && actionResponse.getCAMPassport().getId().length() > 3) {
            sIsNamed = actionResponse.getCAMPassport().getId().substring(2, 3);
        }
        if ("1".equals(sIsNamed)) {
            if ("".equals(actionResponse.getFormFieldAsString("ui.username"))) {
                textElement.setText(EncodingUtility.htmlencode(actionResponse.getSessionManager().getSessionParam("e_user")));
            } else {
                textElement.setText(EncodingUtility.htmlencode(actionResponse.getFormFieldAsString("ui.username")));
            }
        }
    }

    public ToolbarItemStateEnum logOnRule(ICognosViewerActionResponse actionResponse) {
        String sIsSecure = "0";
        if (actionResponse.getCAMPassport() != null && actionResponse.getCAMPassport().getId().length() > 1) {
            sIsSecure = actionResponse.getCAMPassport().getId().substring(0, 1);
        }
        boolean bShowLogOn = !this.isPreviewMode(actionResponse) && sIsSecure.compareTo("1") == 0 && "true".equals(actionResponse.getSessionManager().getSessionParam("show_logon"));
        return bShowLogOn ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
    }

    public void logOnDynamic(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        String sIsNamed = "0";
        if (actionResponse.getCAMPassport() != null && actionResponse.getCAMPassport().getId().length() > 3) {
            sIsNamed = actionResponse.getCAMPassport().getId().substring(2, 3);
        }
        String sLogOnLink = "";
        if (sIsNamed.compareTo("1") == 0) {
            sLogOnLink = sLogOnLink + actionResponse.getFormFieldAsString("ui.backURL");
        } else {
            sLogOnLink = sLogOnLink + actionResponse.getEnvironmentVariable("SCRIPT_NAME");
            sLogOnLink = sLogOnLink + "?" + CognosViewerSystemParams.getSystemParam("COGNOSHome");
        }
        String cvJSID = actionResponse.getFormFieldAsString("CV_jsID");
        Element actionElement = toolbarItem.addElement("action");
        actionElement.addText(cvJSID + ".getRV().authenticate(\"logon\", \"" + XTSExt.javascriptencode((String)sLogOnLink) + "\");");
    }

    public ToolbarItemStateEnum logOffRule(ICognosViewerActionResponse actionResponse) {
        String sIsSecure = "0";
        String sIsNamed = "0";
        CAMPassport passport = actionResponse.getCAMPassport();
        if (passport != null && passport.getId().length() > 1) {
            sIsSecure = passport.getId().substring(0, 1);
        }
        if (passport != null && passport.getId().length() > 3) {
            sIsNamed = passport.getId().substring(2, 3);
        }
        boolean bShowLogOff = !this.isPreviewMode(actionResponse) && sIsSecure.compareTo("1") == 0 && sIsNamed.compareTo("1") == 0;
        return bShowLogOff ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
    }

    public void logOffDynamic(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        String sLogOffLink = actionResponse.getEnvironmentVariable("SCRIPT_NAME") + "?b_action=xts.run&m=" + CognosViewerSystemParams.getSystemParam("app") + "/logoff.xts";
        String cvJSID = actionResponse.getFormFieldAsString("CV_jsID");
        Element actionElement = toolbarItem.addElement("action");
        actionElement.addText(cvJSID + ".getRV().authenticate(\"logoff\", \"" + XTSExt.javascriptencode((String)sLogOffLink) + "\");");
    }

    public ToolbarItemStateEnum homeRule(ICognosViewerActionResponse actionResponse) {
        return this.isPreviewMode(actionResponse) ? ToolbarItemStateEnum.itemHidden : ToolbarItemStateEnum.itemEnabled;
    }

    public void homeDynamic(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        String homeLink = actionResponse.getEnvironmentVariable("SCRIPT_NAME") + "?" + CognosViewerSystemParams.getSystemParam("COGNOSHome");
        String cvJSID = actionResponse.getFormFieldAsString("CV_jsID");
        Element actionElement = toolbarItem.addElement("action");
        actionElement.addText(cvJSID + ".getRV().returnHome(\"" + XTSExt.javascriptencode((String)homeLink) + "\");");
    }

    public ToolbarItemStateEnum returnRule(ICognosViewerActionResponse actionResponse) {
        return this.isPreviewMode(actionResponse) || actionResponse.getFormFieldAsString("ui.backURL").length() == 0 || actionResponse.getFormFieldAsString("ui.backURL").indexOf("window.close") != -1 ? ToolbarItemStateEnum.itemHidden : ToolbarItemStateEnum.itemEnabled;
    }

    public void returnDynamic(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        String uiPostBack = actionResponse.getFormFieldAsString("ui.postBack");
        String sOnClickEvent = "";
        sOnClickEvent = "".equals(uiPostBack) ? "executeBackURL('" + actionResponse.getFormFieldAsString("cv.id") + "');" : actionResponse.getFormFieldAsString("CV_jsID") + ".getRV().doPostBack();";
        Element actionElement = toolbarItem.addElement("action");
        actionElement.addText(sOnClickEvent);
    }

    public ToolbarItemStateEnum keepThisVersionRule(ICognosViewerActionResponse actionResponse) {
        boolean bSpecAddedFromRun = "true".equals(actionResponse.getFormFieldAsString("uiSpecAddedFromRun"));
        return actionResponse.getFormFieldAsString("ui.spec").length() != 0 && !bSpecAddedFromRun ? ToolbarItemStateEnum.itemHidden : ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum downloadReportRule(ICognosViewerActionResponse actionResponse) {
        CognosViewerBlacklist cvBlacklist = actionResponse.getUIBlacklist();
        if ("view".equals(actionResponse.getAction())) {
            if (cvBlacklist.isDownloadable(actionResponse.getContentFormat())) {
                return actionResponse.getContentFormat().indexOf("HTML") == -1 ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemDisabled;
            }
            return ToolbarItemStateEnum.itemDisabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum emailReportRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum saveReportRule(ICognosViewerActionResponse actionResponse) {
        if (!"view".equals(actionResponse.getAction())) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum saveAsReportViewRule(ICognosViewerActionResponse actionResponse) {
        String uiObj = actionResponse.getFormFieldAsString("ui.objectClass");
        if (!"view".equals(actionResponse.getAction()) && !"reportView".equals(uiObj)) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum runReportRule(ICognosViewerActionResponse actionResponse) {
        if ("view".equals(actionResponse.getAction())) {
            return "true".equals(actionResponse.getFormFieldAsString("cv.executePermission")) ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum drillDownRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum drillUpRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum gotoRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInRule(ICognosViewerActionResponse actionResponse) {
        if ("view".equals(actionResponse.getAction())) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum runInRule(ICognosViewerActionResponse actionResponse) {
        if (!"view".equals(actionResponse.getAction())) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum viewInHTMLRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInPDFRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInXMLRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInExcelRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInspreadsheetMLRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInXLWARule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInSingleXLSRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInXLSRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum viewInCSVRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum addThisReportRule(ICognosViewerActionResponse actionResponse) {
        return this.isPreviewMode(actionResponse) ? ToolbarItemStateEnum.itemHidden : ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum addToMyFoldersRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum watchNewVersionsRule(ICognosViewerActionResponse actionResponse) {
        return "view".equals(actionResponse.getAction()) ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum addAnnotationsRule(ICognosViewerActionResponse actionResponse) {
        return "view".equals(actionResponse.getAction()) ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum openWithRule(ICognosViewerActionResponse actionResponse) {
        String objectPermissions = actionResponse.getFormFieldAsString("cv.objectPermissions");
        if ("view".equals(actionResponse.getAction()) || objectPermissions.indexOf("read") == -1) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum openWithQueryStudioRule(ICognosViewerActionResponse actionResponse) {
        String sBrowser = BrowserUtility.getBrowser(actionResponse.getEnvironmentVariable("HTTP_USER_AGENT"));
        String sObjectClass = actionResponse.getFormFieldAsString("ui.objectClass");
        if (!"view".equals(actionResponse.getAction()) && actionResponse.getFormFieldAsString("ui.spec").compareTo("") == 0 && (sBrowser.compareTo("moz") == 0 || sBrowser.compareTo("ie") == 0) && actionResponse.getCapabilities().hasCapability("canUseQueryStudio") && sObjectClass.indexOf("query") != -1) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum openWithAnalysisStudioRule(ICognosViewerActionResponse actionResponse) {
        String sObjectClass = actionResponse.getFormFieldAsString("ui.objectClass");
        if (!"view".equals(actionResponse.getAction()) && actionResponse.getFormFieldAsString("ui.spec").compareTo("") == 0 && actionResponse.getCapabilities().hasCapability("canUseAnalysisStudio") && sObjectClass.indexOf("analysis") != -1) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum openWithReportStudioRule(ICognosViewerActionResponse actionResponse) {
        String uiObj = actionResponse.getFormFieldAsString("ui.objectClass");
        actionResponse.getIPFLogger().debug("ui.objectClass = " + uiObj, this.getClass().getName());
        if (!"view".equals(actionResponse.getAction()) && actionResponse.getFormFieldAsString("ui.spec").compareTo("") == 0 && actionResponse.getCapabilities().hasCapability("canUseReportStudio") && !"reportView".equals(uiObj)) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum addToMyBookmarksRule(ICognosViewerActionResponse actionResponse) {
        String sBrowser = BrowserUtility.getBrowser(actionResponse.getEnvironmentVariable("HTTP_USER_AGENT"));
        if (sBrowser.compareTo("ie") == 0) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum aboutRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum previousReportRule(ICognosViewerActionResponse actionResponse) {
        String sPreviousReports = actionResponse.getFormFieldAsString("cv.previousReports");
        if (!"".equals(sPreviousReports)) {
            try {
                Document document = XMLUtility.createXMLDocument(sPreviousReports);
                Element previousReports = document.getRootElement();
                if (previousReports == null || !"previousReports".equals(previousReports.getName()) || previousReports.elements("previousReport") == null || previousReports.elements("previousReport").size() == 0) {
                    return ToolbarItemStateEnum.itemHidden;
                }
                return ToolbarItemStateEnum.itemEnabled;
            }
            catch (Exception exception) {
                actionResponse.getIPFLogger().error("Caught exception in previousReportRule: " + exception.getMessage(), exception, this.getClass().getName());
                return ToolbarItemStateEnum.itemHidden;
            }
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    private ToolbarItemStateEnum buxInteractivityRule(ICognosViewerActionResponse actionResponse) {
        String objectPermissions = actionResponse.getFormFieldAsString("cv.objectPermissions");
        String limitedInteractiveMode = actionResponse.getFormFieldAsString("limitedInteractiveMode");
        if ("true".equals(limitedInteractiveMode) || objectPermissions.indexOf("read") == -1 || objectPermissions.indexOf("execute") == -1) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum EditContentRule(ICognosViewerActionResponse actionResponse) {
        boolean bExpressUIProfileEnabled;
        ToolbarItemStateEnum toolbarState = this.buxInteractivityRule(actionResponse);
        String sRSUIProfile = actionResponse.getSessionManager().getSessionParam("rsuiprofile");
        boolean bl = bExpressUIProfileEnabled = sRSUIProfile.length() != 0 && (sRSUIProfile.equals("all") || sRSUIProfile.equals("bua"));
        if (!(toolbarState == ToolbarItemStateEnum.itemHidden || actionResponse.getCapabilities().hasCapability("canUseReportStudio") && bExpressUIProfileEnabled)) {
            toolbarState = ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemHidden != toolbarState ? ToolbarItemStateEnum.itemEnabled : ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum UndoRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum RedoRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum FilterRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum SortRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum CalculationRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum SwapRowsAndColumnsRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum ChangeDisplayTypeRule(ICognosViewerActionResponse actionResponse) {
        if (actionResponse.getVisCoachMode() > 0) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum ChangeDisplayTypeDynamicRule(ICognosViewerActionResponse actionResponse) {
        if (actionResponse.getVisCoachMode() == 0) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum InvokeChangeDisplayTypeDialogDynamicRule(ICognosViewerActionResponse actionResponse) {
        if (actionResponse.getVisCoachMode() == 0) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum ChangePaletteRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum GroupRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum DrillDownRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum DrillUpRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum RenameFromContextMenuRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum MoveRule(ICognosViewerActionResponse actionResponse) {
        return this.buxInteractivityRule(actionResponse);
    }

    public ToolbarItemStateEnum GoToRule(ICognosViewerActionResponse actionResponse) {
        return ToolbarItemStateEnum.itemDisabled;
    }

    public ToolbarItemStateEnum GlossaryRule(ICognosViewerActionResponse actionResponse) {
        if (this.hasCapability(actionResponse, "canUseGlossary")) {
            return ToolbarItemStateEnum.itemDisabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum LineageRule(ICognosViewerActionResponse actionResponse) {
        if (this.hasCapability(actionResponse, "canUseLineage")) {
            return ToolbarItemStateEnum.itemDisabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum WatchNewVersionsRule(ICognosViewerActionResponse actionResponse) {
        if (this.hasCapability(actionResponse, "canUseConditionalSubscriptions")) {
            return ToolbarItemStateEnum.itemDisabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum RunReportRule(ICognosViewerActionResponse actionResponse) {
        String objectPermissions = actionResponse.getFormFieldAsString("cv.objectPermissions");
        if (objectPermissions.indexOf("execute") != -1) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    private ToolbarItemStateEnum buxLimitedInteractiveModeRule(ICognosViewerActionResponse actionResponse) {
        String limitedInteractiveMode = actionResponse.getFormFieldAsString("limitedInteractiveMode");
        if ("true".equals(limitedInteractiveMode)) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum ExportRule(ICognosViewerActionResponse actionResponse) {
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum PrintAsPDFRule(ICognosViewerActionResponse actionResponse) {
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum CopyRule(ICognosViewerActionResponse actionResponse) {
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum CutRule(ICognosViewerActionResponse actionResponse) {
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum ExploreWithAAFRule(ICognosViewerActionResponse actionResponse) {
        boolean isAAReport;
        Capabilities capabilities = actionResponse.getCapabilities();
        boolean bl = isAAReport = actionResponse.getObject("AAFBaseUrl") != null;
        if (isAAReport && (capabilities.hasCapability("canUseAdaptiveAnalytics") || capabilities.hasCapability("canUseAdaptiveAnalyticsAdministration"))) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }

    public ToolbarItemStateEnum ResetToOriginalRule(ICognosViewerActionResponse actionResponse) {
        if (actionResponse.getFormFieldAsString("originalReport").isEmpty()) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum DeleteRule(ICognosViewerActionResponse actionResponse) {
        return this.buxLimitedInteractiveModeRule(actionResponse);
    }

    public ToolbarItemStateEnum OpenReportFromClipboardRule(ICognosViewerActionResponse actionResponse) {
        if (!this.hasCapability(actionResponse, "canUseReportStudio")) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum BusinessProcessRule(ICognosViewerActionResponse actionResponse) {
        String sBPMRestURI = actionResponse.getFormFieldAsString("bpmRestURI");
        if (sBPMRestURI.length() <= 0) {
            return ToolbarItemStateEnum.itemHidden;
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public ToolbarItemStateEnum printRule(ICognosViewerActionResponse actionResponse) {
        if ("view".equals(actionResponse.getAction()) && CognosViewerDispatcherHandler.getConfigValues().getBoolean("enableSavedOutputToolbarPrint")) {
            return ToolbarItemStateEnum.itemEnabled;
        }
        return ToolbarItemStateEnum.itemHidden;
    }
}

