/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.toolbar;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.toolbar.CognosViewerRules;
import com.cognos.viewer.toolbar.ToolbarRule;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.XMLUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class ToolbarFactory {
    public static final String VIEWER_BANNER = "viewerBanner";
    public static final String VIEWER_TOOLBAR = "viewerToolbar";
    public static final String BUX_TOOLBAR = "buxToolbar";
    public static final String BUX_TOOLBAR_CONSUME = "buxToolbarConsume";
    public static final String BUX_TOOLBAR_INTERACT = "buxToolbarInteract";
    public static final String BUX_SAVED_OUTPUT_TOOLBAR = "buxSavedOutputToolbar";
    public static final String BUX_CONTEXT_MENU = "buxContextMenu";
    public static final String BUX_SAVED_OUTPUT_CONTEXT_MENU = "buxSavedOutputContextMenu";
    public static final String BUX_ACTIVE_REPORT_CONTEXT_MENU = "buxActiveReportContextMenu";
    public static final String MOBILE_CONTEXT_MENU = "mobileContextMenu";
    private static final String VIEWER_BANNER_PATH = "../templates/ps/portal/viewer-banner.xml";
    private static final String VIEWER_TOOLBAR_PATH = "../templates/ps/portal/viewer-toolbar.xml";
    private static final String BUX_TOOLBAR_PATH = "../templates/ps/portal/bux-toolbar.xml";
    private static final String BUX_SAVED_OUTPUT_TOOLBAR_PATH = "../templates/ps/portal/bux-savedOutput-toolbar.xml";
    private static final String BUX_CONTEXT_MENU_PATH = "../templates/ps/portal/bux-contextMenu.xml";
    private static final String BUX_SAVED_OUTPUT_CONTEXT_MENU_PATH = "../templates/ps/portal/bux-contextMenu-savedOutput.xml";
    private static final String BUX_ACTIVE_REPORT_TOOLBAR_PATH = "../templates/ps/portal/bux-activeReport-toolbar.xml";
    private static final String MOBILE_CONTEXT_MENU_PATH = "../templates/ps/portal/mobile-contextMenu.xml";
    private static CognosViewerRules m_cognosViewerRules = new CognosViewerRules();
    private static HashMap m_aObjects = new HashMap();
    private static HashMap m_aToolbarSpecs = new HashMap();

    public ToolbarFactory() {
        this.initializeToolbar(VIEWER_BANNER, VIEWER_BANNER_PATH);
        this.initializeToolbar(VIEWER_TOOLBAR, VIEWER_TOOLBAR_PATH);
        this.initializeToolbar(BUX_TOOLBAR, BUX_TOOLBAR_PATH);
        this.initializeToolbar(BUX_SAVED_OUTPUT_TOOLBAR, BUX_SAVED_OUTPUT_TOOLBAR_PATH);
        this.initializeToolbar(BUX_CONTEXT_MENU, BUX_CONTEXT_MENU_PATH);
        this.initializeToolbar(BUX_SAVED_OUTPUT_CONTEXT_MENU, BUX_SAVED_OUTPUT_CONTEXT_MENU_PATH);
        this.initializeToolbar(BUX_ACTIVE_REPORT_CONTEXT_MENU, BUX_ACTIVE_REPORT_TOOLBAR_PATH);
        this.initializeToolbar(MOBILE_CONTEXT_MENU, MOBILE_CONTEXT_MENU_PATH);
    }

    private void initializeToolbar(String hashKey, String path) {
        try {
            String sPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(path);
            ToolbarFactory.loadToolbarSpec(hashKey, sPath);
        }
        catch (Exception e) {
            IPFLogger.getInstance().error("Caught exception in constructor of ToolbarFactory: " + e.toString(), this.getClass().getName());
        }
    }

    public static synchronized void loadToolbarSpec(String sKey, String sFilePath) throws IOException, FileNotFoundException {
        if (m_aToolbarSpecs.containsKey(sKey)) {
            return;
        }
        sFilePath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sFilePath);
        Document toolbarSpec = XMLUtility.createXMLDocument(new File(sFilePath));
        m_aToolbarSpecs.put(sKey, toolbarSpec.getRootElement());
        ToolbarFactory.loadResourceBundles(toolbarSpec.getRootElement());
    }

    private static synchronized void loadResourceBundles(Element toolbarSpec) {
        List resourceBundles = toolbarSpec.selectNodes("resourceBundle");
        for (int iIndex = 0; iIndex < resourceBundles.size(); ++iIndex) {
            Element resourceBundle = (Element)resourceBundles.get(iIndex);
            String bundleName = resourceBundle.attributeValue("name");
            if (bundleName == null || "".equals(bundleName)) continue;
            MessageManager.addMessageFile(bundleName);
        }
    }

    public static Element getToolbarSpec(String sKey) {
        if (m_aToolbarSpecs.get(sKey) != null) {
            return (Element)m_aToolbarSpecs.get(sKey);
        }
        return null;
    }

    public static ToolbarRule getRuleObject(Element element) {
        String sRuleClass;
        if (element != null && element.attribute("rule") != null && (sRuleClass = element.attribute("rule").getStringValue()).length() > 0) {
            ToolbarRule ruleObject = (ToolbarRule)m_aObjects.get(sRuleClass);
            if (ruleObject != null) {
                return ruleObject;
            }
            try {
                ruleObject = ToolbarFactory.instantiateObject(sRuleClass);
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error("Caught exception in getRuleObject: " + ex.toString(), ToolbarFactory.class.getName());
            }
            if (ruleObject != null) {
                return ruleObject;
            }
        }
        return m_cognosViewerRules;
    }

    private static ToolbarRule instantiateObject(String sObject) throws CognosViewerException {
        try {
            Class<?> serviceClass = Class.forName(sObject);
            Class[] paramTypes = new Class[]{};
            Constructor<?> ruleConstructor = serviceClass.getConstructor(paramTypes);
            Object[] args = new Object[]{};
            ToolbarRule rule = (ToolbarRule)ruleConstructor.newInstance(args);
            m_aObjects.put(sObject, rule);
            return rule;
        }
        catch (Exception ex) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, ex.getMessage(), ex);
            throw cognosViewerException;
        }
    }
}

