/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.toolbar;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.toolbar.ToolbarItemStateEnum;
import com.cognos.viewer.utility.IPFLogger;
import java.lang.reflect.Method;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class ToolbarRule {
    public ToolbarItemStateEnum getState(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        if (toolbarItem != null) {
            Element nameNode;
            if (toolbarItem.attribute("capability") != null) {
                boolean capabilityMatch = false;
                String capabilityAtt = toolbarItem.attribute("capability").getStringValue();
                String[] capabilities = capabilityAtt.split(" ");
                for (int i = 0; i < capabilities.length; ++i) {
                    if (!actionResponse.getCapabilities().hasCapability(capabilities[i])) continue;
                    capabilityMatch = true;
                    break;
                }
                if (!capabilityMatch) {
                    return ToolbarItemStateEnum.itemHidden;
                }
            }
            if ("true".equalsIgnoreCase((String)actionResponse.getObject("enableToolbarOnFault"))) {
                Attribute a = toolbarItem.attribute("showOnFault");
                if (null != a && a.getStringValue().equalsIgnoreCase("yes")) {
                    return ToolbarItemStateEnum.itemEnabled;
                }
                return ToolbarItemStateEnum.itemHidden;
            }
            CognosViewerBlacklist cognosViewerBlacklist = actionResponse.getUIBlacklist();
            if (toolbarItem.attribute("systemCondition") != null) {
                String sSystemCondition = toolbarItem.attribute("systemCondition").getStringValue();
                String[] aSystemCondition = sSystemCondition.split(" ");
                for (int iIndex = 0; iIndex < aSystemCondition.length; ++iIndex) {
                    if (!cognosViewerBlacklist.isBlacklisted(aSystemCondition[iIndex])) continue;
                    return ToolbarItemStateEnum.itemHidden;
                }
            }
            if (toolbarItem.element("name") != null && cognosViewerBlacklist.isBlacklistedForCWRole(toolbarItem.element("name").getStringValue())) {
                return ToolbarItemStateEnum.itemHidden;
            }
            Attribute aRuleSuffix = toolbarItem.attribute("ruleSuffix");
            String sRuleSuffix = null != aRuleSuffix ? aRuleSuffix.getStringValue() : "";
            Attribute a = toolbarItem.attribute("hasStateRule");
            if (null != a && a.getStringValue().equalsIgnoreCase("no")) {
                return ToolbarItemStateEnum.itemEnabled;
            }
            if (toolbarItem.element("name") != null && (nameNode = toolbarItem.element("name")) != null) {
                try {
                    String sMethod = nameNode.getText() + sRuleSuffix + "Rule";
                    if (!"logOnOffRule".equals(sMethod)) {
                        Method method = this.getClass().getMethod(sMethod, ICognosViewerActionResponse.class);
                        return (ToolbarItemStateEnum)method.invoke((Object)this, actionResponse);
                    }
                }
                catch (Exception exception) {
                    IPFLogger.getInstance().error(exception.toString(), exception, this.getClass().getName());
                    return ToolbarItemStateEnum.itemEnabled;
                }
            }
        }
        return ToolbarItemStateEnum.itemEnabled;
    }

    public void processDynamicElement(ICognosViewerActionResponse actionResponse, Element toolbarItem) {
        Element nameNode;
        if (toolbarItem != null && toolbarItem.element("name") != null && (nameNode = toolbarItem.element("name")) != null) {
            try {
                String sMethod = nameNode.getText() + "Dynamic";
                Method method = this.getClass().getMethod(sMethod, ICognosViewerActionResponse.class, Element.class);
                method.invoke((Object)this, actionResponse, toolbarItem);
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error(exception.toString(), exception, this.getClass().getName());
            }
        }
    }
}

