/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import java.util.LinkedList;
import java.util.List;

public class CAMFactoryPool {
    private static final List<CAMFactory> m_camFactories = new LinkedList<CAMFactory>();

    protected CAMFactoryPool() {
    }

    public static SigningSession createSigningSession() throws CAMCryptoException {
        CAMFactory factory = null;
        try {
            factory = CAMFactoryPool.getFactory();
            SigningSession signingSession = factory.createSigningSession();
            return signingSession;
        }
        finally {
            if (factory != null) {
                CAMFactoryPool.putFactory(factory);
            }
        }
    }

    public static GenericTrustedSession createGenericTrustedSession() throws CAMCryptoException {
        CAMFactory factory = null;
        try {
            factory = CAMFactoryPool.getFactory();
            GenericTrustedSession genericTrustedSession = factory.createGenericTrustedSession();
            return genericTrustedSession;
        }
        finally {
            if (factory != null) {
                CAMFactoryPool.putFactory(factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureStateSession createSecureStateSession(byte[] bytes, byte[] bytes2) throws CAMCryptoException {
        CAMFactory factory = null;
        try {
            factory = CAMFactoryPool.getFactory();
            SecureStateSession secureStateSession = factory.createSecureStateSession(bytes, bytes2);
            return secureStateSession;
        }
        finally {
            if (factory != null) {
                CAMFactoryPool.putFactory(factory);
            }
        }
    }

    public static ReportSpecProtectionSession createReportSpecProtectionSession() throws CAMCryptoException {
        CAMFactory factory = null;
        try {
            factory = CAMFactoryPool.getFactory();
            ReportSpecProtectionSession reportSpecProtectionSession = factory.createReportSpecProtectionSession();
            return reportSpecProtectionSession;
        }
        finally {
            if (factory != null) {
                CAMFactoryPool.putFactory(factory);
            }
        }
    }

    private static synchronized CAMFactory getFactory() throws CAMCryptoException {
        if (m_camFactories.size() == 0) {
            m_camFactories.add(new CAMFactory("RV"));
        }
        return m_camFactories.remove(0);
    }

    private static synchronized void putFactory(CAMFactory factory) {
        m_camFactories.add(factory);
    }

    public static synchronized void setFactory(CAMFactory factory) {
        m_camFactories.add(factory);
    }

    public static void clearFactories() {
        m_camFactories.clear();
    }
}

