/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.pogo.impl.CAFFactoryNoOpImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.CAFFactory;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.expeditor.CognosViewerExpeditorDispatcherHandler;
import com.cognos.viewer.controller.expeditor.DelayedOutput;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.Protect;
import com.cognos.xts.ext.XTSExt;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DebugLogger {
    public static final int TRACE_ERROR = 1;
    public static final int TRACE_WARNING = 2;
    public static final int TRACE_INFO = 3;
    private static final String DEFAULT_TRACE_DIR = "../temp/viewer";
    public static final String DEBUG_DIRECTORY_PARAM = "cv.debugDirectory";
    private static final String TRACE_LOG = "trace.log";
    private static final String LOG_VIEWER_COOKIE = "viewerLogs";
    private static final String LOG_REPORT_HTML_COOKIE = "reportHtml";
    private static final String LOG_INTERMEDIATE_XML = "returnIntermediateXML";
    private static final String CAPTURE_CLIENT_LOGS_COOKIE = "captureViewerClientLogs";
    private static final String CAUSE_FAULT_COOKIE = "throwFault";
    private static String m_sRootLocation = "";
    private static boolean m_bTraceEnabled = false;
    private static boolean m_bFragmentDebug = false;
    private static boolean m_bURLDebugEnabled = false;
    private static boolean m_bPerfDebugging = false;
    private static boolean m_bJsDebugEnabled = false;
    private static boolean m_bMasterTraceLogEnabled = false;
    private static FileOutputStream m_masterTraceOutputStream = null;
    private static int m_iTraceFileCount = 0;
    private static int m_iTraceSizeWritten = 0;
    private static StringBuilder m_sbMasterTraceBuffer = new StringBuilder();
    private int m_iRequestCount = 1;
    private int m_iFileCount = 1;
    private String m_sRunLocation = "";
    private String m_sCurrentDirectory = "";
    private String m_sRequestRootDirectory = "";
    private boolean m_bSessionBaseDebugging = false;
    private StringBuffer m_sbTiming = new StringBuffer();
    private StringBuffer m_sbTrace = new StringBuffer();
    private HashMap<String, String[]> m_hmTimings = new HashMap();
    private Stack<String[]> m_aTimingStack = new Stack();
    private boolean m_bGenerateJSONLogs = false;
    private boolean m_bBufferHtmlOutput = false;
    private boolean m_bGetIntermediateXml = false;
    private boolean m_bCaptureClientLogs = false;
    private StringBuilder m_sbJSONTime = new StringBuilder();
    private StringBuilder m_jsonLogs = new StringBuilder();
    private int m_jsonArrayLevel = 0;
    private static DateFormat m_dateFormat = new SimpleDateFormat("HH:mm:ss");

    public static void initialize() {
        m_bURLDebugEnabled = CognosViewerDispatcherHandler.getConfigValues().getBoolean("enableURLDebug");
        m_bTraceEnabled = CognosViewerDispatcherHandler.getConfigValues().getBoolean("debug");
        m_bMasterTraceLogEnabled = CognosViewerDispatcherHandler.getConfigValues().getBoolean("trace");
        m_bPerfDebugging = CognosViewerDispatcherHandler.getConfigValues().getBoolean("perfDebug");
        if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("masters")) {
            CognosViewerDispatcherHandler.getConfigValues().setProperty("ViewerPrimaryWaitThreshold", "0");
            m_bTraceEnabled = true;
            Protect.setCAFFactory((CAFFactory)new CAFFactoryNoOpImpl());
        }
        if (CognosViewerDispatcherHandler.getConfigValues().getProperty("debugDirectory") != null && CognosViewerDispatcherHandler.getConfigValues().getProperty("debugDirectory").length() > 0) {
            m_sRootLocation = CognosViewerDispatcherHandler.getConfigValues().getProperty("debugDirectory");
            if (m_sRootLocation.endsWith("/")) {
                m_sRootLocation = m_sRootLocation.substring(0, m_sRootLocation.length() - 1);
            }
        } else {
            m_sRootLocation = CCLConfigurationFactory.getInstance().resolveEffectivePath(DEFAULT_TRACE_DIR);
        }
        if (m_bMasterTraceLogEnabled || DebugLogger.isDebugEnabledForAllUsers()) {
            DebugLogger.setupMasterTraceHandler(TRACE_LOG);
        }
    }

    public DebugLogger(BIBusEnvelope busEnvelope) {
        try {
            if (busEnvelope != null) {
                if (!CognosViewerDispatcherHandlerState.isMasters() && "true".equals(busEnvelope.getCookieValue(LOG_VIEWER_COOKIE))) {
                    this.m_bGenerateJSONLogs = true;
                    if ("true".equals(busEnvelope.getCookieValue(LOG_REPORT_HTML_COOKIE))) {
                        this.m_bBufferHtmlOutput = true;
                    }
                    if ("true".equals(busEnvelope.getCookieValue(LOG_INTERMEDIATE_XML))) {
                        this.m_bGetIntermediateXml = true;
                    }
                    if ("true".equals(busEnvelope.getCookieValue(CAPTURE_CLIENT_LOGS_COOKIE))) {
                        this.m_bCaptureClientLogs = true;
                    }
                }
                if (busEnvelope.getFormValue("cv.debugjs") != null) {
                    DebugLogger.setJsDebugEnabled("true".equals(busEnvelope.getFormValue("cv.debugjs")));
                }
                if (m_bURLDebugEnabled) {
                    if (busEnvelope.getFormValue("cv.debug") != null) {
                        DebugLogger.setDebugEnabled("true".equals(busEnvelope.getFormValue("cv.debug")));
                    } else if (busEnvelope.getFormValue("cv.masters") != null) {
                        DebugLogger.setDebugEnabled("true".equals(busEnvelope.getFormValue("cv.masters")));
                        if ("true".equals(busEnvelope.getFormValue("cv.masters"))) {
                            Protect.setCAFFactory((CAFFactory)new CAFFactoryNoOpImpl());
                            CognosViewerDispatcherHandler.getConfigValues().setProperty("ViewerPrimaryWaitThreshold", "0");
                        } else {
                            Protect.setCAFFactory((CAFFactory)Class.forName("com.cognos.caf.CAFFirewall").newInstance());
                            CognosViewerDispatcherHandler.getConfigValues().remove("ViewerPrimaryWaitThreshold");
                        }
                    } else if (busEnvelope.getFormValue("cv.sessionDebug") != null) {
                        this.m_bSessionBaseDebugging = "true".equals(busEnvelope.getFormValue("cv.sessionDebug"));
                    } else if (busEnvelope.getFormValue("cv.perfDebug") != null) {
                        m_bPerfDebugging = "true".equals(busEnvelope.getFormValue("cv.perfDebug"));
                    } else if (busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM) != null && !this.m_bGenerateJSONLogs) {
                        boolean bl = this.m_bSessionBaseDebugging = !"".equals(busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM));
                    }
                }
                if (this.isDebugEnabled()) {
                    this.setRunLocation(busEnvelope);
                }
                if (m_bURLDebugEnabled && busEnvelope.getFormValue("fragment.debug") != null) {
                    DebugLogger.setFragmentDebug("true".equals(busEnvelope.getFormValue("fragment.debug")));
                }
            }
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    public boolean shouldBufferReportHtml() {
        return this.isWriteToFileSystem() || this.m_bGetIntermediateXml || this.m_bBufferHtmlOutput;
    }

    public void setGenerateJSONLogs(boolean generate) {
        this.m_bGenerateJSONLogs = generate;
    }

    public boolean isJsonLoggingOn() {
        return this.m_bGenerateJSONLogs;
    }

    public static void setRootDirectory(String rootDirectory) {
        m_sRootLocation = rootDirectory;
    }

    private static synchronized void setFragmentDebug(boolean bFragmentDebug) {
        m_bFragmentDebug = bFragmentDebug;
    }

    public boolean causeDebugFault(CognosViewerDispatcherHandlerState state) {
        BIBusEnvelope busEnvelope = state.getBusEnvelope();
        if ("true".equals(busEnvelope.getCookieValue(CAUSE_FAULT_COOKIE))) {
            return true;
        }
        return this.getURLDebugEnabled() && "true".equals(state.getFormFieldAsString("cv.generateFault"));
    }

    public boolean isFragmentDebugEnabled() {
        return m_bTraceEnabled || m_bFragmentDebug;
    }

    public boolean getURLDebugEnabled() {
        return m_bURLDebugEnabled;
    }

    private String getDebugLocation() {
        return this.m_sRunLocation;
    }

    private static synchronized void setDebugEnabled(boolean bDebugEnabled) {
        m_bTraceEnabled = bDebugEnabled;
    }

    private static synchronized void setJsDebugEnabled(boolean bDebugEnabled) {
        m_bJsDebugEnabled = bDebugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.isWriteToFileSystem() || this.m_bGenerateJSONLogs;
    }

    public boolean isJsDebugEnabled() {
        return m_bJsDebugEnabled;
    }

    public boolean shouldGenerateIntermediateXml() {
        return this.m_bGetIntermediateXml;
    }

    public boolean isWriteToFileSystem() {
        return m_bTraceEnabled || this.m_bSessionBaseDebugging || m_bPerfDebugging;
    }

    public static boolean isDebugEnabledForAllUsers() {
        return m_bTraceEnabled || m_bPerfDebugging;
    }

    public static String getBaseDebugDirectory(BIBusEnvelope busEnvelope) {
        String sDebugDirectory = "";
        if (busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM) != null) {
            sDebugDirectory = busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM);
        } else {
            sDebugDirectory = String.valueOf(System.currentTimeMillis()) + "_" + String.valueOf(System.identityHashCode(Thread.currentThread()));
            busEnvelope.setFormField(DEBUG_DIRECTORY_PARAM, sDebugDirectory);
        }
        return sDebugDirectory;
    }

    public synchronized void setRunLocation(BIBusEnvelope busEnvelope) {
        this.startTimedEvent("VIEWER", "Time spent in the Viewer", "VIEWER");
        String sDebugDirectory = DebugLogger.getBaseDebugDirectory(busEnvelope);
        try {
            File path;
            this.m_sRequestRootDirectory = this.m_sRunLocation = m_sRootLocation + "/" + sDebugDirectory;
            if (this.isWriteToFileSystem() && !(path = new File(this.m_sRunLocation)).exists()) {
                path.mkdirs();
            }
            this.createActionDirectory(busEnvelope);
            this.initJsonLogs(busEnvelope);
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    public void initJsonLogs(BIBusEnvelope busEnvelope) {
        if (this.m_bGenerateJSONLogs) {
            this.m_jsonLogs.append("{\"id\":\"");
            String directory = busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM);
            if (directory != null) {
                this.m_jsonLogs.append(XTSExt.javascriptencode((String)busEnvelope.getFormValue(DEBUG_DIRECTORY_PARAM)));
            }
            this.m_jsonLogs.append("\",\"label\":\"Report Session\"");
            this.m_jsonLogs.append(",\"children\":[");
            ++this.m_jsonArrayLevel;
            String uiAction = this.getUiAction(busEnvelope);
            String sActionDirectory = String.valueOf(System.currentTimeMillis()) + String.valueOf(System.identityHashCode(Thread.currentThread())) + "_" + uiAction;
            this.m_jsonLogs.append("{\"id\":\"");
            this.m_jsonLogs.append(XTSExt.javascriptencode((String)sActionDirectory));
            this.m_jsonLogs.append("\",\"label\":\"");
            this.m_jsonLogs.append(XTSExt.javascriptencode((String)uiAction));
            this.m_jsonLogs.append("\",\"children\":[");
            ++this.m_jsonArrayLevel;
        }
    }

    private String getUiAction(BIBusEnvelope busEnvelope) {
        if (busEnvelope.getFormValue("cv.outputKey") != null) {
            return "getCachedOutput";
        }
        String uiAction = busEnvelope.getFormValue("ui.action");
        if (uiAction == null) {
            uiAction = "unknown";
        }
        return uiAction;
    }

    private synchronized void createActionDirectory(BIBusEnvelope busEnvelope) {
        try {
            String uiAction = this.getUiAction(busEnvelope);
            String sActionFormField = "";
            if (busEnvelope.getFormValue("b_action") != null) {
                sActionFormField = busEnvelope.getFormValue("b_action") + "_";
            }
            String sAction = sActionFormField + uiAction;
            if (this.isWriteToFileSystem()) {
                int directoryCount = new File(this.m_sRunLocation).list().length;
                if (directoryCount > 0) {
                    --directoryCount;
                }
                String requestCount = String.valueOf(directoryCount) + "-" + sAction;
                this.m_sRunLocation = this.m_sRunLocation + "/" + requestCount;
                File path = new File(this.m_sRunLocation);
                path.mkdirs();
            }
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    private synchronized void changeOutputFolder(String sFolderPrefix) {
        try {
            this.m_iFileCount = 1;
            ++this.m_iRequestCount;
            this.m_sCurrentDirectory = String.valueOf(this.m_iRequestCount) + " - " + sFolderPrefix;
            if (this.isWriteToFileSystem()) {
                File path = new File(this.m_sRunLocation + "/" + this.m_sCurrentDirectory);
                path.mkdirs();
            }
            if (this.m_bGenerateJSONLogs) {
                if (this.m_iRequestCount > 2) {
                    --this.m_jsonArrayLevel;
                    this.m_jsonLogs.append("]},");
                }
                this.m_jsonLogs.append("{\"id\":\"");
                this.m_jsonLogs.append(XTSExt.javascriptencode((String)(this.m_sCurrentDirectory + String.valueOf(System.currentTimeMillis()) + String.valueOf(System.identityHashCode(Thread.currentThread())))));
                this.m_jsonLogs.append("\",\"label\":\"");
                this.m_jsonLogs.append(this.m_sCurrentDirectory);
                this.m_jsonLogs.append("\",\"children\":[");
                ++this.m_jsonArrayLevel;
            }
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    public void log(BIBusEnvelope busEnvelope, String sFileName, boolean bNewFolder, String sFolderPrefix) {
        if (this.isDebugEnabled() && busEnvelope != null) {
            try {
                if (bNewFolder) {
                    this.changeOutputFolder(sFolderPrefix);
                }
                Document doc = busEnvelope.getAsDocument();
                this.write(sFileName, null, doc);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public void logXML(String xml, String sFileName, boolean bNewFolder, String sFolderPrefix) {
        if (this.isDebugEnabled()) {
            try {
                if (bNewFolder) {
                    this.changeOutputFolder(sFolderPrefix);
                }
                Document doc = DocumentHelper.parseText((String)xml);
                this.write(sFileName, null, doc);
            }
            catch (DocumentException e) {
                this.log(xml.getBytes(), sFileName, false, sFolderPrefix);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public static void logXML(String xml, String sFileName, String sFolderName) {
        if (DebugLogger.isDebugEnabledForAllUsers()) {
            try {
                Document doc = DocumentHelper.parseText((String)xml);
                DebugLogger.writeToFile(m_sRootLocation + "/" + sFolderName, sFileName, null, doc);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public void log(byte[] output, String sFileName, boolean bNewFolder, String sFolderPrefix) {
        if (this.isDebugEnabled()) {
            try {
                if (bNewFolder) {
                    this.changeOutputFolder(sFolderPrefix);
                }
                this.write(sFileName, output, null);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public void log(ByteArrayOutputStream output, String sFileName, boolean bNewFolder, String sFolderPrefix) {
        if (this.isDebugEnabled()) {
            try {
                if (bNewFolder) {
                    this.changeOutputFolder(sFolderPrefix);
                }
                this.write(sFileName, output.toByteArray(), null);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    private void logTime(String sContext) {
        if (this.isDebugEnabled()) {
            try {
                this.m_sbTiming.append("<event ");
                this.m_sbTiming.append(" date=\"" + new java.text.SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SS").format(new Date()) + "\"");
                this.m_sbTiming.append(">" + EncodingUtility.xmlencode(sContext) + "</event>");
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public void startTimedEvent(String sKey, String sContext, String sId) {
        if (this.isDebugEnabled()) {
            String[] asHashValue = new String[]{Long.toString(System.currentTimeMillis()), sContext, sId};
            this.m_hmTimings.put(sKey, asHashValue);
            if (this.m_aTimingStack.size() > 0) {
                this.endTimedEvent(((String[])this.m_aTimingStack.get(this.m_aTimingStack.size() - 1))[0], false);
            }
            this.m_aTimingStack.add(new String[]{sKey, sContext, sId});
        }
    }

    public void endTimedEvent(String sKey) {
        this.endTimedEvent(sKey, true);
    }

    public void endTimedEvent(String sKey, boolean bStartPreviousEvent) {
        if (this.isDebugEnabled()) {
            if (this.m_hmTimings.containsKey(sKey)) {
                String[] asHashValue = this.m_hmTimings.get(sKey);
                this.m_hmTimings.remove(sKey);
                long currentTime = System.currentTimeMillis();
                Long elapsedTime = currentTime - Long.valueOf(asHashValue[0]);
                if (this.isWriteToFileSystem()) {
                    this.m_sbTiming.append("<event ");
                    this.m_sbTiming.append(" elapsedTime=\"" + elapsedTime + "\"");
                    this.m_sbTiming.append(">" + EncodingUtility.xmlencode(asHashValue[1]) + "</event>");
                } else if (this.isJsonLoggingOn()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"description", (Object)asHashValue[1]);
                    jsonObject.put((Object)"elapsedTime", (Object)elapsedTime);
                    jsonObject.put((Object)"startTime", (Object)asHashValue[0]);
                    jsonObject.put((Object)"endTime", (Object)Long.toString(currentTime));
                    jsonObject.put((Object)"id", (Object)asHashValue[2]);
                    if (this.m_sbJSONTime.length() > 0) {
                        this.m_sbJSONTime.append(",");
                    }
                    this.m_sbJSONTime.append(jsonObject.toString());
                }
            }
            if (bStartPreviousEvent && this.m_aTimingStack.size() > 0) {
                this.m_aTimingStack.pop();
                if (this.m_aTimingStack.size() > 0) {
                    String[] timingInfo = this.m_aTimingStack.pop();
                    this.startTimedEvent(timingInfo[0], timingInfo[1], timingInfo[2]);
                }
            }
        }
    }

    public synchronized void writeTimingLog() {
        if (this.isWriteToFileSystem()) {
            try {
                this.m_sbTiming.insert(0, "<timing request=\"" + EncodingUtility.encodeXMLAttribute(this.m_sRunLocation) + "\">");
                this.m_sbTiming.append("</timing>");
                File logFile = new File(this.m_sRunLocation, "timing.xml");
                logFile.createNewFile();
                String filePath = new StringBuffer().append(this.m_sRunLocation).append(File.separator).append("timing.xml").toString();
                FileOutputStream fos = new FileOutputStream(filePath, true);
                fos.write(this.m_sbTiming.toString().getBytes("UTF-8"));
                fos.flush();
                fos.close();
                File masterLogFile = new File(this.m_sRequestRootDirectory, "timing.xml");
                masterLogFile.createNewFile();
                String masterTimingPath = new StringBuffer().append(this.m_sRequestRootDirectory).append(File.separator).append("timing.xml").toString();
                fos = new FileOutputStream(masterTimingPath, true);
                fos.write(this.m_sbTiming.toString().getBytes("UTF-8"));
                fos.flush();
                fos.close();
                this.m_sbTiming = new StringBuffer();
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    private synchronized void write(String sFileName, byte[] content, Document document) {
        ++this.m_iFileCount;
        if (this.isWriteToFileSystem()) {
            String fileName = sFileName;
            try {
                String sFullPath = this.m_sRunLocation + "/" + this.m_sCurrentDirectory;
                this.logTime("Logged " + sFullPath + "/" + fileName);
                DebugLogger.writeToFile(sFullPath, fileName, content, document);
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
        if (this.m_bGenerateJSONLogs) {
            if (this.m_iFileCount > 2) {
                this.m_jsonLogs.append(",");
            }
            this.m_jsonLogs.append("{\"id\":\"");
            this.m_jsonLogs.append(XTSExt.javascriptencode((String)(sFileName + String.valueOf(System.currentTimeMillis()))));
            this.m_jsonLogs.append("\",\"label\":\"");
            this.m_jsonLogs.append(XTSExt.javascriptencode((String)sFileName));
            this.m_jsonLogs.append("\",\"content\" : \"");
            if (document != null) {
                try {
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
                    writer.write(document);
                    writer.flush();
                    writer.close();
                    this.m_jsonLogs.append(XTSExt.javascriptencode((String)new String(outputStream.toByteArray())));
                }
                catch (Exception e) {
                    this.m_jsonLogs.append(XTSExt.javascriptencode((String)document.asXML()));
                }
            } else {
                this.m_jsonLogs.append(XTSExt.javascriptencode((String)new String(content)));
            }
            this.m_jsonLogs.append("\"}");
        }
    }

    public static void writeToFile(String sPath, String sFileName, byte[] content, Document document) {
        try {
            File logFile;
            File path = new File(sPath);
            path.mkdirs();
            if (sFileName.length() == 0) {
                sFileName = String.valueOf(System.currentTimeMillis());
            }
            if ((logFile = new File(path, sFileName)).exists()) {
                logFile.delete();
            }
            logFile.createNewFile();
            String filePath = new StringBuffer().append(path).append(File.separator).append(sFileName).toString();
            FileOutputStream fos = new FileOutputStream(filePath, true);
            if (document != null) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((OutputStream)fos, format);
                writer.write(document);
                writer.flush();
                writer.close();
            } else {
                fos.write(content);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    public void cleanDebugLogs(String sStatus) {
        if (m_bPerfDebugging && !sStatus.equals("working") && !sStatus.equals("stillWorking")) {
            this.deleteDebugLogs();
        }
    }

    public void deleteDebugLogs() {
        try {
            File path = new File(this.getDebugLocation());
            DebugLogger.deleteDir(path.getParentFile());
        }
        catch (Exception e) {
            IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean bSuccess = DebugLogger.deleteDir(new File(dir, children[i]));
                if (bSuccess) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean hasJsonLogs() {
        return this.m_jsonLogs.length() > 0;
    }

    public StringBuilder getLogsAsJSON(BIBusEnvelope busEnvelope) {
        if (this.m_sbJSONTime.length() > 0) {
            this.m_jsonLogs.append("]}");
            --this.m_jsonArrayLevel;
            boolean oriValue = this.m_bGenerateJSONLogs;
            this.m_bGenerateJSONLogs = true;
            this.write("timing.log", ("[" + this.m_sbJSONTime + "]").getBytes(), null);
            this.m_bGenerateJSONLogs = oriValue;
        }
        while (this.m_jsonArrayLevel > 0) {
            --this.m_jsonArrayLevel;
            this.m_jsonLogs.append("]}");
        }
        return this.m_jsonLogs;
    }

    public void clearJsonLogs(BIBusEnvelope busEnvelope) {
        this.m_jsonLogs = new StringBuilder();
        this.m_sbJSONTime = new StringBuilder();
        this.m_iFileCount = 1;
        this.m_iRequestCount = 1;
    }

    public void log(String tracemsg) {
        if (this.isDebugEnabled()) {
            this.m_sbTrace.append(tracemsg);
        }
        DebugLogger.logTrace(tracemsg);
    }

    public synchronized void writeTraceLog() {
        if (this.isWriteToFileSystem()) {
            try {
                File logFile = new File(this.m_sRunLocation, TRACE_LOG);
                logFile.createNewFile();
                String filePath = new StringBuffer().append(this.m_sRunLocation).append(File.separator).append(TRACE_LOG).toString();
                FileOutputStream fos = new FileOutputStream(filePath, true);
                fos.write(this.m_sbTrace.toString().getBytes("UTF-8"));
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                IPFLogger.getInstance().warn(e.getMessage(), DebugLogger.class.getName());
            }
        }
    }

    public String getTrace() {
        return this.m_sbTrace.toString();
    }

    private static void setupMasterTraceHandler(String fileName) {
        try {
            File path = new File(m_sRootLocation);
            if (!path.exists()) {
                path.mkdirs();
            }
            File logFile = new File(m_sRootLocation, fileName);
            logFile.createNewFile();
            String filePath = new StringBuffer().append(m_sRootLocation).append(File.separator).append(fileName).toString();
            m_masterTraceOutputStream = new FileOutputStream(filePath, true);
        }
        catch (Exception e) {
            m_masterTraceOutputStream = null;
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return (m_bMasterTraceLogEnabled || DebugLogger.isDebugEnabledForAllUsers()) && m_masterTraceOutputStream != null;
    }

    public static void logTrace(String tracemsg) {
        if (DebugLogger.isTraceEnabled()) {
            DebugLogger.writeToMasterTraceFile(tracemsg);
        }
    }

    public static void logTrace(String tracemsg, int traceType) {
        if (DebugLogger.isTraceEnabled()) {
            if (traceType == 1) {
                DebugLogger.writeToMasterTraceFile("VIEWER ERROR " + tracemsg);
            } else if (traceType == 2) {
                DebugLogger.writeToMasterTraceFile("VIEWER WARNING " + tracemsg);
            } else if (traceType == 3) {
                DebugLogger.writeToMasterTraceFile("VIEWER INFO " + tracemsg);
            } else {
                DebugLogger.writeToMasterTraceFile(tracemsg);
            }
        }
    }

    public static void logTrace(String tracemsg, String appendToString) {
        if (DebugLogger.isTraceEnabled()) {
            DebugLogger.writeToMasterTraceFile(tracemsg + appendToString);
        }
    }

    public static void logTrace(String tracemsg, String appendToString, int traceType) {
        if (DebugLogger.isTraceEnabled()) {
            DebugLogger.logTrace(tracemsg + appendToString, traceType);
        }
    }

    public static void logTraceDelayedOutput(DelayedOutput delayedOutput) {
        if (DebugLogger.isTraceEnabled() && delayedOutput != null) {
            StringBuilder sbDelayedOutputInfo = new StringBuilder("delayedOutput info ");
            sbDelayedOutputInfo.append("object id: " + Integer.toString(delayedOutput.hashCode()));
            sbDelayedOutputInfo.append(" ");
            sbDelayedOutputInfo.append("key: " + delayedOutput.getKey());
            sbDelayedOutputInfo.append(" ");
            sbDelayedOutputInfo.append("saving cache info: " + Boolean.toString(delayedOutput.isGetDelayedOutput()));
            sbDelayedOutputInfo.append(" ");
            sbDelayedOutputInfo.append("status: " + delayedOutput.getStatus());
            DebugLogger.logTrace(sbDelayedOutputInfo.toString());
        }
    }

    public static void logTraceException(Exception exception, BIBusEnvelope biBusEnvelope) {
        if (DebugLogger.isTraceEnabled() && !(exception instanceof CognosViewerExpeditorDispatcherHandler.StopExecutionCognosViewerException)) {
            try {
                StringBuilder sbFault = new StringBuilder(" ");
                try {
                    sbFault.append(ExceptionUtils.getStackTrace((Throwable)exception));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                    sbFault.append(exception.getMessage());
                    sbFault.append(System.getProperty("line.separator"));
                }
                if (exception instanceof CognosViewerException) {
                    CognosViewerException cognosViewerException = (CognosViewerException)exception;
                    if (cognosViewerException.getFailureDetail() != null && cognosViewerException.getFailureDetail().length() > 0) {
                        sbFault.append(cognosViewerException.getFailureDetail());
                        sbFault.append(System.getProperty("line.separator"));
                    }
                    if (cognosViewerException.getFaultEnvelope() != null) {
                        sbFault.append(cognosViewerException.getFaultEnvelope().getBody().asXML());
                        sbFault.append(System.getProperty("line.separator"));
                    }
                }
                sbFault.append(exception.toString());
                sbFault.append(System.getProperty("line.separator"));
                if (biBusEnvelope != null) {
                    sbFault.append("Initial SOAP envelope");
                    sbFault.append(System.getProperty("line.separator"));
                    try {
                        sbFault.append(biBusEnvelope.getAsString());
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (exception instanceof DelayedOutput.ThreadLockCognosViewerException) {
                    DebugLogger.logTrace(sbFault.toString(), 2);
                } else {
                    DebugLogger.logTrace(sbFault.toString(), 1);
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
    }

    private static synchronized void writeToMasterTraceFile(String tracemsg) {
        try {
            long threadId = Thread.currentThread().getId();
            m_sbMasterTraceBuffer.append(Long.toString(threadId));
            m_sbMasterTraceBuffer.append(" ");
            m_sbMasterTraceBuffer.append(Long.toString(System.currentTimeMillis()));
            m_sbMasterTraceBuffer.append(" ");
            m_sbMasterTraceBuffer.append(tracemsg);
            m_sbMasterTraceBuffer.append(System.getProperty("line.separator"));
            if (m_sbMasterTraceBuffer.length() > 5000) {
                m_masterTraceOutputStream.write(m_sbMasterTraceBuffer.toString().getBytes("UTF-8"));
                m_masterTraceOutputStream.flush();
                if ((m_iTraceSizeWritten += m_sbMasterTraceBuffer.length()) > 10000000) {
                    m_iTraceSizeWritten = 0;
                    m_masterTraceOutputStream.close();
                    DebugLogger.setupMasterTraceHandler("trace" + Integer.toString(++m_iTraceFileCount) + ".log");
                }
                m_sbMasterTraceBuffer.setLength(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeTraceOutputStream() {
        try {
            if (m_masterTraceOutputStream != null) {
                m_masterTraceOutputStream.write(m_sbMasterTraceBuffer.toString().getBytes("UTF-8"));
                m_masterTraceOutputStream.flush();
                m_masterTraceOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

