/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.URLEncoderDecoder;
import com.cognos.viewer.utility.base64;
import com.cognos.xts.ext.XTSExt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class EncodingUtility {
    public static String web64encodeObject(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        return base64.encode(1, baos.toByteArray());
    }

    public static String web64decodeObject(String sEncodedString) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(base64.decode(1, sEncodedString));
        ObjectInputStream oin = new ObjectInputStream(byteArrayInputStream);
        return (String)oin.readObject();
    }

    public static String urldecode(String sValue) {
        try {
            return URLDecoder.decode(sValue, "UTF-8");
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getMessage(), exception, EncodingUtility.class.getName());
            return sValue;
        }
    }

    public static String urlencode(String sValue) {
        try {
            return XTSExt.urlencode((String)sValue);
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getMessage(), exception, EncodingUtility.class.getName());
            return sValue;
        }
    }

    public static String xmlencode(String value) {
        if (value != null) {
            return XTSExt.xmlencode((String)value);
        }
        return "";
    }

    public static String encodeXMLAttribute(String value) {
        return value.replace("&", "&amp;").replace("\"", "&quot;");
    }

    public static String htmlencode(String value) {
        if (value != null) {
            return XTSExt.htmlencode((String)value);
        }
        return "";
    }

    public static String decodeCCSessionValue(String value) {
        return EncodingUtility.urldecode(XTSExt.replace((String)XTSExt.replace((String)value, (String)"*", (String)"%"), (String)"%%", (String)"*"));
    }

    public static String encodeCCSessionValue(String value) throws UnsupportedEncodingException {
        return XTSExt.replace((String)URLEncoderDecoder.encode(value, "UTF-8", false), (String)"*", (String)"%%", (boolean)false).replace('%', '*');
    }
}

