/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.model.fragments.FragmentState;
import com.cognos.viewer.utility.StreamUtility;
import com.cognos.viewer.utility.UrlType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FragmentInputStreamReader
extends InputStreamReader {
    private static final Pattern LINK_AND_SCRIPT_PATTERN = Pattern.compile("(<link[^>]*>)|(<script[^>]*src=\"([^\"]*)\"[^>]*>)|(\\/\\/<\\!\\[CDATA\\[)|(\\/\\/\\]\\]>)", 10);
    private static final Pattern HREF_PATTERN = Pattern.compile("(?:href\\s*=\\s*)(\"|')([^(\"|')]*?)(\"|')", 10);
    private static final Pattern SRC_PATTERN = Pattern.compile("(?:src\\s*=\\s*)(\"|')([^(\"|')]*?)(\"|')", 10);
    private static final int READ_AHEAD_LENGTH = 512;
    private FragmentState m_fragmentState;
    private StringBuilder m_internalBuffer;
    private StringBuffer m_regexResultBuffer;
    private int m_readAheadLength = 512;
    private char[] m_readAheadBuffer;

    public FragmentInputStreamReader(InputStream inputStream, FragmentState fragmentState) throws IOException {
        super(inputStream, "UTF-8");
        this.m_fragmentState = fragmentState;
        if (CognosViewerDispatcherHandler.getConfigValues().containsKey("fragmentBufferSize")) {
            try {
                this.m_readAheadLength = Integer.parseInt(CognosViewerDispatcherHandler.getConfigValues().getProperty("fragmentBufferSize"));
                if (this.m_readAheadLength <= 0) {
                    this.m_readAheadLength = 512;
                }
            }
            catch (NumberFormatException e) {
                this.m_readAheadLength = 512;
            }
        }
        this.m_readAheadBuffer = new char[this.m_readAheadLength];
        this.m_internalBuffer = new StringBuilder(StreamUtility.BUFFER_SIZE + this.m_readAheadLength);
        this.m_regexResultBuffer = new StringBuffer(StreamUtility.BUFFER_SIZE + this.m_readAheadLength);
    }

    @Override
    public int read(char[] c) throws IOException {
        int charCount = super.read(c);
        if (charCount == -1) {
            if (this.m_internalBuffer.length() == 0) {
                return charCount;
            }
            int length = this.m_internalBuffer.length();
            if (length > c.length) {
                System.arraycopy(this.m_internalBuffer.toString().toCharArray(), 0, c, 0, c.length);
                this.m_internalBuffer.delete(0, c.length);
                return c.length;
            }
            System.arraycopy(this.m_internalBuffer.toString().toCharArray(), 0, c, 0, length);
            this.m_internalBuffer.setLength(0);
            return length;
        }
        this.m_internalBuffer.append(c, 0, charCount);
        FragmentInputStreamReader.fragmentizeBuffer(this.m_internalBuffer, this.m_regexResultBuffer, this.m_fragmentState);
        int bufferLength = this.m_internalBuffer.length();
        charCount = bufferLength >= c.length + this.m_readAheadLength ? c.length : (bufferLength < this.m_readAheadLength ? 0 : ((bufferLength -= this.m_readAheadLength) > c.length ? c.length : bufferLength));
        System.arraycopy(this.m_internalBuffer.toString().toCharArray(), 0, c, 0, charCount);
        this.m_internalBuffer.delete(0, charCount);
        if (this.m_internalBuffer.length() < this.m_readAheadLength) {
            this.readAhead();
        }
        return charCount;
    }

    private void readAhead() throws IOException {
        int count = 0;
        while (this.m_internalBuffer.length() < this.m_readAheadLength) {
            count = super.read(this.m_readAheadBuffer);
            if (count <= 0) {
                return;
            }
            this.m_internalBuffer.append(this.m_readAheadBuffer, 0, count);
            FragmentInputStreamReader.fragmentizeBuffer(this.m_internalBuffer, this.m_regexResultBuffer, this.m_fragmentState);
        }
    }

    public static void fragmentizeBuffer(StringBuilder internalBuffer, StringBuffer regexResultBuffer, FragmentState fragmentState) {
        regexResultBuffer.setLength(0);
        boolean foundMatch = false;
        Matcher linkAndScrtiptMatcher = LINK_AND_SCRIPT_PATTERN.matcher(internalBuffer);
        while (linkAndScrtiptMatcher.find()) {
            foundMatch = true;
            if (linkAndScrtiptMatcher.group(2) != null) {
                Matcher srcMatcher = SRC_PATTERN.matcher(linkAndScrtiptMatcher.group());
                while (srcMatcher.find()) {
                    fragmentState.addScriptHref(srcMatcher.group());
                }
                linkAndScrtiptMatcher.appendReplacement(regexResultBuffer, linkAndScrtiptMatcher.group());
                continue;
            }
            if (linkAndScrtiptMatcher.group(1) != null) {
                Matcher hrefMatcher = HREF_PATTERN.matcher(linkAndScrtiptMatcher.group());
                while (hrefMatcher.find()) {
                    fragmentState.addLinkTag(new UrlType("dynamic", hrefMatcher.group()));
                }
            }
            linkAndScrtiptMatcher.appendReplacement(regexResultBuffer, "");
        }
        if (foundMatch) {
            linkAndScrtiptMatcher.appendTail(regexResultBuffer);
            internalBuffer.setLength(0);
            internalBuffer.append(regexResultBuffer);
        }
    }

    public static void fragmentizeBuffer(StringBuilder internalBuffer, FragmentState fragmentState) {
        FragmentInputStreamReader.fragmentizeBuffer(internalBuffer, new StringBuffer(internalBuffer.length()), fragmentState);
    }
}

