/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.EncodingUtility;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class FragmentUtility {
    public static boolean isCCMode(BIBusEnvelope biBusEnvelope) {
        return "cognos".equals(biBusEnvelope.getFormValue("frag-portalAgent"));
    }

    public static boolean isPageRefresh(BIBusEnvelope biBusEnvelope) {
        return "name=fragment.refresh".equals(biBusEnvelope.getFormValue("frag-event"));
    }

    public static boolean hasConfigurationChanged(BIBusEnvelope biBusEnvelope) {
        return "name=fragment.customization.changed".equals(biBusEnvelope.getFormValue("frag-event"));
    }

    public static void saveInitialParameterParams(ICognosViewerState state) {
        BIBusEnvelope biBusEnvelope = state.getBusEnvelope();
        if ("false".equals(biBusEnvelope.getFormValue("cv.fragmentEvent")) && (biBusEnvelope.getFormValue("originalParameters") == null || biBusEnvelope.getFormValue("originalParameters").length() == 0)) {
            StringBuffer sbParameter = new StringBuffer("<originalParameters>");
            List formFieldVars = biBusEnvelope.getFormFieldValues();
            ListIterator iterator = formFieldVars.listIterator();
            while (iterator.hasNext()) {
                NameValuePair formFieldVar = (NameValuePair)iterator.next();
                String formFieldName = formFieldVar.getName();
                String formFieldValue = formFieldVar.getValue();
                if (formFieldValue.length() == 0 || !formFieldName.startsWith("p_")) continue;
                sbParameter.append("<parameter>");
                sbParameter.append("<name>");
                sbParameter.append(EncodingUtility.xmlencode(formFieldName));
                sbParameter.append("</name>");
                sbParameter.append("<value>");
                sbParameter.append(EncodingUtility.xmlencode(formFieldValue));
                sbParameter.append("</value>");
                sbParameter.append("</parameter>");
            }
            sbParameter.append("</originalParameters>");
            biBusEnvelope.setFormField("originalParameters", sbParameter.toString());
        }
    }

    public static void initPortalSessionField(ICognosViewerState state) {
        BIBusEnvelope biBusEnvelope = state.getBusEnvelope();
        if (biBusEnvelope.getFormValue("m_session") != null && biBusEnvelope.getFormValue("m_session").length() > 0) {
            return;
        }
        if (biBusEnvelope.getFormValue("frag-id") == null || biBusEnvelope.getFormValue("frag-id").length() == 0) {
            return;
        }
        if (biBusEnvelope.getFormValue("frag-state") != null && biBusEnvelope.getFormValue("frag-state").length() > 0) {
            FragmentUtility.setPortalSessionField(state, biBusEnvelope.getFormValue("frag-state"));
        }
    }

    public static void setPortalSessionField(ICognosViewerState state, String fragState) {
        BIBusEnvelope biBusEnvelope = null;
        biBusEnvelope = state instanceof ICognosViewerActionResponse ? ((ICognosViewerActionResponse)state).getInitialBusEnvelope() : state.getBusEnvelope();
        if (FragmentUtility.isCCMode(biBusEnvelope) && fragState != null && fragState.length() > 0) {
            StringBuffer sbSession = new StringBuffer(biBusEnvelope.getFormValue("frag-id"));
            sbSession.append(fragState);
            if ("true".equals(biBusEnvelope.getFormValue("fragment.sharePromptValues"))) {
                TreeMap<String, String> sortedMap = new TreeMap<String, String>();
                List formFieldVars = biBusEnvelope.getFormFieldValues();
                ListIterator iterator = formFieldVars.listIterator();
                while (iterator.hasNext()) {
                    NameValuePair formFieldVar = (NameValuePair)iterator.next();
                    if (!formFieldVar.getName().startsWith("p_") || formFieldVar.getName().endsWith("[]") || formFieldVar.getValue() == null || formFieldVar.getValue().length() <= 0) continue;
                    sortedMap.put(formFieldVar.getName(), formFieldVar.getValue());
                }
                Iterator sortedIterator = sortedMap.entrySet().iterator();
                int iIndex = 0;
                while (sortedIterator.hasNext()) {
                    Map.Entry mapEntry = sortedIterator.next();
                    sbSession.append((String)mapEntry.getKey()).append((String)mapEntry.getValue());
                    ++iIndex;
                }
            }
            state.setFormFieldFromString("m_session", "fragCache" + Integer.toString(sbSession.toString().hashCode()));
            biBusEnvelope.setFormField("m_session", "fragCache" + Integer.toString(sbSession.toString().hashCode()));
        }
    }

    public static boolean shouldSaveCache(ICognosViewerState cognosViewerState, String sStatus) {
        String sAction = cognosViewerState.getAction();
        return cognosViewerState.getFormFieldAsString("m_session").length() > 0 && !"cachedOutput".equals(sAction) && !"view".equals(sAction) && "complete".equals(sStatus);
    }

    public static boolean shouldLoadCache(ICognosViewerState cognosViewerState) {
        if (FragmentUtility.hasConfigurationChanged(cognosViewerState.getBusEnvelope())) {
            return false;
        }
        if (FragmentUtility.isPageRefresh(cognosViewerState.getBusEnvelope())) {
            return false;
        }
        if ("true".equals(cognosViewerState.getFormFieldAsString("cv.ignoreState"))) {
            return false;
        }
        if ("view".equals(cognosViewerState.getAction())) {
            return false;
        }
        if (cognosViewerState.getFormFieldAsString("m_session").length() > 0) {
            return true;
        }
        return cognosViewerState.getFormFieldAsString("m_sessionConv").length() > 0;
    }
}

