/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.utility.SharedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPCompressorInputStream
extends InputStream {
    private final InputStream streamToCompress;
    private final GZIPOutputStream gzipOut;
    private final SharedByteArrayOutputStream compressedData;
    private int compressedDataOffset = 0;
    private byte[] readBuf = new byte[16384];
    private boolean finished = false;

    public GZIPCompressorInputStream(InputStream streamToCompress) throws IOException {
        this.streamToCompress = streamToCompress;
        this.compressedData = new SharedByteArrayOutputStream(16384);
        this.gzipOut = new GZIPOutputStream(this.compressedData);
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        int available = this.compressedData.getInternalBufferSize() - this.compressedDataOffset;
        if (available == 0 && this.finished) {
            return -1;
        }
        int updatedOff = off;
        int updatedLen = len;
        if (available < len) {
            System.arraycopy(this.compressedData.getInternalBuffer(), this.compressedDataOffset, b, off, available);
            updatedOff += available;
            updatedLen -= available;
            totalRead += available;
            available = 0;
            this.compressedData.reset();
            this.compressedDataOffset = 0;
            this.loadMoreCompressedData(updatedLen);
            available = this.compressedData.getInternalBufferSize() - this.compressedDataOffset;
            if (available == 0) {
                return totalRead;
            }
        }
        int read = updatedLen < available ? updatedLen : available;
        System.arraycopy(this.compressedData.getInternalBuffer(), this.compressedDataOffset, b, updatedOff, read);
        this.compressedDataOffset += read;
        return totalRead + read;
    }

    private void loadMoreCompressedData(int len) throws IOException {
        int read;
        assert (this.compressedData.getInternalBufferSize() == 0);
        int totalRead = 0;
        while ((read = this.streamToCompress.read(this.readBuf, 0, this.readBuf.length)) > 0) {
            totalRead += read;
            this.gzipOut.write(this.readBuf, 0, read);
            this.gzipOut.flush();
            if (this.compressedData.getInternalBufferSize() - this.compressedDataOffset < len) continue;
        }
        if (read == -1) {
            this.gzipOut.flush();
            this.gzipOut.finish();
            this.finished = true;
        }
    }
}

