/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.TransientSpec;
import com.cognos.viewer.utility.XMLUtility;
import org.dom4j.Document;
import org.dom4j.Element;

public class GlobalViewerTransient {
    private String m_sGlobalViewerTransient = null;
    private Element m_globalTransient = null;
    private boolean m_bMatchParameterNameOnly = false;

    public void setGlobalViewerTransient(String sGlobalViewerTransient) {
        this.m_sGlobalViewerTransient = sGlobalViewerTransient;
    }

    public void setMatchParameterNameOnly(String paramNameOnly) {
        if ("true".equals(paramNameOnly)) {
            this.m_bMatchParameterNameOnly = true;
        }
    }

    public String getGlobalViewerTransient() {
        return this.m_sGlobalViewerTransient;
    }

    public String getParameterValue(String sChannel, String parameterName, TransientSpec transientSpec) {
        String sValue = "";
        if (this.m_sGlobalViewerTransient == null) {
            return sValue;
        }
        if (this.m_globalTransient == null) {
            try {
                this.parseGlobalViewerTransient();
            }
            catch (CognosViewerException e) {
                IPFLogger.getInstance().error(e.getMessage(), e, this.getClass().getName());
                return sValue;
            }
        }
        if (parameterName.startsWith("p_")) {
            parameterName = parameterName.substring(2);
        }
        if ((sValue = this.searchParameterItems(sChannel, parameterName, transientSpec)).length() == 0) {
            sValue = this.searchBurstItems(sChannel, parameterName, transientSpec);
        }
        return sValue;
    }

    private String searchParameterItems(String sChannel, String sParameterName, TransientSpec transientSpec) {
        String sValue = "";
        Element reportParameters = transientSpec.getReportParameters();
        if (reportParameters != null) {
            String delimiter = sParameterName.indexOf("'") == -1 ? "'" : "\"";
            Element reportParameter = (Element)reportParameters.selectSingleNode("./reportParameter[@parameterName = " + delimiter + sParameterName + delimiter + "]");
            if (reportParameter != null) {
                String sModelItem = reportParameter.attributeValue("modelItem");
                if (sModelItem == null || sModelItem.length() == 0) {
                    return "";
                }
                sValue = this.searchGlobalTransientUsingModelItem(sChannel, sModelItem);
                if (sValue.length() == 0) {
                    sValue = this.searchGlobalTransientUsingParamterName(sChannel, sParameterName);
                }
            }
        }
        return sValue;
    }

    private String searchBurstItems(String sChannel, String sBurstName, TransientSpec transientSpec) {
        String sValue = "";
        Element burstParameters = transientSpec.getBurstParameters();
        if (burstParameters != null) {
            String delimiter = sBurstName.indexOf("'") == -1 ? "'" : "\"";
            Element burstItem = (Element)burstParameters.selectSingleNode("./burstItem[@burstName = " + delimiter + sBurstName + delimiter + "]");
            if (burstItem != null) {
                String sModelItem = burstItem.attributeValue("modelItem");
                if (sModelItem == null || sModelItem.length() == 0) {
                    return "";
                }
                sValue = this.searchGlobalTransientUsingModelItem(sChannel, sModelItem);
                if (sValue.length() == 0) {
                    sValue = this.searchGlobalTransientUsingParamterName(sChannel, sBurstName);
                }
            }
        }
        return sValue;
    }

    private String searchGlobalTransientUsingParamterName(String sChannel, String sParameterName) {
        Element matchedParameter = null;
        String delimiter = sParameterName.indexOf("'") == -1 ? "'" : "\"";
        matchedParameter = sChannel != null && sChannel.length() > 0 ? (Element)this.m_globalTransient.selectSingleNode("./parameter[@name=" + delimiter + "PROMPTCHANNEL_" + sChannel + sParameterName + delimiter + " and @channel=" + delimiter + sChannel + delimiter + "]") : (Element)this.m_globalTransient.selectSingleNode("./parameter[@name=" + delimiter + sParameterName + delimiter + "][not(@channel) or @channel='']");
        if (matchedParameter != null) {
            return matchedParameter.getText();
        }
        return "";
    }

    private String searchGlobalTransientUsingModelItem(String sChannel, String sModelItem) {
        String modelItemDelimiter;
        if (this.m_bMatchParameterNameOnly) {
            return "";
        }
        Element matchedParameter = null;
        String string = modelItemDelimiter = sModelItem.indexOf("'") == -1 ? "'" : "\"";
        if (sChannel != null && sChannel.length() > 0) {
            String channelItemDelimiter = sChannel.indexOf("'") == -1 ? "'" : "\"";
            matchedParameter = (Element)this.m_globalTransient.selectSingleNode("./parameter[@modelItem=" + modelItemDelimiter + sModelItem + modelItemDelimiter + " and @channel=" + channelItemDelimiter + sChannel + channelItemDelimiter + "]");
        } else {
            matchedParameter = (Element)this.m_globalTransient.selectSingleNode("./parameter[@modelItem=" + modelItemDelimiter + sModelItem + modelItemDelimiter + "][not(@channel) or @channel='']");
        }
        if (matchedParameter != null) {
            return matchedParameter.getText();
        }
        return "";
    }

    private void parseGlobalViewerTransient() throws CognosViewerException {
        try {
            Document document = XMLUtility.createXMLDocument(this.m_sGlobalViewerTransient);
            this.m_globalTransient = document.getRootElement();
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
    }
}

