/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.DebugLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;

public class IPFLogger {
    private static final int VIEWERVERSION = 3;
    private LogPerfIndication m_overallPerfIndication = null;
    private CCLResourceCounterSet m_overallCntSet = null;
    private LogTypedLogger m_traceLogger = LogTypedLogger.getInstance((String)"Trace.VIEWER.trace", LogTraceIndication.class);
    private DebugLogger m_debugLogger = null;
    private static IPFLogger m_ipfLogger = null;
    protected static final String VIEWERCOMPONENT = "VIEWER";
    private static HashSet<String> ipfLoggableRequests = new HashSet();

    public static IPFLogger getInstance() {
        if (m_ipfLogger == null) {
            m_ipfLogger = new IPFLogger();
        }
        return m_ipfLogger;
    }

    private IPFLogger() {
    }

    public void fatal(String message, String className) {
        this.log("[FATAL] " + className + " - " + message, 50000, className);
    }

    public void fatal(String message, Throwable cause, String className) {
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        if (cause != null) {
            cause.printStackTrace(pwrt);
        }
        this.log("[FATAL] " + className + " - " + message + "\nStacktrace: " + tmp.toString(), 50000, className);
    }

    public void error(String message, String className) {
        this.log("[ERROR] " + className + " - " + message, 40000, className);
    }

    public void error(String message, Throwable cause, String className) {
        BIBusEnvelope responseEnvelope;
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        if (cause != null) {
            cause.printStackTrace(pwrt);
        }
        StringBuffer tracemsg = new StringBuffer();
        tracemsg.append("[ERROR] ").append(className).append(" - ").append(message);
        if (cause instanceof CognosViewerException && (responseEnvelope = ((CognosViewerException)cause).getFaultEnvelope()) != null && responseEnvelope.getFault() != null) {
            tracemsg.append("\n").append(responseEnvelope.getFaultDetail().asXML());
        }
        tracemsg.append("\nStacktrace: ").append(tmp.toString());
        this.log(tracemsg.toString(), 40000, className);
    }

    public void warn(String message, String className) {
        this.log("[WARN] " + className + " - " + message, 30000, className);
    }

    public void info(String message, String className) {
        this.log("[INFO] " + className + " - " + message, 20000, className);
    }

    public void debug(String message, String className) {
        this.log("[DEBUG] " + className + " - " + message, 10000, className);
    }

    public void enter(String method, String className) {
        this.log("[ENTER] " + className + "::" + method, 10000, className, (byte)5);
    }

    public void exit(String method, String className) {
        this.log("[EXIT] " + className + "::" + method, 10000, className, (byte)6);
    }

    private void log(String tracemsg, int level, String className) {
        this.log(tracemsg, level, className, (byte)11);
    }

    private void log(String tracemsg, int level, String className, byte action) {
        if (!(this.m_debugLogger != null && this.m_debugLogger.isDebugEnabled() || !this.isTraceLoggerNull() && this.m_traceLogger.isEnabled(level))) {
            return;
        }
        LogTraceIndication indication = new LogTraceIndication(VIEWERCOMPONENT, 0);
        indication.setObject(null != className ? className : VIEWERCOMPONENT);
        indication.setAction(action);
        indication.setLevel(level);
        indication.setMessage(tracemsg);
        this.logTraceUsingDebugLogger(indication);
        if (!this.isTraceLoggerNull() && this.m_traceLogger.isEnabled(level)) {
            this.m_traceLogger.log((Object)indication);
        }
    }

    private void logTraceUsingDebugLogger(LogTraceIndication indication) {
        if (this.m_debugLogger != null && this.m_debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            this.m_debugLogger.log(buffer.append(new Date(indication.getTime())).append("\t").append(indication.getLoggerName()).append("\t").append(indication.getThreadID()).append("\t").append(indication.getMessage()).append("\n").toString());
        }
    }

    public boolean isTraceLoggerNull() {
        return null == this.m_traceLogger;
    }

    public void audit(int iLevel, String sName, String sOperation, String sStatus, String sLogData, String sObjectPath, String sRequestID) {
        this.audit(iLevel, sName, sOperation, sStatus, sLogData, sObjectPath, sRequestID, null);
    }

    public void audit(int iLevel, String sName, String sOperation, String sStatus, String sLogData, String sObjectPath, String sRequestID, String sSessionID) {
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)sName, LogAuditIndication.class);
        if (arlog == null || !arlog.isEnabled(iLevel)) {
            return;
        }
        LogAuditAccessIndication aind = new LogAuditAccessIndication(VIEWERCOMPONENT, 3);
        aind.setLevel(iLevel);
        aind.setOperation(sOperation);
        aind.setObjectPath(sObjectPath);
        aind.setObjectType(this.getObjectType(sObjectPath));
        aind.setStatus(sStatus);
        aind.setLogData(sLogData);
        aind.setRequestID(sRequestID);
        if (sSessionID != null) {
            aind.setSessionID(sSessionID);
        }
        arlog.log((Object)aind);
    }

    private String getObjectType(String sObjectPath) {
        String sObjectType = "REPORT";
        if (sObjectPath.indexOf("reportView") > -1) {
            sObjectType = "REPORTVIEW";
        } else if (sObjectPath.indexOf("query") > -1) {
            sObjectType = "QUERY";
        } else if (sObjectPath.indexOf("analysis") > -1) {
            sObjectType = "ANALYSIS";
        }
        return sObjectType;
    }

    public void traceSOAP(int iLevel, String sName, byte byAction, String sObject, BIBusEnvelope busEnvelope) {
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)sName, LogTraceIndication.class);
        if (arlog == null || !arlog.isEnabled(iLevel)) {
            return;
        }
        try {
            String sMessage = busEnvelope.getAsString();
            if (sMessage != null) {
                sMessage = sMessage.substring(sMessage.indexOf(">") + 1);
                this.performTrace(arlog, iLevel, byAction, sObject, sMessage);
            }
        }
        catch (IOException ioe) {
            StackTraceElement[] stackTrace = ioe.getStackTrace();
            StringBuffer sbTrace = new StringBuffer();
            for (int i = 0; i < stackTrace.length; ++i) {
                sbTrace.append("[" + stackTrace[i].toString() + "] ");
            }
            this.performTrace(arlog, iLevel, byAction, sObject, sbTrace.toString());
        }
    }

    private void performTrace(LogTypedLogger arlog, int iLevel, byte byAction, String sObject, String sMessage) {
        LogTraceIndication aind = new LogTraceIndication(VIEWERCOMPONENT, 3);
        aind.setLevel(iLevel);
        aind.setAction(byAction);
        aind.setObject(sObject);
        sMessage = sMessage.replaceAll("(\n|\r)", "");
        sMessage = sMessage.replaceAll("\t", " ");
        aind.setMessage(sMessage);
        arlog.log((Object)aind);
    }

    public void startOverallPerf(int iLevel, String sName, String sMessage) {
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)sName, LogPerfIndication.class);
        if (arlog == null || !arlog.isEnabled(iLevel) || this.m_overallPerfIndication != null || this.m_overallCntSet != null) {
            return;
        }
        this.m_overallCntSet = new CCLResourceCounterSet("Execution", null);
        this.m_overallPerfIndication = new LogPerfIndication(VIEWERCOMPONENT, 3, this.m_overallCntSet);
        this.m_overallPerfIndication.setLevel(iLevel);
        this.m_overallPerfIndication.setLogData(sMessage);
        this.m_overallPerfIndication.setStatus("BEGIN");
        this.m_overallCntSet.enableResourceCounter();
        arlog.log((Object)this.m_overallPerfIndication);
    }

    public void stopOverallPerf(int iLevel, String sName, String sMessage) {
        if (this.m_overallPerfIndication == null || this.m_overallCntSet == null) {
            return;
        }
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)sName, LogPerfIndication.class);
        if (arlog == null || !arlog.isEnabled(iLevel)) {
            return;
        }
        this.m_overallCntSet.disableResourceCounter();
        this.m_overallPerfIndication.setStatus("FINISH");
        this.m_overallPerfIndication.setLogData(sMessage);
        arlog.log((Object)this.m_overallPerfIndication);
        this.m_overallCntSet = null;
        this.m_overallPerfIndication = null;
    }

    public PerfData startPerf(int iLevel, String sName, String sMessage, String sStatus) {
        if (this.m_overallPerfIndication == null) {
            return null;
        }
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)sName, LogPerfIndication.class);
        if (arlog == null || !arlog.isEnabled(iLevel)) {
            return null;
        }
        CCLResourceCounterSet curCntSet = new CCLResourceCounterSet("Execution", null);
        curCntSet.enableResourceCounter();
        LogPerfIndication curPerfIndication = new LogPerfIndication(VIEWERCOMPONENT, 3, curCntSet);
        curPerfIndication.setLevel(iLevel);
        curPerfIndication.setLogData(sMessage);
        curPerfIndication.setStatus(sStatus);
        arlog.log((Object)curPerfIndication);
        return new PerfData(iLevel, sName, curPerfIndication, curCntSet);
    }

    public void stopPerf(PerfData curPerfData, String sMessage, String sStatus) {
        if (curPerfData == null) {
            return;
        }
        LogTypedLogger arlog = LogTypedLogger.getInstance((String)curPerfData.getName(), LogPerfIndication.class);
        if (arlog == null || !arlog.isEnabled(curPerfData.getLevel())) {
            return;
        }
        CCLResourceCounterSet curCntSet = curPerfData.getCntSet();
        curCntSet.disableResourceCounter();
        LogPerfIndication curPerfIndication = curPerfData.getPerfIndication();
        curPerfIndication.setLogData(sMessage);
        curPerfIndication.setStatus(sStatus);
        arlog.log((Object)curPerfIndication);
    }

    protected LogTypedLogger getTraceLogger() {
        return this.m_traceLogger;
    }

    public DebugLogger getDebugLogger() {
        return this.m_debugLogger;
    }

    public void setDebugLogger(DebugLogger logger) {
        this.m_debugLogger = logger;
    }

    static {
        ipfLoggableRequests.add("run");
        ipfLoggableRequests.add("runSpecification");
        ipfLoggableRequests.add("bux");
        ipfLoggableRequests.add("wait");
        ipfLoggableRequests.add("runBux");
        ipfLoggableRequests.add("modifyReport");
    }

    public static class PerfData {
        private LogPerfIndication m_perfIndication = null;
        private int m_iLevel = 0;
        private String m_sName = null;
        private CCLResourceCounterSet m_cntSet = null;

        public PerfData(int iLevel, String sName, LogPerfIndication perfIndication, CCLResourceCounterSet cntSet) {
            this.m_perfIndication = perfIndication;
            this.m_iLevel = iLevel;
            this.m_sName = sName;
            this.m_cntSet = cntSet;
        }

        public LogPerfIndication getPerfIndication() {
            return this.m_perfIndication;
        }

        public int getLevel() {
            return this.m_iLevel;
        }

        public String getName() {
            return this.m_sName;
        }

        public CCLResourceCounterSet getCntSet() {
            return this.m_cntSet;
        }
    }
}

