/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.utility.JSONable;
import com.cognos.xts.ext.XTSExt;

public class JSONObject {
    private StringBuilder m_sbStringBuffer;
    private boolean m_bMore;
    private int m_iArrayLevel;
    private int m_iObjectLevel;

    public JSONObject() {
        this.m_sbStringBuffer = new StringBuilder();
        this.m_bMore = false;
        this.m_iArrayLevel = 0;
        this.m_iObjectLevel = 0;
    }

    public JSONObject(StringBuilder sbStringBuffer) {
        this.m_sbStringBuffer = sbStringBuffer;
        this.m_bMore = false;
        this.m_iArrayLevel = 0;
        this.m_iObjectLevel = 0;
    }

    public void addMember(String sName, String sValue, boolean bEncodeMember, boolean bEncodeValue) {
        this.addMember(sName, bEncodeMember);
        this.addValue(sValue, bEncodeValue);
    }

    public void addNotNullMember(String sName, String sValue, boolean bEncodeMember, boolean bEncodeValue) {
        if (sValue != null) {
            this.addMember(sName, sValue, bEncodeMember, bEncodeValue);
        }
    }

    private void addMember(String sName, boolean bEncode) {
        if (this.m_bMore) {
            this.m_sbStringBuffer.append(',');
            this.m_sbStringBuffer.append(' ');
        }
        this.m_sbStringBuffer.append("\"");
        if (bEncode) {
            String sEncodedValue = XTSExt.javascriptencode((String)sName);
            this.m_sbStringBuffer.append(sEncodedValue);
        } else {
            this.m_sbStringBuffer.append(sName);
        }
        this.m_sbStringBuffer.append("\"");
        this.m_sbStringBuffer.append(':');
        this.m_sbStringBuffer.append(' ');
    }

    private void addFirstMember(String sName, boolean bEncode) {
        this.m_sbStringBuffer.append(' ');
        this.m_sbStringBuffer.append("\"");
        if (bEncode) {
            String sEncodedValue = XTSExt.javascriptencode((String)sName);
            this.m_sbStringBuffer.append(sEncodedValue);
        } else {
            this.m_sbStringBuffer.append(sName);
        }
        this.m_sbStringBuffer.append("\"");
        this.m_sbStringBuffer.append(':');
        this.m_sbStringBuffer.append(' ');
    }

    public void addFirstMember(String sName, String value, boolean bEncodeMember, boolean bEncodeValue) {
        this.addFirstMember(sName, bEncodeMember);
        this.addValue(value, bEncodeValue);
    }

    public void addMember(String sName, int iValue, boolean bEncodeMember) {
        this.addMember(sName, bEncodeMember);
        this.addValue(iValue);
    }

    public void addMember(String sName, boolean bValue, boolean bEncodeMember) {
        this.addMember(sName, bEncodeMember);
        this.addValue(bValue);
    }

    public void addObjectMember(String sName, boolean bEncode) {
        this.addMember(sName, bEncode);
        this.addObject();
    }

    public void addArrayMember(String sName, boolean bEncode) {
        this.addMember(sName, bEncode);
        this.addArray();
    }

    public void addArrayValue(String sValue, boolean bEncode) {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("addArrayValue() called without addArray()");
        }
        if (this.m_bMore) {
            this.m_sbStringBuffer.append(',');
            this.m_sbStringBuffer.append(' ');
        }
        this.addValue(sValue, bEncode);
    }

    public void addArrayObject(String sObject, boolean bAddObjectDelimiters) {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("addArrayObject() called without addArray()");
        }
        if (this.m_bMore) {
            this.m_sbStringBuffer.append(',');
            this.m_sbStringBuffer.append(' ');
        }
        if (bAddObjectDelimiters) {
            this.m_sbStringBuffer.append("{ ");
        }
        this.m_sbStringBuffer.append(sObject);
        if (bAddObjectDelimiters) {
            this.m_sbStringBuffer.append(" }");
        }
        this.m_bMore = true;
    }

    public void addArrayObject(JSONable obj) {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("addArrayObject() called without addArray()");
        }
        if (this.m_bMore) {
            this.m_sbStringBuffer.append(',');
            this.m_sbStringBuffer.append(' ');
        }
        this.m_sbStringBuffer.append("{ ");
        this.m_bMore = false;
        if (obj != null) {
            obj.toJSON(this);
        }
        this.m_sbStringBuffer.append(" }");
        this.m_bMore = true;
    }

    private void addObject() {
        this.m_sbStringBuffer.append('{');
        this.m_sbStringBuffer.append(' ');
        this.m_bMore = false;
        ++this.m_iObjectLevel;
    }

    public void endObject() {
        if (this.m_iObjectLevel <= 0) {
            throw new RuntimeException("endObject() called without addObject()");
        }
        this.m_sbStringBuffer.append(' ');
        this.m_sbStringBuffer.append('}');
        this.m_bMore = true;
        --this.m_iObjectLevel;
    }

    private void addArray() {
        this.m_sbStringBuffer.append('[');
        this.m_sbStringBuffer.append(' ');
        this.m_bMore = false;
        ++this.m_iArrayLevel;
    }

    public void endArray() {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("endArray() called without addArray()");
        }
        this.m_sbStringBuffer.append(' ');
        this.m_sbStringBuffer.append(']');
        this.m_bMore = true;
        --this.m_iArrayLevel;
    }

    public void endNestedSubArray() {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("endArray() called without addArray()");
        }
        this.m_sbStringBuffer.append(' ');
        this.m_sbStringBuffer.append('}');
        this.m_sbStringBuffer.append(']');
        this.m_bMore = true;
        --this.m_iArrayLevel;
    }

    public void endNestedArray() {
        if (this.m_iArrayLevel <= 0) {
            throw new RuntimeException("endArray() called without addArray()");
        }
        this.m_sbStringBuffer.append(' ');
        this.m_sbStringBuffer.append('}');
        this.m_bMore = true;
        --this.m_iArrayLevel;
    }

    private void addValue(String sValue, boolean bEncode) {
        this.m_sbStringBuffer.append('\"');
        if (bEncode) {
            String sEncodedValue = XTSExt.javascriptencode((String)sValue);
            this.m_sbStringBuffer.append(sEncodedValue);
        } else {
            this.m_sbStringBuffer.append(sValue);
        }
        this.m_sbStringBuffer.append('\"');
        this.m_bMore = true;
    }

    private void addValue(int iValue) {
        this.m_sbStringBuffer.append(iValue);
        this.m_bMore = true;
    }

    private void addValue(boolean bValue) {
        this.m_sbStringBuffer.append(bValue);
        this.m_bMore = true;
    }

    public void write(StringBuilder sbOut) {
        if (this.m_iArrayLevel > 0 || this.m_iObjectLevel > 0) {
            throw new RuntimeException("unbalanced nesting objects or arrays");
        }
        sbOut.append('{');
        sbOut.append(' ');
        sbOut.append(this.m_sbStringBuffer.toString());
        sbOut.append(' ');
        sbOut.append('}');
    }
}

