/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.NBValue;
import com.cognos.viewer.utility.NameValuePairList;
import com.cognos.viewer.utility.NullValue;
import com.cognos.viewer.utility.PeekableReader;
import com.cognos.viewer.utility.RangeValue;
import com.cognos.viewer.utility.SimpleValue;
import com.cognos.viewer.utility.Value;
import java.io.IOException;
import java.io.StringReader;

public class PPFilterToParameter {
    public static String GetParametersFromFilter(String filter) {
        return PPFilterToParameter.getParametersFromFilter(filter, false);
    }

    private static String getParametersFromFilter(String filter, boolean printError) {
        if (filter == null || filter.length() == 0) {
            return "";
        }
        NameValuePairList params = new NameValuePairList();
        PeekableReader reader = new PeekableReader(new StringReader(filter), filter.length());
        try {
            PPFilterToParameter.parseFilter(params, reader);
        }
        catch (Exception e) {
            if (printError) {
                System.out.println("Exception: " + e.getMessage());
            }
            IPFLogger.getInstance().error(e.getMessage(), e, PPFilterToParameter.class.getName());
        }
        return params.getXML();
    }

    private static void parseFilter(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 91) {
            throw new IOException("Invalid filter - Missing '['!");
        }
        PPFilterToParameter.parsePredicateList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid filter - Missing ']'!");
        }
    }

    private static void parsePredicateList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parsePredicate(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parsePredicate(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parsePredicate(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c != 91) {
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseANDConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid predicator - Missing ']'!");
        }
    }

    private static void parseANDConditionList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parseANDCondition(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parseANDCondition(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parseANDCondition(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
            return;
        }
        if (c != 91) {
            PPFilterToParameter.parseNVPair(params, reader);
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseORConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid ANDCondition - Missing ']'!");
        }
    }

    private static void parseORConditionList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parseORCondition(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parseORCondition(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parseORCondition(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
            return;
        }
        if (c != 91) {
            PPFilterToParameter.parseNVPair(params, reader);
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseANDConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid ORCondition - Missing ']'!");
        }
    }

    private static void parseNVPair(NameValuePairList params, PeekableReader reader) throws IOException {
        String name = PPFilterToParameter.parseName(params, reader);
        if (name.length() == 0) {
            throw new IOException("Empty name encountered!");
        }
        int c = reader.skipSpacesAndRead();
        if (c != 61) {
            throw new IOException("Invalid NVPair - Missing '='!");
        }
        Value value = PPFilterToParameter.parseValue(params, reader);
        params.add(name, value);
    }

    private static String parseName(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 34) {
            return PPFilterToParameter.parseText(params, reader);
        }
        return PPFilterToParameter.parseFunction(params, reader);
    }

    private static String parseText(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 34) {
            throw new IOException("Invalid Text - Not start with '\"'!");
        }
        String text = reader.getEnclosedText();
        c = reader.read();
        if (c != 34) {
            throw new IOException("Invalid Text - Not end with '\"'!");
        }
        return text;
    }

    private static String parseFunction(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        while (c != 40) {
            c = reader.read();
            if (c != -1) continue;
            throw new IOException("Invalid Function - Missing '('!");
        }
        String text = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 41) {
            throw new IOException("Invalid Text - Not end with ')'!");
        }
        return text;
    }

    private static Value parseValue(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 40) {
            return PPFilterToParameter.parseRangeValue(params, reader);
        }
        if (c == 34) {
            return PPFilterToParameter.parseSimpleValue(params, reader);
        }
        c = reader.skipSpacesAndRead();
        if (c == 78) {
            c = reader.read();
            if (c == 66) {
                return new NBValue();
            }
            if (c == 85 && (c = reader.read()) == 76 && (c = reader.read()) == 76) {
                return new NullValue();
            }
        }
        throw new IOException("Invalid Value - Neither NULL nor NB!");
    }

    private static Value parseRangeValue(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 40) {
            throw new IOException("Invalid Range Value - Not start with '('!");
        }
        String start = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 44) {
            throw new IOException("Invalid Range Value - Missing ','!");
        }
        String end = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 41) {
            throw new IOException("Invalid Range Value - Not end with ')'!");
        }
        return new RangeValue(start, end);
    }

    private static Value parseSimpleValue(NameValuePairList params, PeekableReader reader) throws IOException {
        String text = PPFilterToParameter.parseText(params, reader);
        return new SimpleValue(text);
    }
}

