/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.viewer.controller.CognosViewerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class StreamUtility {
    public static int BUFFER_SIZE = 16384;

    public static StringBuilder createStringBufferFromInputStream(InputStream inputStream) throws CognosViewerException, UnsupportedEncodingException, IOException {
        return StreamUtility.createStringBufferFromInputStream(inputStream, -1);
    }

    public static StringBuilder createStringBufferFromInputStream(InputStream inputStream, int maxMegabytes) throws CognosViewerException, UnsupportedEncodingException, IOException {
        StringBuilder sbOutput = new StringBuilder();
        if (inputStream == null) {
            return sbOutput;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StreamUtility.bufferInputStream(sbOutput, inputStreamReader, BUFFER_SIZE, maxMegabytes);
        return sbOutput;
    }

    public static void bufferInputStream(StringBuilder sbOutput, InputStreamReader inputStream, int maxMegabytes) throws CognosViewerException, UnsupportedEncodingException, IOException {
        StreamUtility.bufferInputStream(sbOutput, inputStream, BUFFER_SIZE, maxMegabytes);
    }

    public static void bufferInputStream(StringBuilder sbOutput, InputStreamReader inputStream, int bufferSize, int maxMegabytes) throws CognosViewerException, UnsupportedEncodingException, IOException {
        if (inputStream == null) {
            return;
        }
        int count = 0;
        int byteCount = 0;
        int megabyteCount = 0;
        char[] c = new char[bufferSize];
        while ((count = inputStream.read(c)) > -1) {
            if (maxMegabytes > 0) {
                if ((byteCount += count) > 0x100000) {
                    ++megabyteCount;
                    byteCount -= 0x100000;
                }
                if (megabyteCount == maxMegabytes) {
                    inputStream.close();
                    throw new CognosViewerException(null);
                }
            }
            sbOutput.append(c, 0, count);
        }
        inputStream.close();
    }
}

