/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.URLValidator;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class TransientSpec {
    private ICognosViewerState m_state = null;
    private Element m_transientNode = null;
    private Element m_reportParameters = null;
    private Element m_burstItems = null;

    public TransientSpec(ICognosViewerState state) {
        this.m_state = state;
    }

    public void initialize(String sWeb64EncodedString) throws CognosViewerException {
        if (sWeb64EncodedString != null && sWeb64EncodedString.length() != 0) {
            String sTransients = XTSExt.web64decode((String)sWeb64EncodedString, (boolean)true);
            this.validateTransientSpec(sTransients);
            try {
                Document document = XMLUtility.createXMLDocument(sTransients);
                this.m_transientNode = document.getRootElement();
                this.initBurstInfo(this.m_transientNode);
                this.m_reportParameters = this.m_transientNode.element("reportParameters");
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                throw cognosViewerException;
            }
        }
    }

    private void validateTransientSpec(String sTransients) throws CognosViewerException {
        if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("validationActive")) {
            URLValidator uv = new URLValidator();
            try {
                uv.buildInputData("globalViewerTransient", sTransients);
            }
            catch (Exception e) {
                this.m_state.getIPFLogger().error("Caught exception in validateParameters: " + e.getMessage(), e, this.getClass().getName());
            }
            uv.validate(this.m_state.getBusEnvelope());
        }
    }

    public void writeMetaTags(StringBuffer sbOutput) {
        List burstItemsList;
        List parameterValueList;
        String sPromptChannel = this.m_state.getFormFieldAsString("fragment.promptChannel");
        if (sPromptChannel.length() > 0) {
            sPromptChannel = "PROMPTCHANNEL_" + sPromptChannel;
        }
        if (this.m_transientNode != null && (parameterValueList = this.getReportParameterList()) != null) {
            int iParameterValueListSize = parameterValueList.size();
            for (int parameterValueIndex = 0; parameterValueIndex < iParameterValueListSize; ++parameterValueIndex) {
                Element reportParameter = (Element)parameterValueList.get(parameterValueIndex);
                String sName = reportParameter.attributeValue("parameterName");
                sbOutput.append("<transientProperties name=\"p_" + EncodingUtility.xmlencode(sPromptChannel + sName) + "\">");
                sbOutput.append("</transientProperties>");
            }
        }
        if (this.m_burstItems != null && (burstItemsList = this.getBurstItemList()) != null) {
            for (int burstItemIndex = 0; burstItemIndex < burstItemsList.size(); ++burstItemIndex) {
                Element burstItem = (Element)burstItemsList.get(burstItemIndex);
                String sBurstName = burstItem.attributeValue("burstName");
                sbOutput.append("<transientProperties name=\"p_" + EncodingUtility.xmlencode(sPromptChannel + sBurstName) + "\">");
                sbOutput.append("</transientProperties>");
            }
        }
    }

    public List getReportParameterList() {
        if (this.m_reportParameters != null) {
            return this.m_reportParameters.elements("reportParameter");
        }
        return null;
    }

    public List getBurstItemList() {
        if (this.m_burstItems != null) {
            return this.m_burstItems.elements("burstItem");
        }
        return null;
    }

    private void initBurstInfo(Element rootElement) {
        Element burstNode = rootElement.element("burst");
        if (burstNode != null) {
            this.m_burstItems = burstNode.element("burstItems");
        }
    }

    public boolean hasBurstSpec() {
        if (this.getBurstItemList() != null) {
            return this.getBurstItemList().size() > 0;
        }
        return false;
    }

    public boolean hasAllNeededParameters(ParameterValueManager parameterManager) {
        List parameterValueList = this.getReportParameterList();
        if (parameterValueList != null) {
            int iParameterValueListSize = parameterValueList.size();
            for (int parameterValueIndex = 0; parameterValueIndex < iParameterValueListSize; ++parameterValueIndex) {
                Element reportParameter = (Element)parameterValueList.get(parameterValueIndex);
                String sName = reportParameter.attributeValue("parameterName");
                ParameterValue paramValue = parameterManager.getParameterValue(sName);
                if (paramValue != null && paramValue.getValue().length != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasAllNeededBurstParameters(ParameterValueManager parameterManager) {
        List burstValueList = this.getBurstItemList();
        if (burstValueList != null) {
            for (int iBurstValueItem = 0; iBurstValueItem < burstValueList.size(); ++iBurstValueItem) {
                Element burstItem = (Element)burstValueList.get(iBurstValueItem);
                String sBurstName = burstItem.attributeValue("burstName");
                ParameterValue paramValue = parameterManager.getParameterValue(sBurstName);
                if (paramValue != null && paramValue.getValue().length != 0) continue;
                return false;
            }
        }
        return true;
    }

    public Element getReportParameters() {
        return this.m_reportParameters;
    }

    public Element getBurstParameters() {
        return this.m_burstItems;
    }
}

