/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameter;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class URLValidator {
    private static VerifySession m_verifySession;
    private HashMapParameter m_hmParameters = new HashMapParameter();
    private static final String VALIDATION_RESOURCE = "com/cognos/viewer/validation_rules.xml";
    private static final String VALIDATION_NAMESPACE = "urn:cognos:viewer";
    private static ValidatorFactory m_factory;
    private static boolean m_isInitialized;
    private static HashMap<String, String> m_hmProxyPrefix;

    public void buildInputData(String id, String value) {
        if ("cv.webcontent".equals(id) || "cv.gateway".equals(id)) {
            for (String sProxy : m_hmProxyPrefix.values()) {
                if (!value.startsWith(sProxy)) continue;
                if ((value = value.substring(sProxy.length())).indexOf("/") == -1) break;
                String[] aProxyParts = value.split("/");
                String sDecodedValue = "";
                int iSize = aProxyParts.length;
                for (int i = 0; i < iSize; ++i) {
                    if (aProxyParts[i].length() <= 0) continue;
                    if (i > 0) {
                        sDecodedValue = sDecodedValue + "/";
                    }
                    sDecodedValue = sDecodedValue + EncodingUtility.urldecode(aProxyParts[i]);
                }
                value = sDecodedValue.replaceFirst("/", "://");
                break;
            }
        }
        this.m_hmParameters.put(id, value);
    }

    public IParameterUpdater getInputData() {
        return this.m_hmParameters;
    }

    public static void init(boolean validationMandatoryRules) {
        if (m_isInitialized) {
            return;
        }
        try {
            m_factory = ValidatorFactory.newInstance();
            m_factory.put(0, validationMandatoryRules);
            Document doc = m_factory.createDocument();
            if (!doc.loadFromNamespace(VALIDATION_NAMESPACE)) {
                ClassLoader cl = URLValidator.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(VALIDATION_RESOURCE);
                InputStreamReader isr = new InputStreamReader(is);
                doc.loadFromXML((Reader)isr);
            }
            m_verifySession = m_factory.createVerifySession(doc);
            m_isInitialized = true;
        }
        catch (ValidatorException ve) {
            IPFLogger.getInstance().error("URLValidator::init() - ValidatorFactory initialisation failed." + ve.getMessage(), ve, URLValidator.class.getName());
        }
    }

    public void throwValidationError(BIBusEnvelope busEnvelope, Exception e) throws CognosViewerException {
        if (!MessageManager.isInitialized()) {
            MessageManager.initialize();
        }
        CognosViewerException cognosViewerException = new CognosViewerException(busEnvelope, MessageManager.convert("RV_VALIDATION", CognosViewerDispatcherHandlerState.getFaultLocale(busEnvelope)), e);
        throw cognosViewerException;
    }

    public void validate(BIBusEnvelope busEnvelope) throws CognosViewerException {
        if (!m_isInitialized) {
            URLValidator.init(false);
        }
        IParameterUpdater input_data = this.getInputData();
        try {
            m_verifySession.put(0, true);
            m_verifySession.verify(input_data);
        }
        catch (VerifyException e) {
            CognosViewerException cognosViewerException = new CognosViewerException(busEnvelope, MessageManager.convert("RV_VALIDATION", CognosViewerDispatcherHandlerState.getFaultLocale(busEnvelope)), (Exception)((Object)e), e.getFailureDetails());
            throw cognosViewerException;
        }
        catch (ValidatorException e) {
            this.throwValidationError(busEnvelope, (Exception)((Object)e));
        }
    }

    public static boolean IsInitialized() {
        return m_isInitialized;
    }

    public static void addProxyPrefix(String sPrefix) {
        m_hmProxyPrefix.put(sPrefix, sPrefix);
    }

    public static HashMap getProxyPrefix() {
        return m_hmProxyPrefix;
    }

    static {
        m_factory = null;
        m_isInitialized = false;
        m_hmProxyPrefix = new HashMap();
        m_hmProxyPrefix.put("/mum/proxy/", "/mum/proxy/");
        m_hmProxyPrefix.put("/mum/cognosProxy/", "/mum/cognosProxy/");
        m_hmProxyPrefix.put("/wps/proxy/", "/wps/proxy/");
    }

    public static class HashMapParameter
    implements IParameterUpdater {
        private Iterator m_iterator = null;
        private HashMap m_hashMap = new HashMap();

        public void put(String name, String value) {
            this.m_hashMap.put(name, value);
        }

        public boolean hasNext() {
            if (this.m_iterator == null) {
                this.m_iterator = this.m_hashMap.entrySet().iterator();
            }
            return this.m_iterator.hasNext();
        }

        public IParameter next() {
            Map.Entry entry = (Map.Entry)this.m_iterator.next();
            return new Parameter(entry);
        }

        public void reset() {
            this.m_iterator = null;
        }

        static class Parameter
        implements IParameter {
            private String m_name = null;
            private String[] m_values = null;

            Parameter(Map.Entry entry) {
                this.m_name = (String)entry.getKey();
                this.m_values = new String[1];
                this.m_values[0] = (String)entry.getValue();
            }

            public String name() {
                return this.m_name;
            }

            public String[] values() {
                return this.m_values;
            }

            public void setValues(String[] arg0) {
            }
        }
    }
}

