/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.utility;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.XMLUtility;
import com.ibm.cognos.pogo.zipi.MarkerType;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Node;

public class ZIPIUtility {
    private static final String RUNTIME_STATE_INFO = "RTStateInfo";
    private static final String RUNTIME_STATE_INFO_DB_TITLE = "dbTitle";
    private static final String RUNTIME_STATE_INFO_DB_SEARCHPATH = "dbSearchPath";
    private static final String RUNTIME_STATE_INFO_WIDGETTITLE = "widgetTitle";
    private static ZIPIUtility _instance;
    private static Set<String> actions_to_skip_gestures;

    private ZIPIUtility() {
    }

    public static ZIPIUtility getInstance() {
        if (_instance == null) {
            _instance = new ZIPIUtility();
        }
        return _instance;
    }

    public ZipiTimer doZIPI(CognosViewerDispatcherHandlerState cognosViewerState, String actionName, boolean isMarkerNeeded) {
        if (cognosViewerState != null) {
            String uiAction;
            String stateActionName = cognosViewerState.getAction();
            String string = uiAction = actionName != null ? actionName : stateActionName;
            if (uiAction != null && uiAction.length() > 0) {
                String infoXML;
                return this.doZIPI_with_infoStr(uiAction, infoXML, (infoXML = cognosViewerState.getBUXRTStateInfo()) != null && infoXML.length() > 0, isMarkerNeeded && !actions_to_skip_gestures.contains(stateActionName));
            }
        }
        return null;
    }

    public ZipiTimer doZIPI_with_infoStr(String actionName, String infoXML, boolean isZIPINeeded, boolean isMarkerNeeded) {
        Document eleInfoXML = null;
        if (infoXML != null && infoXML.trim().length() > 0) {
            eleInfoXML = XMLUtility.createXMLDocument(infoXML);
            return this.doZIPI(actionName, (Node)eleInfoXML, isZIPINeeded, isMarkerNeeded);
        }
        return null;
    }

    public boolean isZIPIEnablded() {
        return CognosViewerDispatcherHandler.getConfigValues().getBoolean("DISP.zipi.enabled");
    }

    public ZipiTimer doZIPI(String actionName, Node infoXML, boolean isZIPINeeded, boolean isMarkerNeeded) {
        ZipiTimer timer = null;
        if (this.isZIPIEnablded() && isZIPINeeded && infoXML != null && actionName != null) {
            String widgetTitle = "";
            String dbSearchPath = "";
            String dbTitle = "";
            Node stateInfoNode = infoXML.selectSingleNode(RUNTIME_STATE_INFO);
            if (stateInfoNode != null) {
                Node widgetTitleNode;
                Node searchPathNode = stateInfoNode.selectSingleNode(RUNTIME_STATE_INFO_DB_SEARCHPATH);
                if (searchPathNode != null) {
                    dbSearchPath = searchPathNode.getText();
                    Node titleNode = stateInfoNode.selectSingleNode(RUNTIME_STATE_INFO_DB_TITLE);
                    if (titleNode != null) {
                        dbTitle = titleNode.getText();
                    }
                }
                if ((widgetTitleNode = stateInfoNode.selectSingleNode(RUNTIME_STATE_INFO_WIDGETTITLE)) != null) {
                    widgetTitle = widgetTitleNode.getText();
                }
            }
            timer = this.doZipiTimer(actionName, widgetTitle);
            if (isMarkerNeeded) {
                MarkerType type = MarkerType.DASHBOARD;
                if (dbSearchPath == null || dbSearchPath.trim().length() == 0 || dbSearchPath.equals("null")) {
                    dbSearchPath = dbTitle;
                    type = MarkerType.ADHOC;
                }
                ZipiAPI.createMarker((MarkerType)type, (String)actionName, (String)dbTitle, (String)dbSearchPath);
            }
        }
        return timer;
    }

    public ZipiTimer doZipiTimer(String actionName, BIBusEnvelope biBusEnvelope) {
        if (this.isZIPIEnablded()) {
            return this.doZipiTimer(actionName, this.getObjectPath(biBusEnvelope));
        }
        return null;
    }

    public String getObjectPath(BIBusEnvelope biBusEnvelope) {
        String objectPath = biBusEnvelope.getFormValue(RUNTIME_STATE_INFO_WIDGETTITLE);
        if (objectPath == null) {
            objectPath = biBusEnvelope.getFormValue("ui.object");
        }
        return objectPath;
    }

    private ZipiTimer doZipiTimer(String actionName, String widgetTitle) {
        ZipiTimer timer = ZipiAPI.startTimer((String)("cv." + actionName));
        timer.setObjectPath(widgetTitle);
        return timer;
    }

    public void stopZipiTimer(ZipiTimer timer) {
        if (timer != null) {
            timer.stop();
        }
    }

    static {
        actions_to_skip_gestures = new HashSet<String>(2);
        actions_to_skip_gestures.add("runBux");
        actions_to_skip_gestures.add("wait");
        actions_to_skip_gestures.add("modifyReport");
    }
}

