/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.caf.CAFLibrary;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.BUXJSONToolbar;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.xts.ext.XTSExt;

public class ActiveReportOutput
extends CvOutput {
    private static String[] buxAnnotations = new String[]{"NewWidgetAnnotation", "EditWidgetAnnotation", "DeleteWidgetAnnotation"};

    @Override
    protected void addResponseHeader(StringBuilder sbOutput) {
        sbOutput.append("Content-Type: text/plain; charset=utf-8");
        sbOutput.append("\r\n\r\n");
    }

    @Override
    public void generateHTML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        actionResponse.setFormFieldFromString("cv.toolbar", "false");
        actionResponse.setFormFieldFromString("cv.header", "false");
        sbOutput.append("<br style=\"display:none\" />");
        this.writeResources(actionResponse, sbOutput);
        this.writeInlineScript(actionResponse, sbOutput, false);
        ReportBodyGenerator.writeLoadingTable(actionResponse, sbOutput);
        ReportBodyGenerator.writeReportBodyDivs(sbOutput, actionResponse);
        DebugLogger debugLogger = actionResponse.getDebugLogger();
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
        CognosViewerJavaScriptObject javascriptObject = new CognosViewerJavaScriptObject(actionResponse, sbOutput);
        javascriptObject.initViewer(actionResponse, null);
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
        this.writeScriptExecutionDone(actionResponse, sbOutput);
    }

    @Override
    public void writeFormTable(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        sbOutput.append("<table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">");
        ReportBodyGenerator.writeReportBody(sbOutput, actionResponse);
        sbOutput.append(ReportBodyGenerator.writeNavigationLinks(actionResponse));
        sbOutput.append("</table>");
    }

    private void writeScriptExecutionDone(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, false);
        sbOutput.append(cvObjectRef + ".inlineScriptsDoneExecuting = true;");
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, false);
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        cvObject.addNavigationLinks(sProductLocale);
        cvObject.setCustomizableFeatures();
        cvObject.setViewerCapabities();
        cvObject.setBlackListedItems();
        cvObject.addResponseCallback("cancel", "function(){ var sCVId = \"" + actionResponse.getFormFieldAsString("cv.id") + "\"; executeBackURL(sCVId);}", false);
        cvObject.addResponseCallback("wait", "function(){setTimeout(\"window.oCV" + cvObject.getCvId() + ".wait()\", 1);}", false);
        cvObject.addResponseCallback("done", "function(){window.oCV" + cvObject.getCvId() + ".addPageAdornments();}", false);
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        StringBuilder toolbarPayload = BUXJSONToolbar.render(actionResponse, "buxActiveReportContextMenu");
        sbOutput.append(cvObjectRef + ".setToolbar(");
        sbOutput.append((CharSequence)toolbarPayload);
        sbOutput.append(");\n");
        String cafContextId = "";
        try {
            CAMPassport passport = actionResponse.getCAMPassport();
            cafContextId = CAFLibrary.getContextId((String)"rs", (String)passport.getId());
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getMessage(), ActiveReportOutput.class.getName());
            cafContextId = "";
        }
        sbOutput.append(cvObjectRef + ".cafContextId = \"" + XTSExt.javascriptencode((String)cafContextId) + "\";\n");
        this.setAnnotationInfo(sbOutput, actionResponse);
        sbOutput.append(cvObjectRef + ".isBux = true;\n");
        this.addLastAction(actionResponse, sbOutput);
        boolean bUseReportAuthoredStyles = CognosViewerDispatcherHandler.getConfigValues().getBoolean("useReportAuthoredStyles");
        sbOutput.append(cvObjectRef + ".useReportAuthoredStyles = " + bUseReportAuthoredStyles + ";\n");
        sbOutput.append(cvObjectRef + ".capabilitiesXML = \"" + XTSExt.javascriptencode((String)actionResponse.getCapabilities().getCapabilitiesXML()) + "\";\n");
    }

    private void addLastAction(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        boolean changedAction = false;
        String action = actionResponse.getAction();
        if (actionResponse.isDroppingReportBUXAction()) {
            action = "buxDropReportOnCanvas";
            changedAction = true;
        } else if (null != action && "runBux".equals(action)) {
            action = "bux";
            changedAction = true;
        }
    }

    private void writeResources(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.writeCssResources(sbOutput, actionResponse);
        this.writeJavascriptResources(sbOutput, actionResponse);
    }

    private void writeCssResources(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sWebContentRoot = actionResponse.getWebContentRoot();
        String sSkinRoot = sWebContentRoot + "/skins/" + actionResponse.getUserPreference("skin");
        sbOutput.append(this.writeCssResource(sSkinRoot, "/viewer/QSRVall.css"));
        sbOutput.append(this.writeCssResource(sSkinRoot, "/viewer/CRNFragment.css"));
    }

    private StringBuffer writeCssResource(String webContentRoot, String path) {
        return new StringBuffer("<link href=\"").append(webContentRoot).append(path).append("\" rel=\"stylesheet\"/>\n");
    }

    private void writeJavascriptResources(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        DebugLogger debugLogger;
        String sWebContentRoot = actionResponse.getWebContentRoot();
        String sLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (!"en".equals(sLocale)) {
            sbOutput.append(this.writeJavascriptResource(sWebContentRoot, "/rv/res/viewer_" + EncodingUtility.htmlencode(sLocale) + ".js"));
        }
        if ((debugLogger = actionResponse.getDebugLogger()) != null && debugLogger.isJsonLoggingOn()) {
            sbOutput.append(this.writeJavascriptResource(sWebContentRoot, "/rv/CCognosViewerDebugLogger.js"));
        }
    }

    private StringBuffer writeJavascriptResource(String webContentRoot, String path) {
        return new StringBuffer("<script src=\"").append(webContentRoot).append(path).append("\" type=\"text/javascript\"></script>\n");
    }

    private void setAnnotationInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        this.setArrayInfo(sbOutput, actionResponse, buxAnnotations, "aBuxAnnotations");
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        String annotationsAvailable = CognosViewerDispatcherHandler.isAnnotationServiceEnabled() ? "true" : "false";
        sbOutput.append(cvObjectRef + ".bBuxAnnotationsAvailable = " + annotationsAvailable + ";\n");
    }

    private void setArrayInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, String[] array, String arrayName) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        sbOutput.append(cvObjectRef + "." + arrayName + " = ");
        sbOutput.append("[ ");
        for (int index = 0; index < array.length; ++index) {
            sbOutput.append("\"");
            sbOutput.append(array[index]);
            sbOutput.append("\"");
            if (index + 1 >= array.length) continue;
            sbOutput.append(",");
        }
        sbOutput.append("];\n");
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        try {
            return this.render(faultResponse);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void writeBackJaxForm(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
    }

    @Override
    protected void writeAccessibilityNavLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
    }
}

