/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.JSONable;
import com.cognos.xts.ext.XTSExt;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Element;

public class AnnotationInfo
implements JSONable,
Comparable {
    private static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private SimpleDateFormat m_utc_formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String defaultName;
    private String searchPath;
    private String creationTime;
    private String modificationTime;
    private String formattedCreationTime;
    private String formattedModificationTime;
    private String description = "";
    private Owner owner;
    private Permissions permissions;

    public AnnotationInfo(Element annotationElement, String timezone, String locale) {
        Element traversePermission;
        Element writePermission;
        Element ownerDefaultName;
        Element searchPathEle;
        Element defaultNameEle = (Element)annotationElement.selectSingleNode("defaultName/value");
        if (defaultNameEle != null) {
            this.defaultName = defaultNameEle.getStringValue();
        }
        if ((searchPathEle = (Element)annotationElement.selectSingleNode("searchPath/value")) != null) {
            this.searchPath = searchPathEle.getStringValue();
        }
        try {
            Element modificationTimeEle;
            Element creationTimeEle = (Element)annotationElement.selectSingleNode("creationTime/value");
            if (creationTimeEle != null) {
                this.creationTime = creationTimeEle.getStringValue();
                this.formattedCreationTime = XTSExt.formatDateFromUTC((String)this.creationTime, (int)2, (int)3, (String)timezone, (String)locale);
            }
            if ((modificationTimeEle = (Element)annotationElement.selectSingleNode("modificationTime/value")) != null) {
                this.modificationTime = modificationTimeEle.getStringValue();
                this.formattedModificationTime = XTSExt.formatDateFromUTC((String)this.modificationTime, (int)2, (int)3, (String)timezone, (String)locale);
            }
        }
        catch (Exception e) {
            IPFLogger.getInstance().error("Caught exception in AnnotationInfo constructor: " + e.getMessage(), AnnotationInfo.class.getName());
        }
        Element descriptionEle = (Element)annotationElement.selectSingleNode("defaultDescription/value");
        if (descriptionEle != null) {
            this.description = descriptionEle.getStringValue();
        }
        this.owner = new Owner();
        Element ownerSearchPath = (Element)annotationElement.selectSingleNode("owner/value/item/searchPath/value");
        if (ownerSearchPath != null) {
            this.owner.searchPath = ownerSearchPath.getStringValue();
        }
        if ((ownerDefaultName = (Element)annotationElement.selectSingleNode("owner/value/item/defaultName/value")) != null) {
            this.owner.defaultName = ownerDefaultName.getStringValue();
        }
        this.permissions = new Permissions();
        Element readPermission = (Element)annotationElement.selectSingleNode("permissions/value/item[text()='read']");
        if (readPermission != null) {
            this.permissions.read = true;
        }
        if ((writePermission = (Element)annotationElement.selectSingleNode("permissions/value/item[text()='write']")) != null) {
            this.permissions.write = true;
        }
        if ((traversePermission = (Element)annotationElement.selectSingleNode("permissions/value/item[text()='traverse']")) != null) {
            this.permissions.traverse = true;
        }
    }

    @Override
    public void toJSON(JSONObject json) {
        json.addNotNullMember("defaultName", this.defaultName, false, true);
        json.addNotNullMember("searchPath", this.searchPath, false, true);
        json.addNotNullMember("creationTime", this.formattedCreationTime, false, true);
        json.addNotNullMember("modificationTime", this.formattedModificationTime, false, true);
        json.addNotNullMember("description", this.description, false, true);
        json.addNotNullMember("layoutElementId", "", false, true);
        json.addObjectMember("owner", false);
        json.addNotNullMember("searchPath", this.owner.searchPath, false, true);
        json.addNotNullMember("defaultName", this.owner.defaultName, false, true);
        json.endObject();
        json.addObjectMember("permissions", false);
        if (this.permissions.read) {
            json.addNotNullMember("read", "true", false, true);
        }
        if (this.permissions.write) {
            json.addNotNullMember("write", "true", false, true);
        }
        if (this.permissions.traverse) {
            json.addNotNullMember("traverse", "true", false, true);
        }
        json.endObject();
    }

    public int compareTo(Object rhs_o) {
        AnnotationInfo rhs_annotation = (AnnotationInfo)rhs_o;
        Date this_creationTime = this.m_utc_formatter.parse(this.creationTime, new ParsePosition(0));
        Date rhs_creationTime = this.m_utc_formatter.parse(rhs_annotation.creationTime, new ParsePosition(0));
        int result = rhs_creationTime.compareTo(this_creationTime);
        return result;
    }

    protected static class Owner {
        public String defaultName;
        public String searchPath;

        protected Owner() {
        }
    }

    protected static class Permissions {
        public boolean read;
        public boolean write;
        public boolean traverse;

        protected Permissions() {
        }
    }
}

