/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.DataOutput;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import org.dom4j.Element;

public class CMRequestOutput
extends DataOutput {
    @Override
    public void generateTextDetails(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        if (actionResponse instanceof CMServerResponse) {
            CMServerResponse cmResponse = (CMServerResponse)actionResponse;
            Element queryResponse = (Element)cmResponse.getBusEnvelope().getBody().selectSingleNode("*[local-name()='queryResponse']");
            String locale = actionResponse.getUserPreference("contentLocale");
            String timezone = actionResponse.getUserPreference("timeZoneID");
            if (queryResponse != null) {
                List items = queryResponse.selectNodes("./result/item");
                for (int iItem = 0; iItem < items.size(); ++iItem) {
                    Element item = (Element)items.get(iItem);
                    List properties = item.selectNodes("./*");
                    for (int iIndex = 0; iIndex < properties.size(); ++iIndex) {
                        Element property = (Element)properties.get(iIndex);
                        if (property.getName().indexOf("Time") == -1) continue;
                        try {
                            String datetime = property.selectSingleNode("./value").getText();
                            Element localizedDataTime = item.addElement(property.getName() + "_localized");
                            localizedDataTime.setText(XTSExt.formatDateFromUTC((String)datetime, (int)2, (int)3, (String)timezone, (String)locale));
                            continue;
                        }
                        catch (Exception e) {
                            IPFLogger.getInstance().debug("fault while localizing time in CM response", "CMRequestOutput");
                        }
                    }
                }
                sbOutput.append(queryResponse.asXML());
            }
        }
    }
}

